/*
 * Decompiled with CFR 0.152.
 */
package ic2classic.core.block.machine.tileentity;

import cpw.mods.fml.common.eventhandler.Event;
import ic2classic.api.Direction;
import ic2classic.api.energy.event.EnergyTileLoadEvent;
import ic2classic.api.energy.event.EnergyTileUnloadEvent;
import ic2classic.api.energy.tile.IEnergySink;
import ic2classic.core.ContainerIC2;
import ic2classic.core.IC2;
import ic2classic.core.IHasGui;
import ic2classic.core.Ic2Items;
import ic2classic.core.block.TileEntityCrop;
import ic2classic.core.block.machine.ContainerCropmatron;
import ic2classic.core.block.machine.tileentity.TileEntityMachine;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.MinecraftForge;

public class TileEntityCropmatron
extends TileEntityMachine
implements IEnergySink,
IHasGui {
    public int energy = 0;
    public int ticker = 0;
    public int maxEnergy = 1000;
    public int scanX = -4;
    public int scanY = -1;
    public int scanZ = -4;
    public boolean addedToEnergyNet = false;
    public static int maxInput = 32;

    public TileEntityCropmatron() {
        super(9);
    }

    @Override
    public void func_145839_a(NBTTagCompound nbttagcompound) {
        super.func_145839_a(nbttagcompound);
        this.energy = nbttagcompound.func_74765_d("energy");
    }

    @Override
    public void func_145841_b(NBTTagCompound nbttagcompound) {
        super.func_145841_b(nbttagcompound);
        nbttagcompound.func_74777_a("energy", (short)this.energy);
    }

    @Override
    public void onLoaded() {
        super.onLoaded();
        if (IC2.platform.isSimulating()) {
            MinecraftForge.EVENT_BUS.post((Event)new EnergyTileLoadEvent(this));
            this.addedToEnergyNet = true;
        }
    }

    @Override
    public void onUnloaded() {
        if (IC2.platform.isSimulating() && this.addedToEnergyNet) {
            MinecraftForge.EVENT_BUS.post((Event)new EnergyTileUnloadEvent(this));
            this.addedToEnergyNet = false;
        }
        super.onUnloaded();
    }

    @Override
    public void func_145845_h() {
        super.func_145845_h();
        if (this.energy >= 31) {
            this.scan();
        }
    }

    public void scan() {
        ++this.scanX;
        if (this.scanX > 4) {
            this.scanX = -4;
            ++this.scanZ;
            if (this.scanZ > 4) {
                this.scanZ = -4;
                ++this.scanY;
                if (this.scanY > 1) {
                    this.scanY = -1;
                }
            }
        }
        --this.energy;
        TileEntity te = this.field_145850_b.func_147438_o(this.field_145851_c + this.scanX, this.field_145848_d + this.scanY, this.field_145849_e + this.scanZ);
        if (te instanceof TileEntityCrop) {
            TileEntityCrop crop = (TileEntityCrop)te;
            this.updateSlots();
            if (this.inventory[0] != null && this.inventory[0].func_77973_b() == Ic2Items.fertilizer && crop.applyFertilizer(false)) {
                this.energy -= 10;
                --this.inventory[0].field_77994_a;
                this.checkStackSizeZero(0);
            }
            if (this.inventory[3] != null && this.inventory[3].func_77973_b() == Ic2Items.hydratingCell && crop.applyHydration(false, this.inventory[3])) {
                this.energy -= 10;
                this.checkStackSizeZero(3);
            }
            if (this.inventory[6] != null && this.inventory[6].func_77973_b() == Ic2Items.weedEx && crop.applyWeedEx(false)) {
                this.energy -= 10;
                this.inventory[6].func_77964_b(this.inventory[6].func_77960_j() + 1);
                this.inventory[6].func_77972_a(1, null);
                if (this.inventory[6].func_77960_j() >= this.inventory[6].func_77958_k()) {
                    --this.inventory[6].field_77994_a;
                    this.checkStackSizeZero(6);
                }
            }
        }
    }

    public void checkStackSizeZero(int x) {
        if (this.inventory[x] != null && this.inventory[x].field_77994_a <= 0) {
            this.inventory[x] = null;
        }
    }

    public void updateSlots() {
        this.moveFrom(1, 0);
        this.moveFrom(2, 1);
        this.moveFrom(4, 3);
        this.moveFrom(5, 4);
        this.moveFrom(7, 6);
        this.moveFrom(8, 7);
    }

    public void moveFrom(int from, int to) {
        if (this.inventory[from] != null && this.inventory[to] == null) {
            this.inventory[to] = this.inventory[from];
            this.inventory[from] = null;
        }
    }

    @Override
    public boolean IC2Classic_acceptsEnergyFrom(TileEntity emitter, Direction direction) {
        return true;
    }

    @Override
    public int IC2Classic_demandsEnergy() {
        return this.maxEnergy - this.energy;
    }

    public int gaugeEnergyScaled(int i) {
        if (this.energy <= 0) {
            return 0;
        }
        int r = this.energy * i / this.maxEnergy;
        if (r > i) {
            r = i;
        }
        return r;
    }

    @Override
    public boolean IC2Classic_injectEnergy(Direction directionFrom, int amount) {
        if (amount > maxInput) {
            IC2.explodeMachineAt(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e);
            return true;
        }
        if (this.energy >= this.maxEnergy) {
            return false;
        }
        this.energy += amount;
        return true;
    }

    @Override
    public int IC2Classic_getMaxSafeInput() {
        return maxInput;
    }

    @Override
    public String func_145825_b() {
        return "Crop-Matron";
    }

    @Override
    public String getGuiClassName(EntityPlayer entityPlayer) {
        return "block.machine.gui.GuiCropmatron";
    }

    @Override
    public ContainerIC2 getGuiContainer(EntityPlayer entityPlayer) {
        return new ContainerCropmatron(entityPlayer, this);
    }

    @Override
    public void onGuiClosed(EntityPlayer entityPlayer) {
    }

    public int[] func_94128_d(int var1) {
        if (var1 == 0) {
            return new int[]{6, 7, 8};
        }
        if (var1 == 1) {
            return new int[]{3, 4, 5};
        }
        int[] nArray = new int[3];
        nArray[1] = 1;
        nArray[2] = 2;
        return nArray;
    }
}

