/*
 * Decompiled with CFR 0.152.
 */
package ic2classic.core.block.machine.tileentity;

import cpw.mods.fml.common.eventhandler.Event;
import ic2classic.api.Direction;
import ic2classic.api.electric_item.BatteryAPI;
import ic2classic.api.energy.event.EnergyTileLoadEvent;
import ic2classic.api.energy.event.EnergyTileUnloadEvent;
import ic2classic.api.energy.tile.IEnergySink;
import ic2classic.core.IC2;
import ic2classic.core.block.machine.tileentity.TileEntityMachine;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.MinecraftForge;

public abstract class TileEntityElecMachine
extends TileEntityMachine
implements IEnergySink {
    public int energy = 0;
    public int fuelslot;
    public int maxEnergy;
    public int maxInput;
    public int tier = 0;
    public boolean addedToEnergyNet = false;

    public TileEntityElecMachine(int slots, int fuelslot, int maxenergy, int maxinput) {
        super(slots);
        this.fuelslot = fuelslot;
        this.maxEnergy = maxenergy;
        this.maxInput = maxinput;
        this.tier = 1;
    }

    public TileEntityElecMachine(int slots, int fuelslot, int maxenergy, int maxinput, int tier) {
        super(slots);
        this.fuelslot = fuelslot;
        this.maxEnergy = maxenergy;
        this.maxInput = maxinput;
        this.tier = tier;
    }

    @Override
    public void func_145839_a(NBTTagCompound nbttagcompound) {
        super.func_145839_a(nbttagcompound);
        this.energy = nbttagcompound.func_74762_e("energy");
    }

    @Override
    public void func_145841_b(NBTTagCompound nbttagcompound) {
        super.func_145841_b(nbttagcompound);
        nbttagcompound.func_74768_a("energy", this.energy);
    }

    @Override
    public void onLoaded() {
        super.onLoaded();
        if (IC2.platform.isSimulating()) {
            MinecraftForge.EVENT_BUS.post((Event)new EnergyTileLoadEvent(this));
            this.addedToEnergyNet = true;
        }
    }

    @Override
    public void onUnloaded() {
        if (IC2.platform.isSimulating() && this.addedToEnergyNet) {
            MinecraftForge.EVENT_BUS.post((Event)new EnergyTileUnloadEvent(this));
            this.addedToEnergyNet = false;
        }
        super.onUnloaded();
    }

    public boolean provideEnergy() {
        if (this.inventory[this.fuelslot] == null) {
            return false;
        }
        int transfer = BatteryAPI.discharge(this.inventory[this.fuelslot], this.maxEnergy - this.energy, this.tier, false, false);
        this.energy += transfer;
        return transfer > 0;
    }

    @Override
    public int IC2Classic_demandsEnergy() {
        return this.maxEnergy - this.energy;
    }

    @Override
    public boolean IC2Classic_injectEnergy(Direction directionFrom, int amount) {
        if (amount > this.maxInput) {
            IC2.explodeMachineAt(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e);
            return true;
        }
        if (this.energy >= this.maxEnergy) {
            return false;
        }
        this.energy += amount;
        return true;
    }

    @Override
    public int IC2Classic_getMaxSafeInput() {
        return this.maxInput;
    }

    @Override
    public boolean IC2Classic_acceptsEnergyFrom(TileEntity emitter, Direction direction) {
        return true;
    }

    public boolean isRedstonePowered() {
        return this.field_145850_b.func_72864_z(this.field_145851_c, this.field_145848_d, this.field_145849_e);
    }
}

