/*
 * Decompiled with CFR 0.152.
 */
package ic2classic.core.block.machine.tileentity;

import ic2classic.api.Direction;
import ic2classic.core.ContainerIC2;
import ic2classic.core.IC2;
import ic2classic.core.IHasGui;
import ic2classic.core.block.machine.ContainerInduction;
import ic2classic.core.block.machine.tileentity.TileEntityElecMachine;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.FurnaceRecipes;
import net.minecraft.nbt.NBTTagCompound;

public class TileEntityInduction
extends TileEntityElecMachine
implements IHasGui {
    public int soundTicker = IC2.random.nextInt(64);
    public static short maxHeat = (short)10000;
    public short heat = 0;
    public short progress = 0;

    public TileEntityInduction() {
        super(5, 2, maxHeat, 128, 2);
    }

    @Override
    public String func_145825_b() {
        if (IC2.platform.isRendering()) {
            return "Induction Furnace";
        }
        return "InductionFurnace";
    }

    @Override
    public void func_145839_a(NBTTagCompound nbttagcompound) {
        super.func_145839_a(nbttagcompound);
        this.heat = nbttagcompound.func_74765_d("heat");
        this.progress = nbttagcompound.func_74765_d("progress");
    }

    @Override
    public void func_145841_b(NBTTagCompound nbttagcompound) {
        super.func_145841_b(nbttagcompound);
        nbttagcompound.func_74777_a("heat", this.heat);
        nbttagcompound.func_74777_a("progress", this.progress);
    }

    public String getHeat() {
        return this.heat * 100 / maxHeat + "%";
    }

    public int gaugeProgressScaled(int i) {
        return i * this.progress / 4000;
    }

    public int gaugeFuelScaled(int i) {
        return i * this.energy / this.maxEnergy;
    }

    @Override
    public void func_145845_h() {
        super.func_145845_h();
        boolean needsInvUpdate = false;
        if (this.energy <= this.maxEnergy) {
            needsInvUpdate = this.provideEnergy();
        }
        boolean newActive = this.getActive();
        if (this.heat == 0) {
            newActive = false;
        }
        if (this.progress >= 4000) {
            this.operate();
            needsInvUpdate = true;
            this.progress = 0;
            newActive = false;
        }
        boolean canOperate = this.canOperate();
        if (this.energy > 0 && (canOperate || this.isRedstonePowered())) {
            --this.energy;
            if (this.heat < maxHeat) {
                this.heat = (short)(this.heat + 1);
            }
            newActive = true;
        } else {
            this.heat = (short)(this.heat - Math.min(this.heat, 4));
        }
        if (!newActive || this.progress == 0) {
            if (canOperate) {
                if (this.energy >= 15) {
                    newActive = true;
                }
            } else {
                this.progress = 0;
            }
        } else if (!canOperate || this.energy < 15) {
            if (!canOperate) {
                this.progress = 0;
            }
            newActive = false;
        }
        if (newActive && canOperate) {
            this.progress = (short)(this.progress + this.heat / 30);
            this.energy -= 15;
        }
        if (needsInvUpdate) {
            this.func_70296_d();
        }
        if (newActive != this.getActive()) {
            this.setActive(newActive);
        }
    }

    public void operate() {
        this.operate(0, 3);
        this.operate(1, 4);
    }

    public void operate(int input, int output) {
        if (!this.canOperate(input, output)) {
            return;
        }
        ItemStack itemstack = this.getResultFor(this.inventory[input]);
        if (this.inventory[output] == null) {
            this.inventory[output] = itemstack.func_77946_l();
        } else {
            this.inventory[output].field_77994_a += itemstack.field_77994_a;
        }
        if (this.inventory[input].func_77973_b().hasContainerItem(this.inventory[input])) {
            this.inventory[input] = this.inventory[input].func_77973_b().getContainerItem(this.inventory[input]);
        } else {
            --this.inventory[input].field_77994_a;
        }
        if (this.inventory[input].field_77994_a <= 0) {
            this.inventory[input] = null;
        }
    }

    public boolean canOperate() {
        return this.canOperate(0, 3) || this.canOperate(1, 4);
    }

    public boolean canOperate(int input, int output) {
        if (this.inventory[input] == null) {
            return false;
        }
        ItemStack itemstack = this.getResultFor(this.inventory[input]);
        if (itemstack == null) {
            return false;
        }
        return this.inventory[output] == null || this.inventory[output].func_77969_a(itemstack) && this.inventory[output].field_77994_a + itemstack.field_77994_a <= itemstack.func_77976_d();
    }

    public ItemStack getResultFor(ItemStack itemstack) {
        return FurnaceRecipes.func_77602_a().func_151395_a(itemstack);
    }

    @Override
    public boolean IC2Classic_injectEnergy(Direction directionFrom, int amount) {
        if (amount > 128) {
            IC2.explodeMachineAt(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e);
            return true;
        }
        if (this.energy >= this.maxEnergy) {
            return false;
        }
        this.energy += amount;
        return true;
    }

    @Override
    public ContainerIC2 getGuiContainer(EntityPlayer entityPlayer) {
        return new ContainerInduction(entityPlayer, this);
    }

    @Override
    public String getGuiClassName(EntityPlayer entityPlayer) {
        return "block.machine.gui.GuiInduction";
    }

    @Override
    public void onGuiClosed(EntityPlayer entityPlayer) {
    }

    public int[] func_94128_d(int var1) {
        if (var1 == 1) {
            int[] nArray = new int[2];
            nArray[1] = 1;
            return nArray;
        }
        if (var1 == 0) {
            return new int[]{2};
        }
        return new int[]{3, 4};
    }

    @Override
    public float getWrenchDropRate() {
        return 0.8f;
    }
}

