/*
 * Decompiled with CFR 0.152.
 */
package ic2classic.core.block.wiring;

import cpw.mods.fml.common.eventhandler.Event;
import ic2classic.api.Direction;
import ic2classic.api.energy.event.EnergyTileLoadEvent;
import ic2classic.api.energy.event.EnergyTileSourceEvent;
import ic2classic.api.energy.event.EnergyTileUnloadEvent;
import ic2classic.api.energy.tile.IEnergySink;
import ic2classic.api.energy.tile.IEnergySource;
import ic2classic.core.IC2;
import ic2classic.core.block.TileEntityBlock;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.MinecraftForge;

public abstract class TileEntityTransformer
extends TileEntityBlock
implements IEnergySink,
IEnergySource {
    public int lowOutput;
    public int highOutput;
    public int maxStorage;
    public int energy = 0;
    public boolean redstone = false;
    public boolean addedToEnergyNet = false;

    public TileEntityTransformer(int low, int high, int max) {
        this.lowOutput = low;
        this.highOutput = high;
        this.maxStorage = max;
    }

    @Override
    public void func_145839_a(NBTTagCompound nbttagcompound) {
        super.func_145839_a(nbttagcompound);
        this.energy = nbttagcompound.func_74762_e("energy");
    }

    @Override
    public void func_145841_b(NBTTagCompound nbttagcompound) {
        super.func_145841_b(nbttagcompound);
        nbttagcompound.func_74768_a("energy", this.energy);
    }

    @Override
    public boolean canUpdate() {
        return IC2.platform.isSimulating();
    }

    @Override
    public void onLoaded() {
        super.onLoaded();
        if (IC2.platform.isSimulating() && !this.addedToEnergyNet) {
            MinecraftForge.EVENT_BUS.post((Event)new EnergyTileLoadEvent(this));
            this.addedToEnergyNet = true;
        }
    }

    @Override
    public void onUnloaded() {
        if (IC2.platform.isSimulating() && this.addedToEnergyNet) {
            MinecraftForge.EVENT_BUS.post((Event)new EnergyTileUnloadEvent(this));
            this.addedToEnergyNet = false;
        }
        super.onUnloaded();
    }

    public void func_145845_h() {
        super.func_145845_h();
        this.updateRedstone();
        if (this.redstone) {
            if (this.energy >= this.highOutput) {
                EnergyTileSourceEvent event = new EnergyTileSourceEvent(this, this.highOutput);
                MinecraftForge.EVENT_BUS.post((Event)event);
                this.energy -= this.highOutput - event.amount;
            }
        } else {
            int i = 0;
            while (i < 4 && this.energy >= this.lowOutput) {
                EnergyTileSourceEvent event = new EnergyTileSourceEvent(this, this.lowOutput);
                MinecraftForge.EVENT_BUS.post((Event)event);
                this.energy -= this.lowOutput - event.amount;
                ++i;
            }
        }
    }

    public void updateRedstone() {
        boolean red = this.field_145850_b.func_72864_z(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        if (red != this.redstone) {
            if (this.addedToEnergyNet) {
                MinecraftForge.EVENT_BUS.post((Event)new EnergyTileUnloadEvent(this));
            }
            this.addedToEnergyNet = false;
            this.redstone = red;
            if (this.loaded) {
                MinecraftForge.EVENT_BUS.post((Event)new EnergyTileLoadEvent(this));
                this.addedToEnergyNet = true;
            }
            this.setActive(this.redstone);
        }
    }

    @Override
    public boolean IC2Classic_acceptsEnergyFrom(TileEntity emitter, Direction direction) {
        if (this.redstone) {
            return !this.facingMatchesDirection(direction);
        }
        return this.facingMatchesDirection(direction);
    }

    @Override
    public boolean IC2Classic_emitsEnergyTo(TileEntity receiver, Direction direction) {
        if (this.redstone) {
            return this.facingMatchesDirection(direction);
        }
        return !this.facingMatchesDirection(direction);
    }

    public boolean facingMatchesDirection(Direction direction) {
        return direction.toSideValue() == this.getFacing();
    }

    @Override
    public int IC2Classic_getMaxEnergyOutput() {
        if (this.redstone) {
            return this.highOutput;
        }
        return this.lowOutput;
    }

    @Override
    public int IC2Classic_demandsEnergy() {
        return this.maxStorage - this.energy;
    }

    @Override
    public boolean IC2Classic_injectEnergy(Direction directionFrom, int amount) {
        if (amount > this.IC2Classic_getMaxSafeInput()) {
            IC2.explodeMachineAt(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e);
            return true;
        }
        if (this.energy >= this.maxStorage + this.highOutput) {
            return false;
        }
        this.energy += amount;
        return true;
    }

    @Override
    public int IC2Classic_getMaxSafeInput() {
        if (this.redstone) {
            return this.lowOutput;
        }
        if (this.highOutput != 2048) {
            return this.highOutput;
        }
        return Integer.MAX_VALUE;
    }

    @Override
    public boolean wrenchCanSetFacing(EntityPlayer entityPlayer, int side) {
        return this.getFacing() != side;
    }

    @Override
    public void setFacing(short side) {
        if (this.addedToEnergyNet) {
            MinecraftForge.EVENT_BUS.post((Event)new EnergyTileUnloadEvent(this));
        }
        this.addedToEnergyNet = false;
        super.setFacing(side);
        if (this.loaded) {
            MinecraftForge.EVENT_BUS.post((Event)new EnergyTileLoadEvent(this));
            this.addedToEnergyNet = true;
        }
    }
}

