/*
 * Decompiled with CFR 0.152.
 */
package ic2classic.core.item.reactor;

import ic2classic.api.IReactor;
import ic2classic.api.IReactorComponent;
import ic2classic.core.IC2;
import ic2classic.core.Ic2Items;
import ic2classic.core.item.ItemGradual;
import java.util.ArrayList;
import net.minecraft.item.ItemStack;

public class ItemReactorUranium
extends ItemGradual
implements IReactorComponent {
    public int numberOfCells;

    public ItemReactorUranium(int index, int cells) {
        super(index);
        this.numberOfCells = cells;
    }

    @Override
    public void processChamber(IReactor reactor, ItemStack yourStack, int x, int y) {
        if (!reactor.produceEnergy()) {
            return;
        }
        int iteration = 0;
        while (iteration < this.numberOfCells) {
            int pulses = 1 + this.numberOfCells / 2;
            int i = 0;
            while (i < pulses) {
                this.acceptUraniumPulse(reactor, yourStack, yourStack, x, y, x, y);
                ++i;
            }
            int heat = this.sumUp(pulses += this.checkPulseable(reactor, x - 1, y, yourStack, x, y) + this.checkPulseable(reactor, x + 1, y, yourStack, x, y) + this.checkPulseable(reactor, x, y - 1, yourStack, x, y) + this.checkPulseable(reactor, x, y + 1, yourStack, x, y)) * 4;
            ArrayList<ItemStackCoord> heatAcceptors = new ArrayList<ItemStackCoord>();
            this.checkHeatAcceptor(reactor, x - 1, y, heatAcceptors);
            this.checkHeatAcceptor(reactor, x + 1, y, heatAcceptors);
            this.checkHeatAcceptor(reactor, x, y - 1, heatAcceptors);
            this.checkHeatAcceptor(reactor, x, y + 1, heatAcceptors);
            while (heatAcceptors.size() > 0 && heat > 0) {
                int dheat = heat / heatAcceptors.size();
                heat -= dheat;
                dheat = ((IReactorComponent)heatAcceptors.get((int)0).stack.func_77973_b()).alterHeat(reactor, heatAcceptors.get((int)0).stack, heatAcceptors.get((int)0).x, heatAcceptors.get((int)0).y, dheat);
                heat += dheat;
                heatAcceptors.remove(0);
            }
            if (heat > 0) {
                reactor.addHeat(heat);
            }
            ++iteration;
        }
        if (yourStack.func_77960_j() >= this.func_77612_l() - 1) {
            if (IC2.random.nextInt(3) == 0) {
                reactor.setItemAt(x, y, new ItemStack(Ic2Items.nearDepletedUraniumCell, this.numberOfCells));
            } else {
                reactor.setItemAt(x, y, null);
            }
        } else {
            yourStack.func_77964_b(yourStack.func_77960_j() + 1);
        }
    }

    private int checkPulseable(IReactor reactor, int x, int y, ItemStack me, int mex, int mey) {
        ItemStack other = reactor.getItemAt(x, y);
        if (other != null && other.func_77973_b() instanceof IReactorComponent && ((IReactorComponent)other.func_77973_b()).acceptUraniumPulse(reactor, other, me, x, y, mex, mey)) {
            return 1;
        }
        return 0;
    }

    private int sumUp(int x) {
        int sum = 0;
        int i = 1;
        while (i <= x) {
            sum += i;
            ++i;
        }
        return sum;
    }

    private void checkHeatAcceptor(IReactor reactor, int x, int y, ArrayList<ItemStackCoord> heatAcceptors) {
        ItemStack thing = reactor.getItemAt(x, y);
        if (thing != null && thing.func_77973_b() instanceof IReactorComponent && ((IReactorComponent)thing.func_77973_b()).canStoreHeat(reactor, thing, x, y)) {
            heatAcceptors.add(new ItemStackCoord(thing, x, y));
        }
    }

    @Override
    public boolean acceptUraniumPulse(IReactor reactor, ItemStack yourStack, ItemStack pulsingStack, int youX, int youY, int pulseX, int pulseY) {
        reactor.addOutput(1);
        return true;
    }

    @Override
    public boolean canStoreHeat(IReactor reactor, ItemStack yourStack, int x, int y) {
        return false;
    }

    @Override
    public int getMaxHeat(IReactor reactor, ItemStack yourStack, int x, int y) {
        return 0;
    }

    @Override
    public int getCurrentHeat(IReactor reactor, ItemStack yourStack, int x, int y) {
        return 0;
    }

    @Override
    public int alterHeat(IReactor reactor, ItemStack yourStack, int x, int y, int heat) {
        return heat;
    }

    @Override
    public float influenceExplosion(IReactor reactor, ItemStack yourStack) {
        return 2 * this.numberOfCells;
    }

    private class ItemStackCoord {
        public ItemStack stack;
        public int x;
        public int y;

        public ItemStackCoord(ItemStack stack, int x, int y) {
            this.stack = stack;
            this.x = x;
            this.y = y;
        }
    }
}

