/*
 * Decompiled with CFR 0.152.
 */
package ic2classic.core.network;

import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.network.FMLNetworkEvent;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import ic2classic.api.network.INetworkItemEventListener;
import ic2classic.api.network.INetworkTileEntityEventListener;
import ic2classic.core.IC2;
import ic2classic.core.IHasGui;
import ic2classic.core.item.IHandHeldInventory;
import ic2classic.core.network.NetworkManager;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.zip.GZIPOutputStream;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.network.Packet;
import net.minecraft.network.play.client.C17PacketCustomPayload;
import net.minecraft.network.play.server.S3FPacketCustomPayload;
import net.minecraft.tileentity.TileEntity;

@SideOnly(value=Side.CLIENT)
public class NetworkManagerClient
extends NetworkManager {
    public boolean handlePacketClient(Channel channel, Object msg) {
        if (msg instanceof S3FPacketCustomPayload && ((S3FPacketCustomPayload)msg).func_149169_c().equals("ic2classic")) {
            this.onPacketDataClient(((S3FPacketCustomPayload)msg).func_149168_d(), null);
            return true;
        }
        return false;
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public void onConnectClientSide(FMLNetworkEvent.ClientConnectedToServerEvent evt) {
        evt.manager.channel().pipeline().addBefore("packet_handler", "ic2classic packet handler", (ChannelHandler)new ChannelInboundHandlerAdapter(){

            public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
                if (!NetworkManagerClient.this.handlePacketClient(ctx.channel(), msg)) {
                    ctx.fireChannelRead(msg);
                }
            }
        });
        this.sendLoginData(evt.manager.channel());
    }

    @Override
    public void initiateClientItemEvent(ItemStack itemStack, int event) {
        try {
            ByteArrayOutputStream buffer = new ByteArrayOutputStream();
            DataOutputStream os = new DataOutputStream(buffer);
            os.writeByte(1);
            os.writeInt(Item.func_150891_b((Item)itemStack.func_77973_b()));
            os.writeInt(itemStack.func_77960_j());
            os.writeInt(event);
            os.close();
            C17PacketCustomPayload packet = new C17PacketCustomPayload("ic2classic", buffer.toByteArray());
            Minecraft.func_71410_x().func_147114_u().func_147297_a((Packet)packet);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void initiateKeyUpdate(int keyState) {
        try {
            ByteArrayOutputStream buffer = new ByteArrayOutputStream();
            DataOutputStream os = new DataOutputStream(buffer);
            os.writeByte(2);
            os.writeInt(keyState);
            os.close();
            C17PacketCustomPayload packet = new C17PacketCustomPayload("ic2classic", buffer.toByteArray());
            Minecraft.func_71410_x().func_147114_u().func_147297_a((Packet)packet);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void initiateClientTileEntityEvent(TileEntity te, int event) {
        try {
            ByteArrayOutputStream buffer = new ByteArrayOutputStream();
            DataOutputStream os = new DataOutputStream(buffer);
            os.writeByte(3);
            os.writeInt(te.func_145831_w().field_73011_w.field_76574_g);
            os.writeInt(te.field_145851_c);
            os.writeInt(te.field_145848_d);
            os.writeInt(te.field_145849_e);
            os.writeInt(event);
            os.close();
            C17PacketCustomPayload packet = new C17PacketCustomPayload("ic2classic", buffer.toByteArray());
            Minecraft.func_71410_x().func_147114_u().func_147297_a((Packet)packet);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void sendLoginData(Channel channel) {
        try {
            ByteArrayOutputStream buffer = new ByteArrayOutputStream();
            buffer.write(4);
            GZIPOutputStream gzip = new GZIPOutputStream(buffer);
            DataOutputStream os = new DataOutputStream(gzip);
            os.writeInt(1);
            os.writeByte(IC2.enableQuantumSpeedOnSprint ? 1 : 0);
            os.close();
            gzip.close();
            C17PacketCustomPayload packet = new C17PacketCustomPayload("ic2classic", buffer.toByteArray());
            channel.write((Object)packet);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void onPacketDataClient(byte[] packetdata, EntityPlayerMP player) {
        block24: {
            ByteArrayInputStream isRaw = new ByteArrayInputStream(packetdata, 1, packetdata.length - 1);
            try {
                block1 : switch (packetdata[0]) {
                    case 0: {
                        System.out.println("got removed packet 0 on client");
                        break;
                    }
                    case 1: {
                        DataInputStream is = new DataInputStream(isRaw);
                        int dimensionId = is.readInt();
                        int x = is.readInt();
                        int y = is.readInt();
                        int z = is.readInt();
                        int event = is.readInt();
                        WorldClient world = Minecraft.func_71410_x().field_71441_e;
                        if (world.field_73011_w.field_76574_g != dimensionId) {
                            return;
                        }
                        TileEntity te = world.func_147438_o(x, y, z);
                        if (te instanceof INetworkTileEntityEventListener) {
                            ((INetworkTileEntityEventListener)te).onNetworkEvent(event);
                        }
                        break;
                    }
                    case 2: {
                        DataInputStream is = new DataInputStream(isRaw);
                        int length = is.readByte();
                        char[] usernameRaw = new char[length];
                        int i = 0;
                        while (i < length) {
                            usernameRaw[i] = is.readChar();
                            ++i;
                        }
                        String username = new String(usernameRaw);
                        int itemId = is.readInt();
                        int itemDamage = is.readInt();
                        int event = is.readInt();
                        WorldClient world = Minecraft.func_71410_x().field_71441_e;
                        for (Object obj : world.field_73010_i) {
                            EntityPlayer entityPlayer = (EntityPlayer)obj;
                            if (entityPlayer.func_146103_bH().getId() != null && !entityPlayer.func_146103_bH().getId().equals(username)) continue;
                            Item item = Item.func_150899_d((int)itemId);
                            if (item instanceof INetworkItemEventListener) {
                                ((INetworkItemEventListener)item).onNetworkEvent(itemDamage, entityPlayer, event);
                                break block1;
                            }
                            break block24;
                        }
                        break;
                    }
                    case 3: {
                        System.out.println("got removed packet 3 on client");
                        break;
                    }
                    case 4: {
                        DataInputStream is = new DataInputStream(isRaw);
                        EntityPlayer entityPlayer = IC2.platform.getPlayerInstance();
                        switch (is.readByte()) {
                            case 0: {
                                int dimensionId = is.readInt();
                                int x = is.readInt();
                                int y = is.readInt();
                                int z = is.readInt();
                                int windowId = is.readInt();
                                WorldClient world = Minecraft.func_71410_x().field_71441_e;
                                if (world.field_73011_w.field_76574_g != dimensionId) {
                                    return;
                                }
                                TileEntity te = world.func_147438_o(x, y, z);
                                if (te instanceof IHasGui) {
                                    IC2.platform.launchGuiClient(entityPlayer, (IHasGui)te);
                                }
                                entityPlayer.field_71070_bA.field_75152_c = windowId;
                                break block1;
                            }
                            case 1: {
                                int currentItemPosition = is.readInt();
                                int windowId = is.readInt();
                                if (currentItemPosition != entityPlayer.field_71071_by.field_70461_c) {
                                    return;
                                }
                                ItemStack currentItem = entityPlayer.field_71071_by.func_70448_g();
                                if (currentItem != null && currentItem.func_77973_b() instanceof IHandHeldInventory) {
                                    IC2.platform.launchGuiClient(entityPlayer, ((IHandHeldInventory)currentItem.func_77973_b()).getInventory(entityPlayer, currentItem));
                                }
                                entityPlayer.field_71070_bA.field_75152_c = windowId;
                            }
                        }
                        break;
                    }
                    case 5: {
                        DataInputStream is = new DataInputStream(isRaw);
                        int dimensionId = is.readInt();
                        double dx = is.readDouble();
                        double dy = is.readDouble();
                        double dz = is.readDouble();
                        WorldClient world = Minecraft.func_71410_x().field_71441_e;
                        if (world.field_73011_w.field_76574_g != dimensionId) {
                            return;
                        }
                        world.func_72908_a(dx, dy, dz, "random.explode", 4.0f, (1.0f + (world.field_73012_v.nextFloat() - world.field_73012_v.nextFloat()) * 0.2f) * 0.7f);
                        world.func_72869_a("hugeexplosion", dx, dy, dz, 0.0, 0.0, 0.0);
                    }
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }
}

