/*
 * Decompiled with CFR 0.152.
 */
package ic2classic.core.recipes;

import ic2.api.recipe.IScrapboxManager;
import ic2classic.core.IC2;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.item.ItemStack;

public class ScrapboxDropRecipeManager
implements IScrapboxManager {
    private double totalChance = 0.0;
    private double[] chanceUpperLimits = new double[16];
    private ItemStack[] drops = new ItemStack[16];
    private int numDrops = 0;

    @Override
    public synchronized void addDrop(ItemStack drop, float rawChance) {
        if (this.numDrops >= this.drops.length) {
            this.drops = Arrays.copyOf(this.drops, this.numDrops * 2);
            this.chanceUpperLimits = Arrays.copyOf(this.chanceUpperLimits, this.numDrops * 2);
        }
        if (rawChance <= 0.0f) {
            throw new IllegalArgumentException("rawChance <= 0: " + rawChance);
        }
        this.drops[this.numDrops] = drop;
        this.totalChance += (double)rawChance;
        this.chanceUpperLimits[this.numDrops] = this.totalChance;
        ++this.numDrops;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ItemStack getDrop(ItemStack input, boolean adjustInput) {
        double randomval;
        int index;
        if (this.numDrops == 0) {
            return null;
        }
        ScrapboxDropRecipeManager scrapboxDropRecipeManager = this;
        synchronized (scrapboxDropRecipeManager) {
            if (this.numDrops != this.drops.length) {
                this.drops = Arrays.copyOf(this.drops, this.numDrops);
                this.chanceUpperLimits = Arrays.copyOf(this.chanceUpperLimits, this.numDrops);
            }
        }
        if (adjustInput) {
            --input.field_77994_a;
        }
        while ((index = Arrays.binarySearch(this.chanceUpperLimits, randomval = IC2.random.nextDouble() * this.totalChance)) < 0 || index >= this.drops.length) {
        }
        return this.drops[index];
    }

    @Override
    public Map<ItemStack, Float> getDrops() {
        HashMap<ItemStack, Float> result = new HashMap<ItemStack, Float>();
        int k = 0;
        while (k < this.numDrops) {
            result.put(this.drops[k], Float.valueOf((float)(this.chanceUpperLimits[k] - (k == 0 ? 0.0 : this.chanceUpperLimits[k - 1]))));
            ++k;
        }
        return result;
    }
}

