/*
 * Decompiled with CFR 0.152.
 */
package ic2classic.core.block;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import ic2classic.api.IWrenchable;
import ic2classic.core.IC2;
import ic2classic.core.ITickCallback;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S35PacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class TileEntityBlock
extends TileEntity
implements IWrenchable {
    private boolean active = false;
    private short facing = 0;
    public boolean prevActive = false;
    public short prevFacing = 0;
    public boolean loaded = false;

    public void func_145829_t() {
        super.func_145829_t();
        if (!this.loaded) {
            if (!this.func_145837_r() && this.field_145850_b != null) {
                if (IC2.platform.isSimulating()) {
                    IC2.addSingleTickCallback(this.field_145850_b, new ITickCallback(){

                        @Override
                        public void tickCallback(World world) {
                            if (!TileEntityBlock.this.func_145837_r()) {
                                TileEntityBlock.this.onLoaded();
                            }
                        }
                    });
                } else {
                    this.onLoaded();
                }
            } else {
                IC2.log.warn(this + " (" + this.field_145851_c + "," + this.field_145848_d + "," + this.field_145849_e + ") was not added, isInvalid=" + this.func_145837_r() + ", worldObj=" + this.field_145850_b);
            }
        }
    }

    public void func_145843_s() {
        if (this.loaded) {
            this.onUnloaded();
        }
        super.func_145843_s();
    }

    public void onChunkUnload() {
        if (this.loaded) {
            this.onUnloaded();
        }
        super.onChunkUnload();
    }

    public void onLoaded() {
        this.loaded = true;
    }

    public void onUnloaded() {
        this.loaded = false;
    }

    public void func_145839_a(NBTTagCompound nbttagcompound) {
        super.func_145839_a(nbttagcompound);
        this.prevFacing = this.facing = nbttagcompound.func_74765_d("facing");
    }

    public void func_145841_b(NBTTagCompound nbttagcompound) {
        super.func_145841_b(nbttagcompound);
        nbttagcompound.func_74777_a("facing", this.facing);
    }

    public boolean canUpdate() {
        return false;
    }

    public boolean getActive() {
        return this.active;
    }

    public void setActive(boolean active) {
        this.active = active;
        if (this.prevActive != active) {
            this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        }
        this.prevActive = active;
    }

    public void setActiveWithoutNotify(boolean active) {
        this.active = active;
        this.prevActive = active;
    }

    @Override
    public short getFacing() {
        return this.facing;
    }

    public final Packet func_145844_m() {
        NBTTagCompound tag = new NBTTagCompound();
        this.writeDescriptionNBT(tag);
        return new S35PacketUpdateTileEntity(this.field_145851_c, this.field_145848_d, this.field_145849_e, 0, tag);
    }

    @SideOnly(value=Side.CLIENT)
    public void onDataPacket(NetworkManager net, S35PacketUpdateTileEntity pkt) {
        this.readDescriptionNBT(pkt.func_148857_g());
    }

    public void writeDescriptionNBT(NBTTagCompound tag) {
        tag.func_74757_a("active", this.active);
        tag.func_74768_a("facing", (int)this.facing);
    }

    public void readDescriptionNBT(NBTTagCompound tag) {
        this.active = tag.func_74767_n("active");
        this.facing = (short)tag.func_74762_e("facing");
        if (this.prevActive != this.active || this.prevFacing != this.facing) {
            Block blockId;
            Block block = blockId = this.field_145850_b.func_147439_a(this.field_145851_c, this.field_145848_d, this.field_145849_e);
            boolean newActive = this.active;
            short newFacing = this.facing;
            this.active = this.prevActive;
            this.facing = this.prevFacing;
            IIcon[] textureIndex = new IIcon[6];
            int side = 0;
            while (side < 6) {
                textureIndex[side] = IC2.platform.getBlockTexture(block, (IBlockAccess)this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e, side);
                ++side;
            }
            this.active = newActive;
            this.facing = newFacing;
            side = 0;
            while (side < 6) {
                IIcon newTextureIndex = IC2.platform.getBlockTexture(block, (IBlockAccess)this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e, side);
                if (textureIndex[side] != newTextureIndex) {
                    this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
                    break;
                }
                ++side;
            }
            this.prevActive = this.active;
            this.prevFacing = this.facing;
        }
    }

    @Override
    public boolean wrenchCanSetFacing(EntityPlayer entityPlayer, int side) {
        return false;
    }

    @Override
    public void setFacing(short facing) {
        this.facing = facing;
        if (this.prevFacing != facing) {
            this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        }
        this.prevFacing = facing;
    }

    @Override
    public boolean wrenchCanRemove(EntityPlayer entityPlayer) {
        return true;
    }

    @Override
    public float getWrenchDropRate() {
        return 1.0f;
    }

    @Override
    public ItemStack getWrenchDrop(EntityPlayer entityPlayer) {
        return new ItemStack(this.field_145850_b.func_147439_a(this.field_145851_c, this.field_145848_d, this.field_145849_e), 1, this.field_145850_b.func_72805_g(this.field_145851_c, this.field_145848_d, this.field_145849_e));
    }

    public void onBlockBreak(Block a, int b) {
    }
}

