/*
 * Decompiled with CFR 0.152.
 */
package ic2classic.core.block.personal;

import ic2classic.core.ContainerIC2;
import ic2classic.core.IC2;
import ic2classic.core.IHasGui;
import ic2classic.core.block.machine.tileentity.TileEntityMachine;
import ic2classic.core.block.personal.ContainerPersonalChest;
import ic2classic.core.block.personal.IPersonalBlock;
import java.util.UUID;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.server.MinecraftServer;

public class TileEntityPersonalChest
extends TileEntityMachine
implements IPersonalBlock,
ISidedInventory,
IHasGui {
    private int ticksSinceSync;
    private int numUsingPlayers;
    public float lidAngle;
    public float prevLidAngle;
    public UUID owner = new UUID(0L, 0L);

    public TileEntityPersonalChest() {
        super(54);
    }

    @Override
    public void func_145839_a(NBTTagCompound nbttagcompound) {
        super.func_145839_a(nbttagcompound);
        this.owner = UUID.fromString(nbttagcompound.func_74779_i("owner"));
    }

    @Override
    public void func_145841_b(NBTTagCompound nbttagcompound) {
        super.func_145841_b(nbttagcompound);
        nbttagcompound.func_74778_a("owner", this.owner.toString());
    }

    @Override
    public String func_145825_b() {
        return "Personal Safe";
    }

    @Override
    public boolean canUpdate() {
        return true;
    }

    @Override
    public void func_145845_h() {
        double var4;
        if (++this.ticksSinceSync % 20 * 4 == 0 && IC2.platform.isSimulating()) {
            this.syncNumUsingPlayers();
        }
        this.prevLidAngle = this.lidAngle;
        float var1 = 0.1f;
        if (this.numUsingPlayers > 0 && this.lidAngle == 0.0f) {
            double var2 = (double)this.field_145851_c + 0.5;
            var4 = (double)this.field_145849_e + 0.5;
            this.field_145850_b.func_72908_a(var2, (double)this.field_145848_d + 0.5, var4, "random.chestopen", 0.5f, this.field_145850_b.field_73012_v.nextFloat() * 0.1f + 0.9f);
        }
        if (this.numUsingPlayers == 0 && this.lidAngle > 0.0f || this.numUsingPlayers > 0 && this.lidAngle < 1.0f) {
            float var3;
            float var8 = this.lidAngle;
            this.lidAngle = this.numUsingPlayers > 0 ? (this.lidAngle += var1) : (this.lidAngle -= var1);
            if (this.lidAngle > 1.0f) {
                this.lidAngle = 1.0f;
            }
            if (this.lidAngle < (var3 = 0.5f) && var8 >= var3) {
                var4 = (double)this.field_145851_c + 0.5;
                double var6 = (double)this.field_145849_e + 0.5;
                this.field_145850_b.func_72908_a(var4, (double)this.field_145848_d + 0.5, var6, "random.chestclosed", 0.5f, this.field_145850_b.field_73012_v.nextFloat() * 0.1f + 0.9f);
            }
            if (this.lidAngle < 0.0f) {
                this.lidAngle = 0.0f;
            }
        }
    }

    public void openChest() {
        ++this.numUsingPlayers;
        this.syncNumUsingPlayers();
    }

    public void closeChest() {
        --this.numUsingPlayers;
        this.syncNumUsingPlayers();
    }

    public boolean func_145842_c(int event, int data) {
        if (event == 1) {
            this.numUsingPlayers = data;
        }
        return true;
    }

    private void syncNumUsingPlayers() {
        this.field_145850_b.func_147452_c(this.field_145851_c, this.field_145848_d, this.field_145849_e, this.field_145850_b.func_147439_a(this.field_145851_c, this.field_145848_d, this.field_145849_e), 1, this.numUsingPlayers);
    }

    @Override
    public void readDescriptionNBT(NBTTagCompound tag) {
        super.readDescriptionNBT(tag);
        try {
            this.owner = UUID.fromString(tag.func_74779_i("owner"));
        }
        catch (IllegalArgumentException e) {
            this.owner = new UUID(0L, 0L);
        }
    }

    @Override
    public void writeDescriptionNBT(NBTTagCompound tag) {
        super.writeDescriptionNBT(tag);
        tag.func_74778_a("owner", this.owner.toString());
    }

    @Override
    public boolean wrenchCanRemove(EntityPlayer entityPlayer) {
        if (!this.canAccess(entityPlayer)) {
            return false;
        }
        int i = 0;
        while (i < this.inventory.length) {
            if (this.inventory[i] != null) {
                IC2.platform.messagePlayer(entityPlayer, "Can't wrench non-empty safe");
                return false;
            }
            ++i;
        }
        return true;
    }

    @Override
    public boolean canAccess(EntityPlayer player) {
        if (this.owner.equals(new UUID(0L, 0L))) {
            this.owner = player.func_146103_bH().getId();
            this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
            return true;
        }
        if (IC2.platform.isSimulating()) {
            MinecraftServer server = MinecraftServer.func_71276_C();
            if (player.getDisplayName().equals(server.func_71214_G()) || server.func_71203_ab().func_152596_g(player.func_146103_bH())) {
                return true;
            }
        }
        if (this.owner.equals(player.func_146103_bH().getId())) {
            return true;
        }
        if (IC2.platform.isSimulating()) {
            IC2.platform.messagePlayer(player, "This safe is owned by " + this.owner);
        }
        return false;
    }

    @Override
    public ContainerIC2 getGuiContainer(EntityPlayer entityPlayer) {
        return new ContainerPersonalChest(entityPlayer, this);
    }

    @Override
    public String getGuiClassName(EntityPlayer entityPlayer) {
        return "block.personal.GuiPersonalChest";
    }

    @Override
    public void onGuiClosed(EntityPlayer entityPlayer) {
    }

    @Override
    public boolean func_102008_b(int i, ItemStack itemstack, int j) {
        return false;
    }

    @Override
    public boolean func_102007_a(int i, ItemStack itemstack, int j) {
        return false;
    }

    public int[] func_94128_d(int var1) {
        return new int[0];
    }
}

