/*
 * Decompiled with CFR 0.152.
 */
package ic2classic.core.electric_item_api;

import ic2.api.item.ElectricItem;
import ic2.api.item.IElectricItem;
import ic2.api.item.IElectricItemManager;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;

public class DefaultElectricItemManager
implements IElectricItemManager {
    @Override
    public boolean canUse(ItemStack stack, double amount) {
        return ElectricItem.manager.getCharge(stack) >= amount;
    }

    @Override
    public double charge(ItemStack stack, double amount, int tier, boolean ignoreTransferLimit, boolean simulate) {
        assert (stack.func_77973_b() instanceof IElectricItem);
        return ic2classic.core.item.ElectricItem.chargeDefaultImpl(stack, (int)amount, tier, ignoreTransferLimit, simulate);
    }

    @Override
    public double discharge(ItemStack stack, double amount, int tier, boolean ignoreTransferLimit, boolean externally, boolean simulate) {
        assert (stack.func_77973_b() instanceof IElectricItem);
        return ic2classic.core.item.ElectricItem.dischargeDefaultImpl(stack, (int)amount, tier, ignoreTransferLimit, simulate);
    }

    @Override
    public double getCharge(ItemStack stack) {
        assert (stack.func_77973_b() instanceof IElectricItem);
        NBTTagCompound tag = stack.func_77978_p();
        if (tag == null) {
            return 0.0;
        }
        return tag.func_74769_h("charge");
    }

    @Override
    public boolean use(ItemStack stack, double amount, EntityLivingBase entity) {
        ElectricItem.manager.chargeFromArmor(stack, entity);
        double dischargedAmt = ElectricItem.manager.discharge(stack, amount, Integer.MAX_VALUE, true, false, true);
        if (dischargedAmt >= amount) {
            ElectricItem.manager.discharge(stack, amount, Integer.MAX_VALUE, true, false, false);
            ElectricItem.manager.chargeFromArmor(stack, entity);
            return true;
        }
        return false;
    }

    @Override
    public void chargeFromArmor(ItemStack stack, EntityLivingBase entity) {
        if (entity instanceof EntityPlayer) {
            ic2classic.core.item.ElectricItem.chargeFromArmorDefaultImpl(stack, (EntityPlayer)entity);
        }
    }

    @Override
    public String getToolTip(ItemStack stack) {
        return null;
    }
}

