/*
 * Decompiled with CFR 0.152.
 */
package ic2classic.core.item.reactor;

import ic2classic.api.IReactor;
import ic2classic.api.IReactorComponent;
import ic2classic.core.item.ItemGradual;
import ic2classic.core.util.StackUtil;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;

public class ItemReactorHeatStorage
extends ItemGradual
implements IReactorComponent {
    public int heatStorage;

    public ItemReactorHeatStorage(int index, int heatStorage) {
        super(index);
        this.heatStorage = heatStorage;
    }

    @Override
    public void processChamber(IReactor reactor, ItemStack yourStack, int x, int y) {
    }

    @Override
    public boolean acceptUraniumPulse(IReactor reactor, ItemStack yourStack, ItemStack pulsingStack, int youX, int youY, int pulseX, int pulseY) {
        return false;
    }

    @Override
    public boolean canStoreHeat(IReactor reactor, ItemStack yourStack, int x, int y) {
        return true;
    }

    @Override
    public int getMaxHeat(IReactor reactor, ItemStack yourStack, int x, int y) {
        return this.heatStorage;
    }

    @Override
    public int getCurrentHeat(IReactor reactor, ItemStack yourStack, int x, int y) {
        return this.getHeatOfStack(yourStack);
    }

    @Override
    public int alterHeat(IReactor reactor, ItemStack yourStack, int x, int y, int heat) {
        int myHeat = this.getHeatOfStack(yourStack);
        if ((myHeat += heat) > this.heatStorage) {
            reactor.setItemAt(x, y, null);
            heat = this.heatStorage - myHeat + 1;
        } else {
            if (myHeat < 0) {
                heat = myHeat;
                myHeat = 0;
            } else {
                heat = 0;
            }
            this.setHeatForStack(yourStack, myHeat);
        }
        return heat;
    }

    @Override
    public float influenceExplosion(IReactor reactor, ItemStack yourStack) {
        return 0.0f;
    }

    private void setHeatForStack(ItemStack stack, int heat) {
        NBTTagCompound nbtData = StackUtil.getOrCreateNbtData(stack);
        nbtData.func_74768_a("heat", heat);
        if (this.heatStorage > 0) {
            double p = heat / this.heatStorage;
            int newDmg = (int)((double)stack.func_77958_k() * p);
            if (newDmg >= stack.func_77958_k()) {
                newDmg = stack.func_77958_k() - 1;
            }
            stack.func_77964_b(newDmg);
        }
    }

    private int getHeatOfStack(ItemStack stack) {
        NBTTagCompound nbtData = StackUtil.getOrCreateNbtData(stack);
        return nbtData.func_74762_e("heat");
    }
}

