/*
 * Decompiled with CFR 0.152.
 */
package ic2classic.core.item.tool;

import cpw.mods.fml.common.registry.IThrowableEntity;
import ic2classic.core.ExplosionIC2;
import ic2classic.core.IC2;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.boss.EntityDragon;
import net.minecraft.entity.boss.EntityDragonPart;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.FurnaceRecipes;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.EntityDamageSourceIndirect;
import net.minecraft.util.MathHelper;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;

public class EntityMiningLaser
extends Entity
implements IThrowableEntity {
    public float range = 0.0f;
    public float power = 0.0f;
    public int blockBreaks = 0;
    public boolean explosive = false;
    public static Block[] unmineableBlocks = new Block[]{Blocks.field_150336_V, Blocks.field_150343_Z, Blocks.field_150353_l, Blocks.field_150356_k, Blocks.field_150355_j, Blocks.field_150358_i, Blocks.field_150357_h, Blocks.field_150359_w, Blocks.field_150410_aZ};
    public static final int netId = 141;
    public static final double laserSpeed = 1.0;
    public EntityLivingBase owner;
    public boolean headingSet = false;
    public boolean smelt = false;
    private int ticksInAir = 0;

    public EntityMiningLaser(World world, double x, double y, double z) {
        super(world);
        this.func_70105_a(0.8f, 0.8f);
        this.field_70129_M = 0.0f;
        this.func_70107_b(x, y, z);
    }

    public EntityMiningLaser(World world) {
        this(world, 0.0, 0.0, 0.0);
    }

    public EntityMiningLaser(World world, EntityLivingBase entityliving, float range, float power, int blockBreaks, boolean explosive) {
        this(world, entityliving, range, power, blockBreaks, explosive, entityliving.field_70177_z, entityliving.field_70125_A);
    }

    public EntityMiningLaser(World world, EntityLivingBase entityliving, float range, float power, int blockBreaks, boolean explosive, boolean smelt) {
        this(world, entityliving, range, power, blockBreaks, explosive, entityliving.field_70177_z, entityliving.field_70125_A);
        this.smelt = smelt;
    }

    public EntityMiningLaser(World world, EntityLivingBase entityliving, float range, float power, int blockBreaks, boolean explosive, double yawDeg, double pitchDeg) {
        this(world, entityliving, range, power, blockBreaks, explosive, yawDeg, pitchDeg, entityliving.field_70163_u + (double)entityliving.func_70047_e() - 0.1);
    }

    public EntityMiningLaser(World world, EntityLivingBase entityliving, float range, float power, int blockBreaks, boolean explosive, double yawDeg, double pitchDeg, double y) {
        super(world);
        this.owner = entityliving;
        this.func_70105_a(0.8f, 0.8f);
        this.field_70129_M = 0.0f;
        double yaw = Math.toRadians(yawDeg);
        double pitch = Math.toRadians(pitchDeg);
        double x = entityliving.field_70165_t - Math.cos(yaw) * 0.16;
        double z = entityliving.field_70161_v - Math.sin(yaw) * 0.16;
        double startMotionX = -Math.sin(yaw) * Math.cos(pitch);
        double startMotionY = -Math.sin(pitch);
        double startMotionZ = Math.cos(yaw) * Math.cos(pitch);
        this.func_70107_b(x, y, z);
        this.setLaserHeading(startMotionX, startMotionY, startMotionZ, 1.0);
        this.range = range;
        this.power = power;
        this.blockBreaks = blockBreaks;
        this.explosive = explosive;
    }

    protected void func_70088_a() {
    }

    public void setLaserHeading(double motionX, double motionY, double motionZ, double speed) {
        double currentSpeed = MathHelper.func_76133_a((double)(motionX * motionX + motionY * motionY + motionZ * motionZ));
        this.field_70159_w = motionX / currentSpeed * speed;
        this.field_70181_x = motionY / currentSpeed * speed;
        this.field_70179_y = motionZ / currentSpeed * speed;
        this.field_70126_B = this.field_70177_z = (float)Math.toDegrees(Math.atan2(motionX, motionZ));
        this.field_70127_C = this.field_70125_A = (float)Math.toDegrees(Math.atan2(motionY, MathHelper.func_76133_a((double)(motionX * motionX + motionZ * motionZ))));
        this.headingSet = true;
    }

    public void func_70016_h(double motionX, double motionY, double motionZ) {
        this.setLaserHeading(motionX, motionY, motionZ, 1.0);
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (IC2.platform.isSimulating() && (this.range < 1.0f || this.power <= 0.0f || this.blockBreaks <= 0)) {
            if (this.explosive) {
                this.explode();
            }
            this.func_70106_y();
            return;
        }
        ++this.ticksInAir;
        Vec3 oldPosition = Vec3.func_72443_a((double)this.field_70165_t, (double)this.field_70163_u, (double)this.field_70161_v);
        Vec3 newPosition = Vec3.func_72443_a((double)(this.field_70165_t + this.field_70159_w), (double)(this.field_70163_u + this.field_70181_x), (double)(this.field_70161_v + this.field_70179_y));
        MovingObjectPosition movingobjectposition = this.field_70170_p.func_147447_a(oldPosition, newPosition, false, true, false);
        oldPosition = Vec3.func_72443_a((double)this.field_70165_t, (double)this.field_70163_u, (double)this.field_70161_v);
        newPosition = movingobjectposition != null ? Vec3.func_72443_a((double)movingobjectposition.field_72307_f.field_72450_a, (double)movingobjectposition.field_72307_f.field_72448_b, (double)movingobjectposition.field_72307_f.field_72449_c) : Vec3.func_72443_a((double)(this.field_70165_t + this.field_70159_w), (double)(this.field_70163_u + this.field_70181_x), (double)(this.field_70161_v + this.field_70179_y));
        Entity entity = null;
        List list = this.field_70170_p.func_72839_b((Entity)this, this.field_70121_D.func_72321_a(this.field_70159_w, this.field_70181_x, this.field_70179_y).func_72314_b(1.0, 1.0, 1.0));
        double d = 0.0;
        int l = 0;
        while (l < list.size()) {
            double d1;
            float f4;
            AxisAlignedBB axisalignedbb1;
            MovingObjectPosition movingobjectposition1;
            Entity entity1 = (Entity)list.get(l);
            if (entity1.func_70067_L() && (entity1 != this.owner || this.ticksInAir >= 5) && (movingobjectposition1 = (axisalignedbb1 = entity1.field_70121_D.func_72314_b((double)(f4 = 0.3f), (double)f4, (double)f4)).func_72327_a(oldPosition, newPosition)) != null && ((d1 = oldPosition.func_72438_d(movingobjectposition1.field_72307_f)) < d || d == 0.0)) {
                entity = entity1;
                d = d1;
            }
            ++l;
        }
        if (entity != null) {
            movingobjectposition = new MovingObjectPosition(entity);
        }
        if (movingobjectposition != null && IC2.platform.isSimulating()) {
            if (this.explosive) {
                this.explode();
                this.func_70106_y();
                return;
            }
            if (movingobjectposition.field_72308_g != null) {
                int damage = (int)this.power;
                if (damage > 0) {
                    entity.func_70015_d(damage * (this.smelt ? 2 : 1));
                    if (movingobjectposition.field_72308_g.func_70097_a(new EntityDamageSourceIndirect("arrow", (Entity)this, (Entity)this.owner).func_76349_b(), (float)damage) && this.owner instanceof EntityPlayer && (movingobjectposition.field_72308_g instanceof EntityDragon && ((EntityDragon)movingobjectposition.field_72308_g).func_110143_aJ() <= 0.0f || movingobjectposition.field_72308_g instanceof EntityDragonPart && ((EntityDragonPart)movingobjectposition.field_72308_g).field_70259_a instanceof EntityDragon && ((EntityLivingBase)((EntityDragonPart)movingobjectposition.field_72308_g).field_70259_a).func_110143_aJ() <= 0.0f)) {
                        IC2.achievements.issueAchievement((EntityPlayer)this.owner, "killDragonMiningLaser");
                    }
                }
                this.func_70106_y();
            } else {
                int xTile = movingobjectposition.field_72311_b;
                int yTile = movingobjectposition.field_72312_c;
                int zTile = movingobjectposition.field_72309_d;
                Block blockId = this.field_70170_p.func_147439_a(xTile, yTile, zTile);
                int blockMeta = this.field_70170_p.func_72805_g(xTile, yTile, zTile);
                boolean blockSet = false;
                boolean removeBlock = true;
                boolean dropBlock = true;
                if (!this.canMine(blockId)) {
                    this.func_70106_y();
                } else if (IC2.platform.isSimulating()) {
                    float resis = 0.0f;
                    resis = blockId.getExplosionResistance((Entity)this, this.field_70170_p, xTile, yTile, zTile, this.field_70165_t, this.field_70163_u, this.field_70161_v) + 0.3f;
                    this.power -= resis / 10.0f;
                    if (this.power >= 0.0f) {
                        if (blockId.func_149688_o() == Material.field_151590_u) {
                            blockId.func_149664_b(this.field_70170_p, xTile, yTile, zTile, 1);
                        } else if (this.smelt) {
                            if (blockId.func_149688_o() == Material.field_151575_d) {
                                removeBlock = true;
                                dropBlock = false;
                            } else {
                                for (ItemStack isa : blockId.getDrops(this.field_70170_p, xTile, yTile, zTile, blockMeta, 0)) {
                                    ItemStack isb = FurnaceRecipes.func_77602_a().func_151395_a(isa);
                                    if (isb == null) continue;
                                    ItemStack is = isb.func_77946_l();
                                    if (!blockSet && is.func_77973_b() != Item.func_150898_a((Block)blockId) && is.func_77973_b() instanceof ItemBlock) {
                                        blockSet = true;
                                        removeBlock = false;
                                        dropBlock = false;
                                        this.field_70170_p.func_147465_d(xTile, yTile, zTile, Block.func_149634_a((Item)is.func_77973_b()), is.func_77960_j(), 3);
                                    } else {
                                        dropBlock = false;
                                        float var6 = 0.7f;
                                        double var7 = (double)(this.field_70170_p.field_73012_v.nextFloat() * var6) + (double)(1.0f - var6) * 0.5;
                                        double var9 = (double)(this.field_70170_p.field_73012_v.nextFloat() * var6) + (double)(1.0f - var6) * 0.5;
                                        double var11 = (double)(this.field_70170_p.field_73012_v.nextFloat() * var6) + (double)(1.0f - var6) * 0.5;
                                        EntityItem var13 = new EntityItem(this.field_70170_p, (double)xTile + var7, (double)yTile + var9, (double)zTile + var11, is);
                                        var13.field_145804_b = 10;
                                        this.field_70170_p.func_72838_d((Entity)var13);
                                    }
                                    this.power = 0.0f;
                                }
                            }
                        }
                        if (removeBlock) {
                            if (dropBlock) {
                                blockId.func_149690_a(this.field_70170_p, xTile, yTile, zTile, this.field_70170_p.func_72805_g(xTile, yTile, zTile), 0.9f, 0);
                            }
                            this.field_70170_p.func_147468_f(xTile, yTile, zTile);
                            if (this.field_70170_p.field_73012_v.nextInt(10) == 0 && blockId.func_149688_o().func_76217_h()) {
                                this.field_70170_p.func_147449_b(xTile, yTile, zTile, (Block)Blocks.field_150480_ab);
                            }
                        }
                        --this.blockBreaks;
                    }
                }
            }
        } else {
            this.power -= 0.5f;
        }
        this.func_70107_b(this.field_70165_t + this.field_70159_w, this.field_70163_u + this.field_70181_x, this.field_70161_v + this.field_70179_y);
        this.range = (float)((double)this.range - Math.sqrt(this.field_70159_w * this.field_70159_w + this.field_70181_x * this.field_70181_x + this.field_70179_y * this.field_70179_y));
        if (this.func_70090_H()) {
            this.func_70106_y();
        }
    }

    public void func_70014_b(NBTTagCompound nbttagcompound) {
    }

    public void func_70037_a(NBTTagCompound nbttagcompound) {
    }

    public float func_70053_R() {
        return 0.0f;
    }

    public void explode() {
        if (IC2.platform.isSimulating()) {
            ExplosionIC2 explosion = new ExplosionIC2(this.field_70170_p, null, this.field_70165_t, this.field_70163_u, this.field_70161_v, 5.0f, 0.85f, 0.55f);
            explosion.doExplosion();
        }
    }

    public boolean canMine(Block blockId) {
        int i = 0;
        while (i < unmineableBlocks.length) {
            if (blockId == unmineableBlocks[i]) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public Entity getThrower() {
        return this.owner;
    }

    public void setThrower(Entity entity) {
        if (entity instanceof EntityLivingBase) {
            this.owner = (EntityLivingBase)entity;
        }
    }
}

