/*
 * Decompiled with CFR 0.152.
 */
package ic2classic.core.item.tool;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import ic2.api.item.IElectricItem;
import ic2classic.api.electric_item.BatteryAPI;
import ic2classic.core.Ic2Icons;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemTool;
import net.minecraft.util.IIcon;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeHooks;

public abstract class ItemElectricTool
extends ItemTool
implements IElectricItem {
    public int co;
    public int operationEnergyCost;
    public int maxCharge;
    public int transferLimit;
    public int tier;
    public Set<Block> mineableBlocks = new HashSet<Block>();
    public int iconIndex;

    @SideOnly(value=Side.CLIENT)
    public void func_94581_a(IIconRegister par1IconRegister) {
    }

    public ItemElectricTool(int sprite, Item.ToolMaterial toolmaterial, int operationEnergyCost) {
        super(0.0f, toolmaterial, Collections.emptySet());
        this.iconIndex = sprite;
        this.operationEnergyCost = operationEnergyCost;
        this.func_77656_e(27);
        this.func_77625_d(1);
    }

    public boolean func_77616_k(ItemStack p_77616_1_) {
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_77617_a(int par1) {
        return Ic2Icons.i0[this.iconIndex];
    }

    protected boolean isToolEffective(ItemStack tool, Block block, int meta) {
        return ForgeHooks.isToolEffective((ItemStack)tool, (Block)block, (int)meta);
    }

    public float getDigSpeed(ItemStack tool, Block block, int meta) {
        if (!BatteryAPI.canUse(tool, this.operationEnergyCost)) {
            return 1.0f;
        }
        if (this.isToolEffective(tool, block, meta)) {
            return this.field_77864_a;
        }
        return 1.0f;
    }

    public boolean func_77644_a(ItemStack itemstack, EntityLivingBase entityliving, EntityLivingBase entityliving1) {
        return true;
    }

    public int func_77619_b() {
        return 0;
    }

    public boolean isRepairable() {
        return false;
    }

    public Multimap getAttributeModifiers(ItemStack stack) {
        HashMultimap multimap = HashMultimap.create();
        multimap.put((Object)SharedMonsterAttributes.field_111264_e.func_111108_a(), (Object)new AttributeModifier(Item.field_111210_e, "Weapon modifier", (double)this.getDamageVsEntity(), 0));
        return multimap;
    }

    public int getDamageVsEntity() {
        return this.co;
    }

    @Override
    public boolean canProvideEnergy(ItemStack stack) {
        return false;
    }

    @Override
    public Item getChargedItem(ItemStack stack) {
        return this;
    }

    @Override
    public Item getEmptyItem(ItemStack stack) {
        return this;
    }

    @Override
    public double getMaxCharge(ItemStack stack) {
        return this.maxCharge;
    }

    @Override
    public int getTier(ItemStack stack) {
        return this.tier;
    }

    @Override
    public double getTransferLimit(ItemStack stack) {
        return this.transferLimit;
    }

    public boolean func_150894_a(ItemStack par1ItemStack, World par2World, Block par3, int par4, int par5, int par6, EntityLivingBase par7EntityLiving) {
        if ((double)par3.func_149712_f(par2World, par4, par5, par6) != 0.0) {
            if (par7EntityLiving instanceof EntityPlayer) {
                BatteryAPI.use(par1ItemStack, this.operationEnergyCost, par7EntityLiving);
            } else {
                BatteryAPI.discharge(par1ItemStack, this.operationEnergyCost, this.tier, true, false);
            }
        }
        return true;
    }

    public boolean func_82789_a(ItemStack par1ItemStack, ItemStack par2ItemStack) {
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_150895_a(Item i, CreativeTabs tabs, List itemList) {
        ItemStack charged = new ItemStack((Item)this, 1);
        BatteryAPI.charge(charged, Integer.MAX_VALUE, Integer.MAX_VALUE, true, false);
        itemList.add(charged);
        itemList.add(new ItemStack((Item)this, 1, this.func_77612_l()));
    }
}

