/*
 * Decompiled with CFR 0.152.
 */
package ic2classic.core.item.tool;

import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import ic2classic.api.IPaintableBlock;
import ic2classic.core.IC2;
import ic2classic.core.Ic2Icons;
import ic2classic.core.Ic2Items;
import ic2classic.core.audio.PositionSpec;
import ic2classic.core.item.ItemIC2;
import ic2classic.core.util.StackUtil;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.BlockColored;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.passive.EntitySheep;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.IIcon;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.player.EntityInteractEvent;

public class ItemToolPainter
extends ItemIC2 {
    public int color;

    public ItemToolPainter(int col) {
        super(128);
        this.func_77656_e(32);
        this.func_77625_d(1);
        this.color = col;
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @Override
    public IIcon func_77617_a(int i) {
        return Ic2Icons.i0[this.iconIndex + this.color];
    }

    public boolean func_77648_a(ItemStack itemstack, EntityPlayer entityplayer, World world, int i, int j, int k, int side, float a, float b, float c) {
        Block blockId = world.func_147439_a(i, j, k);
        if (blockId instanceof IPaintableBlock && ((IPaintableBlock)blockId).colorBlock(world, i, j, k, this.color)) {
            if (IC2.platform.isSimulating()) {
                this.damagePainter(entityplayer);
            }
            if (IC2.platform.isRendering()) {
                IC2.audioManager.playOnce(entityplayer, PositionSpec.Hand, "Tools/Painter.ogg", true, IC2.audioManager.defaultVolume);
            }
            return true;
        }
        if (blockId == Blocks.field_150325_L && world.func_72805_g(i, j, k) != BlockColored.func_150031_c((int)this.color)) {
            world.func_72921_c(i, j, k, BlockColored.func_150031_c((int)this.color), 3);
            this.damagePainter(entityplayer);
            if (IC2.platform.isRendering()) {
                IC2.audioManager.playOnce(entityplayer, PositionSpec.Hand, "Tools/Painter.ogg", true, IC2.audioManager.defaultVolume);
            }
            return true;
        }
        return false;
    }

    @SubscribeEvent
    public boolean onEntityInteract(EntityInteractEvent event) {
        EntityPlayer player = event.entityPlayer;
        Entity entity = event.entity;
        if (entity.field_70170_p.field_72995_K || player.func_71045_bC() == null || player.func_71045_bC().func_77973_b() != this) {
            return true;
        }
        boolean ret = true;
        if (entity instanceof EntitySheep) {
            EntitySheep sheep = (EntitySheep)entity;
            int clr = BlockColored.func_150031_c((int)this.color);
            if (sheep.func_70896_n() != clr) {
                ret = false;
                ((EntitySheep)entity).func_70891_b(clr);
                this.damagePainter(player);
            }
        }
        return ret;
    }

    public ItemStack func_77659_a(ItemStack itemstack, World world, EntityPlayer entityplayer) {
        if (IC2.platform.isSimulating() && IC2.keyboard.isModeSwitchKeyDown(entityplayer)) {
            NBTTagCompound nbtData = StackUtil.getOrCreateNbtData(itemstack);
            boolean newValue = !nbtData.func_74767_n("autoRefill");
            nbtData.func_74757_a("autoRefill", newValue);
            if (newValue) {
                IC2.platform.messagePlayer(entityplayer, "Painter automatic refill mode enabled");
            } else {
                IC2.platform.messagePlayer(entityplayer, "Painter automatic refill mode disabled");
            }
        }
        return itemstack;
    }

    public void func_77624_a(ItemStack stack, EntityPlayer player, List info, boolean debugTooltips) {
        info.add(StatCollector.func_74838_a((String)(String.valueOf(Items.field_151100_aR.func_77667_c(new ItemStack(Items.field_151100_aR, 1, this.color))) + ".name")));
    }

    private void damagePainter(EntityPlayer player) {
        if (player.field_71071_by.field_70462_a[player.field_71071_by.field_70461_c].func_77960_j() >= player.field_71071_by.field_70462_a[player.field_71071_by.field_70461_c].func_77958_k() - 1) {
            int dyeIS = -1;
            if (dyeIS == -1) {
                player.field_71071_by.field_70462_a[player.field_71071_by.field_70461_c] = new ItemStack(Ic2Items.painter);
            } else {
                --player.field_71071_by.field_70462_a[dyeIS].field_77994_a;
                if (player.field_71071_by.field_70462_a[dyeIS].field_77994_a == 0) {
                    player.field_71071_by.field_70462_a[dyeIS] = null;
                }
                player.field_71071_by.field_70462_a[player.field_71071_by.field_70461_c].func_77964_b(0);
            }
        } else {
            player.field_71071_by.field_70462_a[player.field_71071_by.field_70461_c].func_77972_a(1, (EntityLivingBase)player);
        }
        player.field_71070_bA.func_75142_b();
    }
}

