/*
 * Decompiled with CFR 0.152.
 */
package ic2classic.core.util;

import ic2classic.api.Direction;
import java.util.Iterator;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryLargeChest;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityChest;
import net.minecraft.world.World;

public final class StackUtil {
    private static final Direction[] directions = Direction.values();

    public static void distributeDrop(TileEntity source, List<ItemStack> itemStacks) {
        Direction[] directionArray = directions;
        int n = directions.length;
        int n2 = 0;
        while (n2 < n) {
            Direction direction = directionArray[n2];
            if (itemStacks.isEmpty()) break;
            TileEntity target = direction.applyToTileEntity(source);
            if (target instanceof IInventory) {
                IInventory inventory = (IInventory)target;
                if (target instanceof TileEntityChest) {
                    Direction[] directionArray2 = directions;
                    int n3 = directions.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        TileEntity target2;
                        Direction direction2 = directionArray2[n4];
                        if (direction2 != Direction.YN && direction2 != Direction.YP && (target2 = direction2.applyToTileEntity(target)) instanceof TileEntityChest) {
                            inventory = new InventoryLargeChest("", inventory, (IInventory)target2);
                            break;
                        }
                        ++n4;
                    }
                }
                Iterator<ItemStack> it = itemStacks.iterator();
                while (it.hasNext()) {
                    ItemStack itemStackSource = it.next();
                    if (itemStackSource == null) continue;
                    StackUtil.putInInventory(inventory, itemStackSource);
                    if (itemStackSource.field_77994_a != 0) continue;
                    it.remove();
                }
            }
            ++n2;
        }
        for (ItemStack itemStack : itemStacks) {
            StackUtil.dropAsEntity(source.func_145831_w(), source.field_145851_c, source.field_145848_d, source.field_145849_e, itemStack);
        }
        itemStacks.clear();
    }

    public static ItemStack getFromInventory(IInventory inventory, ItemStack itemStackDestination) {
        ItemStack ret = null;
        int toTransfer = itemStackDestination.field_77994_a;
        itemStackDestination.field_77994_a = 0;
        int i = 0;
        while (i < inventory.func_70302_i_()) {
            ItemStack itemStack = inventory.func_70301_a(i);
            if (itemStack != null && StackUtil.isStackEqual(itemStack, itemStackDestination)) {
                if (ret == null) {
                    ret = itemStack.func_77946_l();
                    ret.field_77994_a = 0;
                }
                int transfer = Math.min(toTransfer, itemStack.field_77994_a);
                toTransfer -= transfer;
                itemStack.field_77994_a -= transfer;
                itemStackDestination.field_77994_a += transfer;
                ret.field_77994_a += transfer;
                if (itemStack.field_77994_a == 0) {
                    inventory.func_70299_a(i, null);
                }
                if (toTransfer == 0) {
                    return ret;
                }
            }
            ++i;
        }
        return null;
    }

    public static boolean putInInventory(IInventory inventory, ItemStack itemStackSource) {
        int transfer;
        ItemStack itemStack;
        int i = 0;
        while (i < inventory.func_70302_i_()) {
            itemStack = inventory.func_70301_a(i);
            if (itemStack != null && itemStack.func_77969_a(itemStackSource)) {
                transfer = Math.min(itemStackSource.field_77994_a, itemStack.func_77976_d() - itemStack.field_77994_a);
                itemStack.field_77994_a += transfer;
                itemStackSource.field_77994_a -= transfer;
                if (itemStackSource.field_77994_a == 0) {
                    return true;
                }
            }
            ++i;
        }
        i = 0;
        while (i < inventory.func_70302_i_()) {
            itemStack = inventory.func_70301_a(i);
            if (itemStack == null) {
                transfer = Math.min(itemStackSource.field_77994_a, itemStackSource.func_77976_d());
                inventory.func_70299_a(i, new ItemStack(itemStackSource.func_77973_b(), transfer, itemStackSource.func_77960_j()));
                itemStackSource.field_77994_a -= transfer;
                if (itemStackSource.field_77994_a == 0) {
                    return true;
                }
            }
            ++i;
        }
        return false;
    }

    public static void dropAsEntity(World world, int x, int y, int z, ItemStack itemStack) {
        if (itemStack == null) {
            return;
        }
        double f = 0.7;
        double dx = (double)world.field_73012_v.nextFloat() * f + (1.0 - f) * 0.5;
        double dy = (double)world.field_73012_v.nextFloat() * f + (1.0 - f) * 0.5;
        double dz = (double)world.field_73012_v.nextFloat() * f + (1.0 - f) * 0.5;
        EntityItem entityItem = new EntityItem(world, (double)x + dx, (double)y + dy, (double)z + dz, itemStack.func_77946_l());
        entityItem.field_145804_b = 10;
        world.func_72838_d((Entity)entityItem);
    }

    public static ItemStack copyWithSize(ItemStack itemStack, int newSize) {
        ItemStack ret = itemStack.func_77946_l();
        ret.field_77994_a = newSize;
        return ret;
    }

    public static NBTTagCompound getOrCreateNbtData(ItemStack itemStack) {
        NBTTagCompound ret = itemStack.func_77978_p();
        if (ret == null) {
            ret = new NBTTagCompound();
            itemStack.func_77982_d(ret);
        }
        return ret;
    }

    public static boolean isStackEqual(ItemStack stack1, ItemStack stack2) {
        return stack1 != null && stack2 != null && stack1.func_77973_b() == stack2.func_77973_b() && (stack1.func_77973_b().func_77645_m() || stack1.func_77960_j() == stack2.func_77960_j());
    }

    public static ItemStack copyWithWildCard(ItemStack stack) {
        if (stack == null) {
            return null;
        }
        stack = stack.func_77946_l();
        stack.func_77964_b(Short.MAX_VALUE);
        return stack;
    }
}

