/*
 * Decompiled with CFR 0.152.
 */
package ic2classic.core.audio;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import ic2classic.core.IC2;
import ic2classic.core.audio.AudioManagerClient;
import ic2classic.core.audio.AudioPosition;
import ic2classic.core.audio.AudioSource;
import ic2classic.core.audio.PositionSpec;
import java.net.URL;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.world.IBlockAccess;
import paulscode.sound.SoundSystem;

@SideOnly(value=Side.CLIENT)
public final class AudioSourceClient
extends AudioSource
implements Comparable<AudioSourceClient> {
    private SoundSystem soundSystem;
    private String sourceName;
    private boolean valid = false;
    private boolean culled = false;
    private Object obj;
    private AudioPosition position;
    private PositionSpec positionSpec;
    private float configuredVolume;
    private float realVolume;
    private boolean isPlaying = false;

    public AudioSourceClient(SoundSystem soundSystem, String sourceName, Object obj, PositionSpec positionSpec, String initialSoundFile, boolean loop, boolean priorized, float volume) {
        this.soundSystem = soundSystem;
        this.sourceName = sourceName;
        this.obj = obj;
        this.positionSpec = positionSpec;
        URL url = AudioSource.class.getClassLoader().getResource("ic2classic/sounds/" + initialSoundFile);
        if (url == null) {
            System.out.println("Invalid sound file: " + initialSoundFile);
            return;
        }
        this.position = AudioPosition.getFrom(obj, positionSpec);
        soundSystem.newSource(priorized, sourceName, url, initialSoundFile, loop, this.position.x, this.position.y, this.position.z, 0, ((AudioManagerClient)IC2.audioManager).fadingDistance * Math.max(volume, 1.0f));
        this.valid = true;
        this.setVolume(volume);
    }

    @Override
    public int compareTo(AudioSourceClient x) {
        if (this.culled) {
            return (int)((this.realVolume * 0.9f - x.realVolume) * 128.0f);
        }
        return (int)((this.realVolume - x.realVolume) * 128.0f);
    }

    @Override
    public void remove() {
        if (!this.valid) {
            return;
        }
        this.stop();
        this.soundSystem.removeSource(this.sourceName);
        this.sourceName = null;
    }

    @Override
    public void play() {
        if (!this.valid) {
            return;
        }
        if (this.isPlaying) {
            return;
        }
        this.isPlaying = true;
        if (this.culled) {
            return;
        }
        this.soundSystem.play(this.sourceName);
    }

    @Override
    public void pause() {
        if (!this.valid) {
            return;
        }
        if (!this.isPlaying) {
            return;
        }
        this.isPlaying = false;
        if (this.culled) {
            return;
        }
        this.soundSystem.pause(this.sourceName);
    }

    @Override
    public void stop() {
        if (!this.valid) {
            return;
        }
        if (!this.isPlaying) {
            return;
        }
        this.isPlaying = false;
        if (this.culled) {
            return;
        }
        this.soundSystem.stop(this.sourceName);
    }

    @Override
    public void flush() {
        if (!this.valid) {
            return;
        }
        if (!this.isPlaying) {
            return;
        }
        if (this.culled) {
            return;
        }
        this.soundSystem.flush(this.sourceName);
    }

    @Override
    public void cull() {
        if (!this.valid || this.culled) {
            return;
        }
        if (this.isPlaying) {
            this.soundSystem.stop(this.sourceName);
        }
        this.soundSystem.cull(this.sourceName);
        this.culled = true;
    }

    @Override
    public void activate() {
        if (!this.valid || !this.culled) {
            return;
        }
        this.soundSystem.activate(this.sourceName);
        this.culled = false;
        if (this.isPlaying) {
            this.soundSystem.play(this.sourceName);
        }
    }

    @Override
    public float getVolume() {
        if (!this.valid) {
            return 0.0f;
        }
        return this.soundSystem.getVolume(this.sourceName);
    }

    @Override
    public float getRealVolume() {
        return this.realVolume;
    }

    @Override
    public void setVolume(float volume) {
        this.configuredVolume = volume;
        this.soundSystem.setVolume(this.sourceName, 0.001f);
    }

    @Override
    public void setPitch(float pitch) {
        if (!this.valid) {
            return;
        }
        this.soundSystem.setPitch(this.sourceName, pitch);
    }

    @Override
    public void updatePosition() {
        if (!this.valid) {
            return;
        }
        this.position = AudioPosition.getFrom(this.obj, this.positionSpec);
        this.soundSystem.setPosition(this.sourceName, this.position.x, this.position.y, this.position.z);
    }

    @Override
    public void updateVolume(EntityPlayer player) {
        float distance;
        if (!this.valid || !this.isPlaying) {
            this.realVolume = 0.0f;
            return;
        }
        float maxDistance = ((AudioManagerClient)IC2.audioManager).fadingDistance * Math.max(this.configuredVolume, 1.0f);
        float rolloffFactor = 1.0f;
        float referenceDistance = 1.0f;
        float x = (float)player.field_70165_t;
        float y = (float)player.field_70163_u;
        float z = (float)player.field_70161_v;
        if (this.position.world == player.field_70170_p) {
            float deltaX = this.position.x - x;
            float deltaY = this.position.y - y;
            float deltaZ = this.position.z - z;
            distance = (float)Math.sqrt(deltaX * deltaX + deltaY * deltaY + deltaZ * deltaZ);
        } else {
            distance = 1.0f;
        }
        if (distance > maxDistance) {
            this.realVolume = 0.0f;
            this.cull();
            return;
        }
        if (distance < referenceDistance) {
            distance = referenceDistance;
        }
        float gain = 1.0f - rolloffFactor * (distance - referenceDistance) / (maxDistance - referenceDistance);
        float newRealVolume = gain * this.configuredVolume * IC2.audioManager.getMasterVolume();
        float dx = (this.position.x - x) / distance;
        float dy = (this.position.y - y) / distance;
        float dz = (this.position.z - z) / distance;
        if ((double)newRealVolume > 0.1) {
            int i = 0;
            while ((float)i < distance) {
                Block blockId = player.field_70170_p.func_147439_a((int)x, (int)y, (int)z);
                if (!blockId.isAir((IBlockAccess)player.field_70170_p, (int)x, (int)y, (int)z)) {
                    newRealVolume = blockId.func_149662_c() ? (newRealVolume *= 0.6f) : (newRealVolume *= 0.9f);
                }
                x += dx;
                y += dy;
                z += dz;
                ++i;
            }
        }
        if ((double)Math.abs(this.realVolume / newRealVolume - 1.0f) > 0.06) {
            this.soundSystem.setVolume(this.sourceName, IC2.audioManager.getMasterVolume() * Math.min(newRealVolume, 1.0f));
        }
        this.realVolume = newRealVolume;
    }
}

