/*
 * Decompiled with CFR 0.152.
 */
package ic2classic.core.electric_item_api;

import ic2.api.item.ElectricItem;
import ic2.api.item.IBackupElectricItemManager;
import ic2.api.item.IElectricItem;
import ic2.api.item.IElectricItemManager;
import ic2.api.item.ISpecialElectricItem;
import ic2classic.core.electric_item_api.NullElectricItemManager;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;

public class DelegatingElectricItemManager
implements IElectricItemManager {
    @Override
    public double charge(ItemStack stack, double amount, int tier, boolean ignoreTransferLimit, boolean simulate) {
        if (amount <= 0.0) {
            return 0.0;
        }
        return DelegatingElectricItemManager.getManager(stack).charge(stack, amount, tier, ignoreTransferLimit, simulate);
    }

    @Override
    public double discharge(ItemStack stack, double amount, int tier, boolean ignoreTransferLimit, boolean externally, boolean simulate) {
        if (amount <= 0.0) {
            return 0.0;
        }
        return DelegatingElectricItemManager.getManager(stack).discharge(stack, amount, tier, ignoreTransferLimit, externally, simulate);
    }

    @Override
    public double getCharge(ItemStack stack) {
        return DelegatingElectricItemManager.getManager(stack).getCharge(stack);
    }

    @Override
    public boolean canUse(ItemStack stack, double amount) {
        if (amount <= 0.0) {
            return true;
        }
        return DelegatingElectricItemManager.getManager(stack).canUse(stack, amount);
    }

    @Override
    public boolean use(ItemStack stack, double amount, EntityLivingBase entity) {
        if (amount <= 0.0) {
            return true;
        }
        return DelegatingElectricItemManager.getManager(stack).use(stack, amount, entity);
    }

    @Override
    public void chargeFromArmor(ItemStack stack, EntityLivingBase entity) {
        DelegatingElectricItemManager.getManager(stack).chargeFromArmor(stack, entity);
    }

    @Override
    public String getToolTip(ItemStack stack) {
        return DelegatingElectricItemManager.getManager(stack).getToolTip(stack);
    }

    private static IElectricItemManager getManager(ItemStack stack) {
        Item item = stack.func_77973_b();
        if (item instanceof ISpecialElectricItem) {
            return ((ISpecialElectricItem)stack.func_77973_b()).getManager(stack);
        }
        if (item instanceof IElectricItem) {
            return ElectricItem.rawManager;
        }
        IBackupElectricItemManager backup = ElectricItem.getBackupManager(stack);
        if (backup != null) {
            return backup;
        }
        return NullElectricItemManager.INSTANCE;
    }
}

