/*
 * Decompiled with CFR 0.152.
 */
package ic2classic.core.item.tool;

import ic2classic.api.electric_item.BatteryAPI;
import ic2classic.core.IC2;
import ic2classic.core.audio.PositionSpec;
import ic2classic.core.item.ElectricItem;
import ic2classic.core.util.Util;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;

public class ItemScanner
extends ElectricItem {
    public ItemScanner(int index, int t) {
        super(index);
        this.maxCharge = 10000;
        this.transferLimit = 50;
        this.tier = t;
    }

    public ItemStack func_77659_a(ItemStack itemstack, World world, EntityPlayer entityplayer) {
        if (this.tier == 1 && !BatteryAPI.use(itemstack, 50, (EntityLivingBase)entityplayer) || this.tier == 2 && !BatteryAPI.use(itemstack, 250, (EntityLivingBase)entityplayer)) {
            return itemstack;
        }
        IC2.audioManager.playOnce(entityplayer, PositionSpec.Hand, "Tools/ODScanner.ogg", true, IC2.audioManager.defaultVolume);
        if (this.tier == 2) {
            int value = ItemScanner.valueOfArea(world, Util.roundToNegInf(entityplayer.field_70165_t), Util.roundToNegInf(entityplayer.field_70163_u), Util.roundToNegInf(entityplayer.field_70161_v), true);
            IC2.platform.messagePlayer(entityplayer, "SCAN RESULT: Ore value in this area is " + value);
        } else {
            int value = ItemScanner.valueOfArea(world, Util.roundToNegInf(entityplayer.field_70165_t), Util.roundToNegInf(entityplayer.field_70163_u), Util.roundToNegInf(entityplayer.field_70161_v), false);
            IC2.platform.messagePlayer(entityplayer, "SCAN RESULT: Ore density in this area is " + value);
        }
        return itemstack;
    }

    public static int valueOfArea(World worldObj, int x, int y, int z, boolean advancedMode) {
        int totalScore = 0;
        int blocksScanned = 0;
        int range = advancedMode ? 4 : 2;
        int blockY = y;
        while (blockY > 0) {
            int blockX = x - range;
            while (blockX <= x + range) {
                int blockZ = z - range;
                while (blockZ <= z + range) {
                    Block blockId = worldObj.func_147439_a(blockX, blockY, blockZ);
                    int metaData = worldObj.func_72805_g(blockX, blockY, blockZ);
                    if (advancedMode) {
                        totalScore += ItemScanner.valueOf(blockId, metaData);
                    } else if (ItemScanner.isValuable(blockId, metaData)) {
                        ++totalScore;
                    }
                    ++blocksScanned;
                    ++blockZ;
                }
                ++blockX;
            }
            --blockY;
        }
        return blocksScanned > 0 ? Integer.valueOf((int)(1000.0 * (double)totalScore / (double)blocksScanned)) : null;
    }

    public static boolean isValuable(Block blockId, int metaData) {
        return ItemScanner.valueOf(blockId, metaData) > 0;
    }

    public static int valueOf(Block blockId, int metaData) {
        if (IC2.valuableOres.containsKey(blockId)) {
            Map<Integer, Integer> metaMap = IC2.valuableOres.get(blockId);
            if (metaMap.containsKey(-1)) {
                return metaMap.get(-1);
            }
            if (metaMap.containsKey(metaData)) {
                return metaMap.get(metaData);
            }
        }
        return 0;
    }

    public int startLayerScan(ItemStack itemStack) {
        return BatteryAPI.use(itemStack, 50, null) ? 2 : 0;
    }
}

