/*
 * Decompiled with CFR 0.152.
 */
package ic2classic.core.recipes;

import ic2.api.recipe.IMachineRecipeManager;
import ic2.api.recipe.IRecipeInput;
import ic2.api.recipe.RecipeOutput;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;

public class MachineRecipeManager
implements IMachineRecipeManager {
    private List<Map.Entry<IRecipeInput, RecipeOutput>> recipes = new ArrayList<Map.Entry<IRecipeInput, RecipeOutput>>();
    private int minOutputs;
    private int maxOutputs;

    public MachineRecipeManager(int minOutputs, int maxOutputs) {
        this.minOutputs = minOutputs;
        this.maxOutputs = maxOutputs;
    }

    @Override
    public synchronized void addRecipe(IRecipeInput input, NBTTagCompound metadata, ItemStack ... outputs) {
        if (outputs.length < this.minOutputs || outputs.length > this.maxOutputs) {
            throw new IllegalArgumentException("Expected " + this.minOutputs + " to " + this.maxOutputs + " outputs, got " + outputs.length);
        }
        this.recipes.add(new AbstractMap.SimpleEntry<IRecipeInput, RecipeOutput>(input, new RecipeOutput(metadata, outputs)));
    }

    @Override
    public RecipeOutput getOutputFor(ItemStack input, boolean adjustInput) {
        for (Map.Entry<IRecipeInput, RecipeOutput> recipe : this.recipes) {
            if (!recipe.getKey().matches(input)) continue;
            if (adjustInput) {
                input.field_77994_a -= recipe.getKey().getAmount();
            }
            return recipe.getValue();
        }
        return null;
    }

    @Override
    public Map<IRecipeInput, RecipeOutput> getRecipes() {
        return new AbstractMap<IRecipeInput, RecipeOutput>(){
            private final Set<Map.Entry<IRecipeInput, RecipeOutput>> entrySet = new AbstractSet<Map.Entry<IRecipeInput, RecipeOutput>>(){

                @Override
                public Iterator<Map.Entry<IRecipeInput, RecipeOutput>> iterator() {
                    return MachineRecipeManager.this.recipes.iterator();
                }

                @Override
                public int size() {
                    return MachineRecipeManager.this.recipes.size();
                }
            };

            @Override
            public Set<Map.Entry<IRecipeInput, RecipeOutput>> entrySet() {
                return this.entrySet;
            }
        };
    }
}

