/*
 * Decompiled with CFR 0.152.
 */
package ic2classic.core;

import cpw.mods.fml.client.FMLClientHandler;
import cpw.mods.fml.client.registry.ClientRegistry;
import cpw.mods.fml.client.registry.ISimpleBlockRenderingHandler;
import cpw.mods.fml.client.registry.RenderingRegistry;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.FMLLog;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.TickEvent;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import ic2classic.core.ContainerIC2;
import ic2classic.core.GuiIC2ErrorScreen;
import ic2classic.core.IC2;
import ic2classic.core.IHasGui;
import ic2classic.core.IItemTickListener;
import ic2classic.core.Ic2Blocks;
import ic2classic.core.Ic2Icons;
import ic2classic.core.Platform;
import ic2classic.core.SubIconHandler;
import ic2classic.core.block.BlockRubLeaves;
import ic2classic.core.block.EntityDynamite;
import ic2classic.core.block.EntityIC2Explosive;
import ic2classic.core.block.RenderBlockCable;
import ic2classic.core.block.RenderBlockCrop;
import ic2classic.core.block.RenderBlockFence;
import ic2classic.core.block.RenderExplosiveBlock;
import ic2classic.core.block.RenderFlyingItem;
import ic2classic.core.block.machine.RenderBlockMiningPipe;
import ic2classic.core.block.personal.RenderBlockPersonal;
import ic2classic.core.block.personal.TileEntityPersonalChest;
import ic2classic.core.block.personal.TileEntityPersonalChestRenderer;
import ic2classic.core.block.wiring.RenderBlockLuminator;
import ic2classic.core.item.tool.EntityMiningLaser;
import ic2classic.core.item.tool.RenderCrossed;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.renderer.entity.Render;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.IIcon;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.IBlockAccess;
import org.lwjgl.opengl.Display;
import org.lwjgl.opengl.GL11;

@SideOnly(value=Side.CLIENT)
public class PlatformClient
extends Platform {
    private Map<String, Integer> renders = new HashMap<String, Integer>();

    public PlatformClient() {
        SubIconHandler.loadClass();
        FMLCommonHandler.instance().bus().register((Object)this);
        RenderingRegistry.registerBlockHandler((ISimpleBlockRenderingHandler)new RenderBlockCable());
        this.renders.put("cable", RenderBlockCable.renderId);
        RenderingRegistry.registerBlockHandler((ISimpleBlockRenderingHandler)new RenderBlockCrop());
        this.renders.put("crop", RenderBlockCrop.renderId);
        RenderingRegistry.registerBlockHandler((ISimpleBlockRenderingHandler)new RenderBlockFence());
        this.renders.put("fence", RenderBlockFence.renderId);
        RenderingRegistry.registerBlockHandler((ISimpleBlockRenderingHandler)new RenderBlockLuminator());
        this.renders.put("luminator", RenderBlockLuminator.renderId);
        RenderingRegistry.registerBlockHandler((ISimpleBlockRenderingHandler)new RenderBlockMiningPipe());
        this.renders.put("miningPipe", RenderBlockMiningPipe.renderId);
        RenderingRegistry.registerBlockHandler((ISimpleBlockRenderingHandler)new RenderBlockPersonal());
        this.renders.put("personal", RenderBlockPersonal.renderId);
        ClientRegistry.bindTileEntitySpecialRenderer(TileEntityPersonalChest.class, (TileEntitySpecialRenderer)new TileEntityPersonalChestRenderer());
        RenderingRegistry.registerEntityRenderingHandler(EntityIC2Explosive.class, (Render)new RenderExplosiveBlock());
        RenderingRegistry.registerEntityRenderingHandler(EntityDynamite.class, (Render)new RenderFlyingItem(62, Ic2Icons.i0));
        RenderingRegistry.registerEntityRenderingHandler(EntityMiningLaser.class, (Render)new RenderCrossed(new ResourceLocation("ic2classic", "laser.png")));
    }

    @Override
    public void init() {
        super.init();
        ((BlockRubLeaves)Ic2Blocks.rubberLeaves).func_150122_b(true);
    }

    @Override
    public void displayError(String error) {
        FMLLog.severe((String)("IndustrialCraft 2 Error\n\n" + error).replace("\n", System.getProperty("line.separator")), (Object[])new Object[0]);
        Minecraft minecraft = Minecraft.func_71410_x();
        GL11.glEnable((int)3553);
        GL11.glEnable((int)3008);
        GL11.glAlphaFunc((int)516, (float)0.1f);
        GL11.glEnable((int)2929);
        GL11.glDepthFunc((int)515);
        GL11.glViewport((int)0, (int)0, (int)minecraft.field_71443_c, (int)minecraft.field_71440_d);
        ScaledResolution scaledResolution = new ScaledResolution(minecraft, minecraft.field_71443_c, minecraft.field_71440_d);
        GL11.glClear((int)16640);
        GL11.glMatrixMode((int)5889);
        GL11.glLoadIdentity();
        GL11.glOrtho((double)0.0, (double)scaledResolution.func_78327_c(), (double)scaledResolution.func_78324_d(), (double)0.0, (double)1000.0, (double)3000.0);
        GL11.glMatrixMode((int)5888);
        GL11.glLoadIdentity();
        GL11.glTranslatef((float)0.0f, (float)0.0f, (float)-2000.0f);
        minecraft.func_71364_i();
        GuiIC2ErrorScreen errorScreen = new GuiIC2ErrorScreen(error);
        errorScreen.func_146280_a(minecraft, scaledResolution.func_78326_a(), scaledResolution.func_78328_b());
        errorScreen.func_73863_a(0, 0, 0.0f);
        GL11.glFinish();
        Display.update();
        try {
            Thread.sleep(30000L);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        Display.destroy();
        System.exit(1);
    }

    @Override
    public EntityPlayer getPlayerInstance() {
        return Minecraft.func_71410_x().field_71439_g;
    }

    @Override
    public boolean launchGuiClient(EntityPlayer entityPlayer, IHasGui inventory) {
        GuiScreen guiScreen;
        String clientPackage = "ic2classic.core";
        Package pkg = PlatformClient.class.getPackage();
        if (pkg != null) {
            clientPackage = pkg.getName();
        }
        ContainerIC2 container = inventory.getGuiContainer(entityPlayer);
        Class<?> containerClass = ((Object)((Object)container)).getClass();
        try {
            guiScreen = (GuiScreen)Class.forName(String.valueOf(clientPackage) + "." + inventory.getGuiClassName(entityPlayer)).getConstructor(containerClass).newInstance(containerClass.cast((Object)container));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        FMLClientHandler.instance().displayGuiScreen(entityPlayer, guiScreen);
        return true;
    }

    @Override
    public void profilerStartSection(String section) {
        if (this.isRendering()) {
            Minecraft.func_71410_x().field_71424_I.func_76320_a(section);
        } else {
            super.profilerStartSection(section);
        }
    }

    @Override
    public void profilerEndSection() {
        if (this.isRendering()) {
            Minecraft.func_71410_x().field_71424_I.func_76319_b();
        } else {
            super.profilerEndSection();
        }
    }

    @Override
    public void profilerEndStartSection(String section) {
        if (this.isRendering()) {
            Minecraft.func_71410_x().field_71424_I.func_76318_c(section);
        } else {
            super.profilerEndStartSection(section);
        }
    }

    @Override
    public File getMinecraftDir() {
        return Minecraft.func_71410_x().field_71412_D;
    }

    @Override
    public void playSoundSp(String sound, float f, float g) {
        EntityPlayer pl = this.getPlayerInstance();
        Minecraft.func_71410_x().field_71441_e.func_72980_b(pl.field_70165_t, pl.field_70163_u, pl.field_70161_v, "ic2classic:" + sound, f, g, false);
    }

    @Override
    public IIcon getBlockTexture(Block block, IBlockAccess world, int x, int y, int z, int side) {
        return block.func_149673_e(world, x, y, z, side);
    }

    @Override
    public int addArmor(String name) {
        return RenderingRegistry.addNewArmourRendererPrefix((String)name);
    }

    @Override
    public int getRenderId(String name) {
        return this.renders.get(name);
    }

    @SubscribeEvent
    public void tickStart(TickEvent.ClientTickEvent evt) {
        if (evt.phase != TickEvent.Phase.START) {
            return;
        }
        this.profilerStartSection("Keyboard");
        IC2.keyboard.sendKeyUpdate();
        this.profilerEndStartSection("AudioManager");
        IC2.audioManager.onTick();
        this.profilerEndStartSection("PlayerUpdate");
        EntityPlayer player = this.getPlayerInstance();
        if (player != null) {
            int i = 0;
            while (i < 4) {
                if (player.field_71071_by.field_70460_b[i] != null && player.field_71071_by.field_70460_b[i].func_77973_b() instanceof IItemTickListener) {
                    ((IItemTickListener)player.field_71071_by.field_70460_b[i].func_77973_b()).onTick(player, player.field_71071_by.field_70460_b[i]);
                }
                ++i;
            }
        }
        this.profilerEndSection();
    }
}

