/*
 * Decompiled with CFR 0.152.
 */
package ic2classic.core.block.machine.tileentity;

import cpw.mods.fml.common.eventhandler.Event;
import ic2classic.api.Direction;
import ic2classic.api.energy.event.EnergyTileLoadEvent;
import ic2classic.api.energy.event.EnergyTileUnloadEvent;
import ic2classic.api.energy.tile.IEnergySink;
import ic2classic.core.IC2;
import ic2classic.core.IC2DamageSource;
import ic2classic.core.block.TileEntityBlock;
import ic2classic.core.item.armor.ItemArmorHazmat;
import java.util.List;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.DamageSource;
import net.minecraftforge.common.MinecraftForge;

public class TileEntityTesla
extends TileEntityBlock
implements IEnergySink {
    public int energy = 0;
    public int ticker = 0;
    public int maxEnergy = 10000;
    public int maxInput = 128;
    public boolean addedToEnergyNet = false;

    @Override
    public void func_145839_a(NBTTagCompound nbttagcompound) {
        super.func_145839_a(nbttagcompound);
        this.energy = nbttagcompound.func_74765_d("energy");
    }

    @Override
    public void func_145841_b(NBTTagCompound nbttagcompound) {
        super.func_145841_b(nbttagcompound);
        nbttagcompound.func_74777_a("energy", (short)this.energy);
    }

    @Override
    public void onLoaded() {
        super.onLoaded();
        if (IC2.platform.isSimulating()) {
            MinecraftForge.EVENT_BUS.post((Event)new EnergyTileLoadEvent(this));
            this.addedToEnergyNet = true;
        }
    }

    @Override
    public void onUnloaded() {
        if (IC2.platform.isSimulating() && this.addedToEnergyNet) {
            MinecraftForge.EVENT_BUS.post((Event)new EnergyTileUnloadEvent(this));
            this.addedToEnergyNet = false;
        }
        super.onUnloaded();
    }

    @Override
    public boolean canUpdate() {
        return IC2.platform.isSimulating();
    }

    public void func_145845_h() {
        super.func_145845_h();
        if (!IC2.platform.isSimulating() || !this.redstoned()) {
            return;
        }
        if (this.energy < TileEntityTesla.getCost()) {
            return;
        }
        int damage = this.energy / TileEntityTesla.getCost();
        --this.energy;
        if (this.ticker++ % 32 == 0 && this.shock(damage)) {
            this.energy = 0;
        }
    }

    public boolean shock(int damage) {
        boolean shock = false;
        List list1 = this.field_145850_b.func_72872_a(EntityLivingBase.class, AxisAlignedBB.func_72330_a((double)(this.field_145851_c - 4), (double)(this.field_145848_d - 4), (double)(this.field_145849_e - 4), (double)(this.field_145851_c + 5), (double)(this.field_145848_d + 5), (double)(this.field_145849_e + 5)));
        int l = 0;
        while (l < list1.size()) {
            EntityLivingBase victim = (EntityLivingBase)list1.get(l);
            if (!ItemArmorHazmat.hasCompleteHazmat(victim)) {
                shock = true;
                victim.func_70097_a((DamageSource)IC2DamageSource.electricity, (float)damage);
                int i = 0;
                while (i < damage) {
                    this.field_145850_b.func_72869_a("reddust", victim.field_70165_t + (double)this.field_145850_b.field_73012_v.nextFloat(), victim.field_70163_u + (double)(this.field_145850_b.field_73012_v.nextFloat() * 2.0f), victim.field_70161_v + (double)this.field_145850_b.field_73012_v.nextFloat(), 0.0, 0.0, 1.0);
                    ++i;
                }
            }
            ++l;
        }
        return shock;
    }

    public boolean redstoned() {
        return this.field_145850_b.func_72864_z(this.field_145851_c, this.field_145848_d, this.field_145849_e) || this.field_145850_b.func_72864_z(this.field_145851_c, this.field_145848_d, this.field_145849_e);
    }

    public static int getCost() {
        return 400;
    }

    @Override
    public boolean IC2Classic_acceptsEnergyFrom(TileEntity emitter, Direction direction) {
        return true;
    }

    @Override
    public int IC2Classic_demandsEnergy() {
        return this.maxEnergy - this.energy;
    }

    @Override
    public boolean IC2Classic_injectEnergy(Direction directionFrom, int amount) {
        if (amount > this.maxInput) {
            IC2.explodeMachineAt(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e);
            return true;
        }
        if (this.energy >= this.maxEnergy) {
            return false;
        }
        this.energy += amount;
        return true;
    }

    @Override
    public int IC2Classic_getMaxSafeInput() {
        return this.maxInput;
    }
}

