/*
 * Decompiled with CFR 0.152.
 */
package ic2classic.core.item.tool;

import ic2.api.item.IElectricItem;
import ic2classic.api.electric_item.BatteryAPI;
import ic2classic.core.IC2;
import ic2classic.core.item.tool.ItemToolWrench;
import ic2classic.core.util.StackUtil;
import java.util.List;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;

public class ItemToolWrenchElectric
extends ItemToolWrench
implements IElectricItem {
    public ItemToolWrenchElectric(int index) {
        super(index);
        this.func_77656_e(27);
        this.func_77625_d(1);
    }

    public ItemStack func_77659_a(ItemStack itemstack, World world, EntityPlayer entityplayer) {
        if (IC2.platform.isSimulating() && IC2.keyboard.isModeSwitchKeyDown(entityplayer)) {
            NBTTagCompound nbtData = StackUtil.getOrCreateNbtData(itemstack);
            boolean newValue = !nbtData.func_74767_n("losslessMode");
            nbtData.func_74757_a("losslessMode", newValue);
            if (newValue) {
                IC2.platform.messagePlayer(entityplayer, "Lossless wrench mode enabled");
            } else {
                IC2.platform.messagePlayer(entityplayer, "Lossless wrench mode disabled");
            }
        }
        return itemstack;
    }

    @Override
    public boolean onItemUseFirst(ItemStack itemstack, EntityPlayer entityPlayer, World world, int x, int y, int z, int side, float hitX, float hitY, float hitZ) {
        if (IC2.keyboard.isModeSwitchKeyDown(entityPlayer)) {
            return false;
        }
        return super.onItemUseFirst(itemstack, entityPlayer, world, x, y, z, side, hitX, hitY, hitZ);
    }

    @Override
    public boolean canTakeDamage(ItemStack stack, int amount) {
        return BatteryAPI.discharge(stack, amount *= 50, Integer.MAX_VALUE, true, true) == amount;
    }

    @Override
    public void damage(ItemStack itemStack, int amount, EntityPlayer player) {
        BatteryAPI.use(itemStack, 50 * amount, (EntityLivingBase)player);
    }

    @Override
    public boolean canProvideEnergy(ItemStack stack) {
        return false;
    }

    @Override
    public Item getChargedItem(ItemStack stack) {
        return this;
    }

    @Override
    public Item getEmptyItem(ItemStack stack) {
        return this;
    }

    @Override
    public double getMaxCharge(ItemStack stack) {
        return 12000.0;
    }

    @Override
    public int getTier(ItemStack stack) {
        return 1;
    }

    @Override
    public double getTransferLimit(ItemStack stack) {
        return 250.0;
    }

    public void func_150895_a(Item i, CreativeTabs tabs, List itemList) {
        ItemStack charged = new ItemStack((Item)this, 1);
        BatteryAPI.charge(charged, Integer.MAX_VALUE, Integer.MAX_VALUE, true, false);
        itemList.add(charged);
        itemList.add(new ItemStack((Item)this, 1, this.func_77612_l()));
    }

    @Override
    public boolean overrideWrenchSuccessRate(ItemStack itemStack) {
        NBTTagCompound nbtData = StackUtil.getOrCreateNbtData(itemStack);
        return nbtData.func_74767_n("losslessMode");
    }
}

