/*
 * Decompiled with CFR 0.152.
 */
package ic2classic.core.block.generator.tileentity;

import ic2classic.api.Direction;
import ic2classic.api.IReactorChamber;
import ic2classic.api.IWrenchable;
import ic2classic.core.IC2;
import ic2classic.core.ITickCallback;
import ic2classic.core.block.generator.tileentity.TileEntityNuclearReactor;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;

public abstract class TileEntityReactorChamber
extends TileEntity
implements IWrenchable,
IInventory,
IReactorChamber,
ISidedInventory {
    private static final Direction[] directions = Direction.values();
    private boolean loaded = false;

    public void func_145829_t() {
        super.func_145829_t();
        if (!this.loaded) {
            if (!this.func_145837_r() && this.field_145850_b != null) {
                if (IC2.platform.isSimulating()) {
                    IC2.addSingleTickCallback(this.field_145850_b, new ITickCallback(){

                        @Override
                        public void tickCallback(World world) {
                            TileEntityReactorChamber.this.onLoaded();
                        }
                    });
                } else {
                    this.onLoaded();
                }
            } else {
                IC2.log.warn(this + " (" + this.field_145851_c + "," + this.field_145848_d + "," + this.field_145849_e + ") was not added, isInvalid=" + this.func_145837_r() + ", worldObj=" + this.field_145850_b);
            }
        }
    }

    public void func_145843_s() {
        super.func_145843_s();
        if (this.loaded) {
            this.onUnloaded();
        }
    }

    public void onChunkUnload() {
        super.onChunkUnload();
        if (this.loaded) {
            this.onUnloaded();
        }
    }

    public void onLoaded() {
        this.loaded = true;
    }

    public void onUnloaded() {
        this.loaded = false;
    }

    public boolean canUpdate() {
        return false;
    }

    @Override
    public boolean wrenchCanSetFacing(EntityPlayer entityPlayer, int side) {
        return false;
    }

    @Override
    public short getFacing() {
        return 0;
    }

    @Override
    public void setFacing(short facing) {
    }

    @Override
    public boolean wrenchCanRemove(EntityPlayer entityPlayer) {
        return true;
    }

    @Override
    public float getWrenchDropRate() {
        return 0.8f;
    }

    @Override
    public ItemStack getWrenchDrop(EntityPlayer entityPlayer) {
        return new ItemStack(this.field_145850_b.func_147439_a(this.field_145851_c, this.field_145848_d, this.field_145849_e), 1, this.field_145850_b.func_72805_g(this.field_145851_c, this.field_145848_d, this.field_145849_e));
    }

    public int func_70302_i_() {
        TileEntityNuclearReactor reactor = this.getReactor();
        if (reactor == null) {
            return 0;
        }
        return reactor.func_70302_i_();
    }

    public ItemStack func_70301_a(int i) {
        TileEntityNuclearReactor reactor = this.getReactor();
        if (reactor == null) {
            return null;
        }
        return reactor.func_70301_a(i);
    }

    public ItemStack func_70298_a(int i, int j) {
        TileEntityNuclearReactor reactor = this.getReactor();
        if (reactor == null) {
            return null;
        }
        return reactor.func_70298_a(i, j);
    }

    public void func_70299_a(int i, ItemStack itemstack) {
        TileEntityNuclearReactor reactor = this.getReactor();
        if (reactor == null) {
            return;
        }
        reactor.func_70299_a(i, itemstack);
    }

    public String func_145825_b() {
        TileEntityNuclearReactor reactor = this.getReactor();
        if (reactor == null) {
            return "Nuclear Reactor";
        }
        return reactor.func_145825_b();
    }

    public int func_70297_j_() {
        TileEntityNuclearReactor reactor = this.getReactor();
        if (reactor == null) {
            return 64;
        }
        return reactor.func_70297_j_();
    }

    public boolean func_70300_a(EntityPlayer entityplayer) {
        TileEntityNuclearReactor reactor = this.getReactor();
        if (reactor == null) {
            return false;
        }
        return reactor.func_70300_a(entityplayer);
    }

    public void func_70295_k_() {
        TileEntityNuclearReactor reactor = this.getReactor();
        if (reactor == null) {
            return;
        }
        reactor.func_70295_k_();
    }

    public void func_70305_f() {
        TileEntityNuclearReactor reactor = this.getReactor();
        if (reactor == null) {
            return;
        }
        reactor.func_70305_f();
    }

    public ItemStack func_70304_b(int var1) {
        TileEntityNuclearReactor reactor = this.getReactor();
        if (reactor == null) {
            return null;
        }
        return reactor.func_70304_b(var1);
    }

    public boolean func_102008_b(int i, ItemStack itemstack, int j) {
        return true;
    }

    public boolean func_102007_a(int i, ItemStack itemstack, int j) {
        return true;
    }

    public int[] func_94128_d(int var1) {
        TileEntityNuclearReactor reactor = this.getReactor();
        if (reactor == null) {
            return null;
        }
        return reactor.func_94128_d(var1);
    }

    @Override
    public TileEntityNuclearReactor getReactor() {
        Direction[] directionArray = directions;
        int n = directions.length;
        int n2 = 0;
        while (n2 < n) {
            Direction value = directionArray[n2];
            TileEntity te = value.applyToTileEntity(this);
            if (te instanceof TileEntityNuclearReactor) {
                return (TileEntityNuclearReactor)te;
            }
            ++n2;
        }
        Block blk = this.field_145850_b.func_147439_a(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        if (blk != null) {
            blk.func_149695_a(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e, blk);
        }
        return null;
    }

    public abstract int sendEnergy(int var1);

    public boolean func_145818_k_() {
        return false;
    }

    public boolean func_94041_b(int i, ItemStack itemstack) {
        return true;
    }
}

