/*
 * Decompiled with CFR 0.152.
 */
package ic2classic.core.block.machine.tileentity;

import cpw.mods.fml.common.eventhandler.Event;
import ic2classic.api.Direction;
import ic2classic.api.energy.event.EnergyTileLoadEvent;
import ic2classic.api.energy.event.EnergyTileUnloadEvent;
import ic2classic.api.energy.tile.IEnergySink;
import ic2classic.core.IC2;
import ic2classic.core.Ic2Items;
import ic2classic.core.block.TileEntityBlock;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.MinecraftForge;

public class TileEntityMagnetizer
extends TileEntityBlock
implements IEnergySink {
    public int energy = 0;
    public int ticker = 0;
    public int maxEnergy = 100;
    public int maxInput = 32;
    public boolean addedToEnergyNet = false;

    @Override
    public void func_145839_a(NBTTagCompound nbttagcompound) {
        super.func_145839_a(nbttagcompound);
        this.energy = nbttagcompound.func_74765_d("energy");
    }

    @Override
    public void func_145841_b(NBTTagCompound nbttagcompound) {
        super.func_145841_b(nbttagcompound);
        nbttagcompound.func_74777_a("energy", (short)this.energy);
    }

    @Override
    public boolean canUpdate() {
        return IC2.platform.isSimulating();
    }

    @Override
    public void onLoaded() {
        super.onLoaded();
        if (IC2.platform.isSimulating()) {
            MinecraftForge.EVENT_BUS.post((Event)new EnergyTileLoadEvent(this));
            this.addedToEnergyNet = true;
        }
    }

    @Override
    public void onUnloaded() {
        if (IC2.platform.isSimulating() && this.addedToEnergyNet) {
            MinecraftForge.EVENT_BUS.post((Event)new EnergyTileUnloadEvent(this));
            this.addedToEnergyNet = false;
        }
        super.onUnloaded();
    }

    public void func_145845_h() {
        int need;
        super.func_145845_h();
        if (this.ticker-- > 0) {
            return;
        }
        boolean change = false;
        int y = this.field_145848_d - 1;
        while (y > 0 && y >= this.field_145848_d - 20) {
            if (this.energy <= 0 || this.field_145850_b.func_147439_a(this.field_145851_c, y, this.field_145849_e) != Block.func_149634_a((Item)Ic2Items.ironFence.func_77973_b())) break;
            need = 15 - this.field_145850_b.func_72805_g(this.field_145851_c, y, this.field_145849_e);
            if (need > 0) {
                change = true;
                if (need > this.energy) {
                    this.energy = need;
                }
                this.field_145850_b.func_72921_c(this.field_145851_c, y, this.field_145849_e, this.field_145850_b.func_72805_g(this.field_145851_c, y, this.field_145849_e) + need, 3);
                this.energy -= need;
            }
            --y;
        }
        y = this.field_145848_d + 1;
        while (y < IC2.getWorldHeight(this.field_145850_b) && y <= this.field_145848_d + 20) {
            if (this.energy <= 0 || this.field_145850_b.func_147439_a(this.field_145851_c, y, this.field_145849_e) != Block.func_149634_a((Item)Ic2Items.ironFence.func_77973_b())) break;
            need = 15 - this.field_145850_b.func_72805_g(this.field_145851_c, y, this.field_145849_e);
            if (need > 0) {
                change = true;
                if (need > this.energy) {
                    this.energy = need;
                }
                this.field_145850_b.func_72921_c(this.field_145851_c, y, this.field_145849_e, this.field_145850_b.func_72805_g(this.field_145851_c, y, this.field_145849_e) + need, 3);
                this.energy -= need;
            }
            ++y;
        }
        if (!change) {
            this.ticker = 10;
        }
    }

    @Override
    public boolean IC2Classic_acceptsEnergyFrom(TileEntity emitter, Direction direction) {
        return true;
    }

    @Override
    public int IC2Classic_demandsEnergy() {
        return this.maxEnergy - this.energy;
    }

    @Override
    public boolean IC2Classic_injectEnergy(Direction directionFrom, int amount) {
        if (amount > this.maxInput) {
            IC2.explodeMachineAt(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e);
            return true;
        }
        if (this.energy >= this.maxEnergy) {
            return false;
        }
        this.energy += amount;
        return true;
    }

    @Override
    public int IC2Classic_getMaxSafeInput() {
        return this.maxInput;
    }
}

