/*
 * Decompiled with CFR 0.152.
 */
package ic2classic.core.electric_item_api;

import ic2.api.item.ElectricItem;
import ic2.api.item.IBackupElectricItemManager;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;

public class SingleUseItemManager
implements IBackupElectricItemManager {
    public final Item item;
    public final double euPerItem;

    public SingleUseItemManager(Item item, double euPerItem) {
        this.item = item;
        this.euPerItem = euPerItem;
    }

    @Override
    public double charge(ItemStack stack, double amount, int tier, boolean ignoreTransferLimit, boolean simulate) {
        return 0.0;
    }

    @Override
    public double discharge(ItemStack stack, double amount, int tier, boolean ignoreTransferLimit, boolean externally, boolean simulate) {
        int numItems = Math.min(stack.field_77994_a, (int)Math.ceil(amount / this.euPerItem));
        if (!ignoreTransferLimit && numItems > 1) {
            numItems = 1;
        }
        if (!simulate) {
            stack.field_77994_a -= numItems;
        }
        return (double)numItems * this.euPerItem;
    }

    @Override
    public double getCharge(ItemStack stack) {
        return (double)stack.field_77994_a * this.euPerItem;
    }

    @Override
    public boolean canUse(ItemStack stack, double amount) {
        return ElectricItem.rawManager.canUse(stack, amount);
    }

    @Override
    public boolean use(ItemStack stack, double amount, EntityLivingBase entity) {
        return ElectricItem.rawManager.use(stack, amount, entity);
    }

    @Override
    public void chargeFromArmor(ItemStack stack, EntityLivingBase entity) {
    }

    @Override
    public String getToolTip(ItemStack stack) {
        return "EU per item: " + (int)this.euPerItem;
    }

    @Override
    public boolean handles(ItemStack stack) {
        return stack.func_77973_b() == this.item;
    }
}

