/*
 * Decompiled with CFR 0.152.
 */
package ic2classic.core.block.machine.tileentity;

import ic2classic.api.Direction;
import ic2classic.api.IC2ClassicRecipes;
import ic2classic.core.ContainerIC2;
import ic2classic.core.ExplosionIC2;
import ic2classic.core.IC2;
import ic2classic.core.IHasGui;
import ic2classic.core.Ic2Items;
import ic2classic.core.audio.AudioSource;
import ic2classic.core.audio.PositionSpec;
import ic2classic.core.block.machine.ContainerMatter;
import ic2classic.core.block.machine.tileentity.TileEntityElecMachine;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;

public class TileEntityMatter
extends TileEntityElecMachine
implements IHasGui {
    public int soundTicker = IC2.random.nextInt(32);
    public int scrap = 0;
    private int state = 0;
    private int prevState = 0;
    private AudioSource audioSource;
    private AudioSource audioSourceScrap;

    public TileEntityMatter() {
        super(2, 0, 1100000, 512);
    }

    @Override
    public void func_145839_a(NBTTagCompound nbttagcompound) {
        super.func_145839_a(nbttagcompound);
        try {
            this.scrap = nbttagcompound.func_74762_e("scrap");
        }
        catch (Throwable e) {
            this.scrap = nbttagcompound.func_74765_d("scrap");
        }
    }

    @Override
    public void func_145841_b(NBTTagCompound nbttagcompound) {
        super.func_145841_b(nbttagcompound);
        nbttagcompound.func_74768_a("scrap", this.scrap);
    }

    @Override
    public String func_145825_b() {
        return "Mass Fabricator";
    }

    @Override
    public void func_145845_h() {
        super.func_145845_h();
        if (this.isRedstonePowered() || this.energy <= 0) {
            this.setState(0);
            this.setActive(false);
        } else {
            this.setState(this.scrap > 0 ? 2 : 1);
            this.setActive(true);
            boolean needsInvUpdate = false;
            Object amplifierStack = this.inventory[0];
            if (this.scrap < 1000 && amplifierStack != null) {
                this.scrap += IC2ClassicRecipes.massFabricatorAmplifiers.getAmplification((ItemStack)amplifierStack, true);
                if (amplifierStack.field_77994_a <= 0) {
                    amplifierStack = amplifierStack.func_77973_b().hasContainerItem(amplifierStack) ? amplifierStack.func_77973_b().getContainerItem(amplifierStack) : null;
                }
                this.inventory[0] = amplifierStack;
            }
            if (this.energy >= 1000000) {
                needsInvUpdate = this.attemptGeneration();
            }
            if (needsInvUpdate) {
                this.func_70296_d();
            }
        }
    }

    @Override
    public void onUnloaded() {
        if (IC2.platform.isRendering() && this.audioSource != null) {
            IC2.audioManager.removeSources(this);
            this.audioSource = null;
            this.audioSourceScrap = null;
        }
        super.onUnloaded();
    }

    public boolean attemptGeneration() {
        if (this.inventory[1] == null) {
            this.inventory[1] = new ItemStack(Ic2Items.matter);
            this.energy -= 1000000;
            return true;
        }
        if (this.inventory[1].func_77973_b() != Ic2Items.matter || this.inventory[1].field_77994_a >= this.inventory[1].func_77976_d()) {
            return false;
        }
        this.energy -= 1000000;
        ++this.inventory[1].field_77994_a;
        return true;
    }

    @Override
    public int IC2Classic_demandsEnergy() {
        if (this.isRedstonePowered()) {
            return 0;
        }
        return this.maxEnergy - this.energy;
    }

    @Override
    public boolean IC2Classic_injectEnergy(Direction directionFrom, int amount) {
        if (amount > this.IC2Classic_getMaxSafeInput()) {
            this.field_145850_b.func_147468_f(this.field_145851_c, this.field_145848_d, this.field_145849_e);
            ExplosionIC2 explosion = new ExplosionIC2(this.field_145850_b, null, (float)this.field_145851_c + 0.5f, (float)this.field_145848_d + 0.5f, (float)this.field_145849_e + 0.5f, 15.0f, 0.01f, 1.5f);
            explosion.doExplosion();
            return true;
        }
        if (this.energy >= this.maxEnergy) {
            return false;
        }
        int bonus = amount;
        if (bonus > this.scrap) {
            bonus = this.scrap;
        }
        this.scrap -= bonus;
        this.energy += amount + 5 * bonus;
        return true;
    }

    @Override
    public int IC2Classic_getMaxSafeInput() {
        return 512;
    }

    public String getProgressAsString() {
        int p = this.energy / 10000;
        if (p > 100) {
            p = 100;
        }
        return p + "%";
    }

    @Override
    public ContainerIC2 getGuiContainer(EntityPlayer entityPlayer) {
        return new ContainerMatter(entityPlayer, this);
    }

    @Override
    public String getGuiClassName(EntityPlayer entityPlayer) {
        return "block.machine.gui.GuiMatter";
    }

    @Override
    public void onGuiClosed(EntityPlayer entityPlayer) {
    }

    private void setState(int state) {
        this.state = state;
        if (this.prevState != state) {
            this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        }
        this.prevState = state;
    }

    @Override
    public void writeDescriptionNBT(NBTTagCompound tag) {
        super.writeDescriptionNBT(tag);
        tag.func_74768_a("state", this.state);
    }

    @Override
    public void readDescriptionNBT(NBTTagCompound tag) {
        super.readDescriptionNBT(tag);
        this.state = tag.func_74762_e("state");
        if (this.prevState != this.state) {
            switch (this.state) {
                case 0: {
                    if (this.audioSource != null) {
                        this.audioSource.stop();
                    }
                    if (this.audioSourceScrap == null) break;
                    this.audioSourceScrap.stop();
                    break;
                }
                case 1: {
                    if (this.audioSource == null) {
                        this.audioSource = IC2.audioManager.createSource(this, PositionSpec.Center, "Generators/MassFabricator/MassFabLoop.ogg", true, false, IC2.audioManager.defaultVolume);
                    }
                    if (this.audioSource != null) {
                        this.audioSource.play();
                    }
                    if (this.audioSourceScrap == null) break;
                    this.audioSourceScrap.stop();
                    break;
                }
                case 2: {
                    if (this.audioSource == null) {
                        this.audioSource = IC2.audioManager.createSource(this, PositionSpec.Center, "Generators/MassFabricator/MassFabLoop.ogg", true, false, IC2.audioManager.defaultVolume);
                    }
                    if (this.audioSourceScrap == null) {
                        this.audioSourceScrap = IC2.audioManager.createSource(this, PositionSpec.Center, "Generators/MassFabricator/MassFabScrapSolo.ogg", true, false, IC2.audioManager.defaultVolume);
                    }
                    if (this.audioSource != null) {
                        this.audioSource.play();
                    }
                    if (this.audioSourceScrap == null) break;
                    this.audioSourceScrap.play();
                }
            }
            this.prevState = this.state;
        }
    }

    public int[] func_94128_d(int var1) {
        if (var1 == 0) {
            return new int[1];
        }
        if (var1 == 1) {
            return new int[]{1};
        }
        return new int[0];
    }

    @Override
    public float getWrenchDropRate() {
        return 0.7f;
    }
}

