/*
 * Decompiled with CFR 0.152.
 */
package ic2classic.core.block.machine.tileentity;

import ic2classic.api.electric_item.BatteryAPI;
import ic2classic.core.ContainerIC2;
import ic2classic.core.IC2;
import ic2classic.core.IHasGui;
import ic2classic.core.Ic2Items;
import ic2classic.core.audio.AudioSource;
import ic2classic.core.audio.PositionSpec;
import ic2classic.core.block.machine.ContainerMiner;
import ic2classic.core.block.machine.tileentity.TileEntityElecMachine;
import ic2classic.core.block.machine.tileentity.TileEntityPump;
import ic2classic.core.item.tool.ItemElectricToolDDrill;
import ic2classic.core.item.tool.ItemElectricToolDrill;
import ic2classic.core.item.tool.ItemScanner;
import ic2classic.core.util.StackUtil;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class TileEntityMiner
extends TileEntityElecMachine
implements IHasGui {
    public int targetX = 0;
    public int targetY = -1;
    public int targetZ = 0;
    public short miningTicker = 0;
    public String stuckOn = null;
    private AudioSource audioSource;

    public TileEntityMiner() {
        super(4, 0, 1000, 32, IC2.enableMinerLapotron ? 3 : 1);
    }

    @Override
    public void func_145845_h() {
        super.func_145845_h();
        boolean wasOperating = this.isOperating();
        boolean needsInvUpdate = false;
        if (this.isOperating()) {
            --this.energy;
            if (this.inventory[1] != null && this.inventory[1].func_77973_b() instanceof ItemScanner) {
                this.energy -= BatteryAPI.charge(this.inventory[1], this.energy, 2, false, false);
            }
            if (this.inventory[3] != null && (this.inventory[3].func_77973_b() instanceof ItemElectricToolDrill || this.inventory[3].func_77973_b() instanceof ItemElectricToolDDrill)) {
                this.energy -= BatteryAPI.charge(this.inventory[3], this.energy, 1, false, false);
            }
        }
        if (this.energy <= this.maxEnergy) {
            needsInvUpdate = this.provideEnergy();
        }
        if (wasOperating) {
            needsInvUpdate = this.mine();
        } else if (this.inventory[3] == null) {
            if (this.energy >= 2 && this.canWithdraw()) {
                this.targetY = -1;
                this.miningTicker = (short)(this.miningTicker + 1);
                this.energy -= 2;
                if (this.miningTicker >= 20) {
                    this.miningTicker = 0;
                    needsInvUpdate = this.withdrawPipe();
                }
            } else if (this.isStuck()) {
                this.miningTicker = 0;
            }
        }
        this.setActive(this.isOperating());
        if (wasOperating != this.isOperating()) {
            needsInvUpdate = true;
        }
        if (needsInvUpdate) {
            this.func_70296_d();
        }
    }

    @Override
    public void onUnloaded() {
        if (IC2.platform.isRendering() && this.audioSource != null) {
            IC2.audioManager.removeSources(this);
            this.audioSource = null;
        }
        super.onUnloaded();
    }

    @Override
    public void func_145839_a(NBTTagCompound nbttagcompound) {
        super.func_145839_a(nbttagcompound);
        this.targetX = nbttagcompound.func_74762_e("targetX");
        this.targetY = nbttagcompound.func_74762_e("targetY");
        this.targetZ = nbttagcompound.func_74762_e("targetZ");
        this.miningTicker = nbttagcompound.func_74765_d("miningTicker");
    }

    @Override
    public void func_145841_b(NBTTagCompound nbttagcompound) {
        super.func_145841_b(nbttagcompound);
        nbttagcompound.func_74768_a("targetX", (int)((short)this.targetX));
        nbttagcompound.func_74768_a("targetY", (int)((short)this.targetY));
        nbttagcompound.func_74768_a("targetZ", (int)((short)this.targetZ));
        nbttagcompound.func_74777_a("miningTicker", this.miningTicker);
    }

    public boolean mine() {
        if (this.targetY < 0) {
            this.aquireTarget();
            return false;
        }
        if (!this.canReachTarget(this.targetX, this.targetY, this.targetZ, true)) {
            int x = this.targetX - this.field_145851_c;
            int z = this.targetZ - this.field_145849_e;
            if (Math.abs(x) > Math.abs(z)) {
                this.targetX = x > 0 ? --this.targetX : ++this.targetX;
            } else {
                this.targetZ = z > 0 ? --this.targetZ : ++this.targetZ;
            }
            return false;
        }
        if (!this.canMine(this.targetX, this.targetY, this.targetZ)) {
            Block id = this.field_145850_b.func_147439_a(this.targetX, this.targetY, this.targetZ);
            if (id.func_149688_o().func_76224_d() && this.isAnyPumpConnected()) {
                return false;
            }
            this.miningTicker = (short)-1;
            this.stuckOn = id.func_149739_a();
            return false;
        }
        this.stuckOn = null;
        this.miningTicker = (short)(this.miningTicker + 1);
        --this.energy;
        if (this.inventory[3].func_77973_b() == Ic2Items.diamondDrill) {
            this.miningTicker = (short)(this.miningTicker + 3);
            this.energy -= 14;
        }
        if (this.miningTicker >= 200) {
            this.miningTicker = 0;
            this.mineBlock();
            return true;
        }
        return false;
    }

    public void mineBlock() {
        if (this.inventory[3].func_77973_b() instanceof ItemElectricToolDrill) {
            BatteryAPI.use(this.inventory[3], 50, null);
        } else if (this.inventory[3].func_77973_b() instanceof ItemElectricToolDDrill) {
            BatteryAPI.use(this.inventory[3], 80, null);
        }
        Block id = this.field_145850_b.func_147439_a(this.targetX, this.targetY, this.targetZ);
        int meta = this.field_145850_b.func_72805_g(this.targetX, this.targetY, this.targetZ);
        boolean liquid = false;
        if (id.func_149688_o().func_76224_d()) {
            liquid = true;
            if (meta != 0) {
                id = Blocks.field_150350_a;
            }
        }
        if (!id.isAir((IBlockAccess)this.field_145850_b, this.targetX, this.targetY, this.targetZ)) {
            if (!liquid) {
                Block ore = id;
                StackUtil.distributeDrop(this, ore.getDrops(this.field_145850_b, this.targetX, this.targetY, this.targetZ, meta, EnchantmentHelper.func_77506_a((int)Enchantment.field_77346_s.field_77352_x, (ItemStack)this.inventory[3])));
            } else {
                if (id.func_149688_o() == Material.field_151586_h) {
                    this.usePump(Blocks.field_150355_j);
                }
                if (id.func_149688_o() == Material.field_151587_i) {
                    this.usePump(Blocks.field_150353_l);
                }
            }
            this.field_145850_b.func_147468_f(this.targetX, this.targetY, this.targetZ);
            this.energy -= 2 * (this.field_145848_d - this.targetY);
        }
        if (this.targetX == this.field_145851_c && this.targetZ == this.field_145849_e) {
            this.field_145850_b.func_147449_b(this.targetX, this.targetY, this.targetZ, Block.func_149634_a((Item)Ic2Items.miningPipe.func_77973_b()));
            if (this.inventory[2].field_77994_a == 0) {
                this.inventory[2] = null;
            }
            this.energy -= 10;
        }
        this.updateMineTip(this.targetY);
        this.targetY = -1;
    }

    public boolean withdrawPipe() {
        int y = this.getPipeTip();
        Block blockId = this.field_145850_b.func_147439_a(this.field_145851_c, y, this.field_145849_e);
        if (!blockId.isAir((IBlockAccess)this.field_145850_b, this.field_145851_c, y, this.field_145849_e)) {
            StackUtil.distributeDrop(this, blockId.getDrops(this.field_145850_b, this.field_145851_c, y, this.field_145849_e, this.field_145850_b.func_72805_g(this.field_145851_c, y, this.field_145849_e), 0));
            this.field_145850_b.func_147468_f(this.field_145851_c, y, this.field_145849_e);
        }
        if (this.inventory[2] != null && this.inventory[2].func_77973_b() != Ic2Items.miningPipe.func_77973_b() && this.inventory[2].func_77973_b() instanceof ItemBlock) {
            this.field_145850_b.func_147465_d(this.field_145851_c, y, this.field_145849_e, Block.func_149634_a((Item)this.inventory[2].func_77973_b()), this.inventory[2].func_77960_j(), 3);
            --this.inventory[2].field_77994_a;
            if (this.inventory[2].field_77994_a == 0) {
                this.inventory[2] = null;
            }
            this.updateMineTip(y + 1);
            return true;
        }
        this.updateMineTip(y + 1);
        return false;
    }

    public void updateMineTip(int low) {
        if (low == this.field_145848_d) {
            return;
        }
        int x = this.field_145851_c;
        int y = this.field_145848_d - 1;
        int z = this.field_145849_e;
        while (y > low) {
            Block id = this.field_145850_b.func_147439_a(x, y, z);
            if (id != Block.func_149634_a((Item)Ic2Items.miningPipe.func_77973_b()) && this.inventory[2] != null && this.inventory[2].field_77994_a > 0) {
                this.field_145850_b.func_147449_b(x, y, z, Block.func_149634_a((Item)Ic2Items.miningPipe.func_77973_b()));
                --this.inventory[2].field_77994_a;
                if (this.inventory[2].field_77994_a <= 0) {
                    this.inventory[2] = null;
                }
            }
            --y;
        }
        this.field_145850_b.func_147449_b(x, low, z, Block.func_149634_a((Item)Ic2Items.miningPipeTip.func_77973_b()));
    }

    public boolean canReachTarget(int x, int y, int z, boolean ignore) {
        if (this.field_145851_c == x && this.field_145849_e == z) {
            return true;
        }
        if (!ignore && !this.canPass(this.field_145850_b.func_147439_a(x, y, z), this.field_145850_b, x, y, z)) {
            return false;
        }
        int xdif = x - this.field_145851_c;
        int zdif = z - this.field_145849_e;
        if (Math.abs(xdif) > Math.abs(zdif)) {
            x = xdif > 0 ? --x : ++x;
        } else {
            z = zdif > 0 ? --z : ++z;
        }
        return this.canReachTarget(x, y, z, false);
    }

    public void aquireTarget() {
        int y = this.getPipeTip();
        if (y >= this.field_145848_d || this.inventory[1] == null || !(this.inventory[1].func_77973_b() instanceof ItemScanner)) {
            this.setTarget(this.field_145851_c, y - 1, this.field_145849_e);
            return;
        }
        int scanrange = ((ItemScanner)this.inventory[1].func_77973_b()).startLayerScan(this.inventory[1]);
        if (scanrange > 0) {
            int x = this.field_145851_c - scanrange;
            while (x <= this.field_145851_c + scanrange) {
                int z = this.field_145849_e - scanrange;
                while (z <= this.field_145849_e + scanrange) {
                    int m;
                    Block n = this.field_145850_b.func_147439_a(x, y, z);
                    if (ItemScanner.isValuable(n, m = this.field_145850_b.func_72805_g(x, y, z)) && this.canMine(x, y, z) || this.isAnyPumpConnected() && this.field_145850_b.func_72805_g(x, y, z) == 0 && n.func_149688_o() == Material.field_151587_i) {
                        this.setTarget(x, y, z);
                        return;
                    }
                    ++z;
                }
                ++x;
            }
        }
        this.setTarget(this.field_145851_c, y - 1, this.field_145849_e);
    }

    public void setTarget(int x, int y, int z) {
        this.targetX = x;
        this.targetY = y;
        this.targetZ = z;
    }

    public int getPipeTip() {
        int y = this.field_145848_d;
        while (this.field_145850_b.func_147439_a(this.field_145851_c, y - 1, this.field_145849_e) == Block.func_149634_a((Item)Ic2Items.miningPipe.func_77973_b()) || this.field_145850_b.func_147439_a(this.field_145851_c, y - 1, this.field_145849_e) == Block.func_149634_a((Item)Ic2Items.miningPipeTip.func_77973_b())) {
            --y;
        }
        return y;
    }

    public boolean canPass(Block id, World w, int x, int y, int z) {
        if (id.isAir((IBlockAccess)w, x, y, z) || id.func_149688_o().func_76224_d()) {
            return true;
        }
        Item item = Item.func_150898_a((Block)id);
        return item == Ic2Items.miner.func_77973_b() || item == Ic2Items.miningPipe.func_77973_b() || item == Ic2Items.miningPipeTip.func_77973_b();
    }

    public boolean isOperating() {
        return this.energy > 100 && this.canOperate();
    }

    public boolean canOperate() {
        if (this.inventory[2] == null || this.inventory[3] == null) {
            return false;
        }
        if (this.inventory[2].func_77973_b() != Ic2Items.miningPipe.func_77973_b()) {
            return false;
        }
        if (this.inventory[3].func_77973_b() != Ic2Items.miningDrill && this.inventory[3].func_77973_b() != Ic2Items.diamondDrill) {
            return false;
        }
        return !this.isStuck();
    }

    public boolean isStuck() {
        return this.miningTicker < 0;
    }

    public String getStuckOn() {
        return this.stuckOn;
    }

    public boolean canMine(int x, int y, int z) {
        Block id = this.field_145850_b.func_147439_a(x, y, z);
        int meta = this.field_145850_b.func_72805_g(x, y, z);
        if (id.isAir((IBlockAccess)this.field_145850_b, x, y, z)) {
            return true;
        }
        Item item = Item.func_150898_a((Block)id);
        if (item == Ic2Items.miningPipe.func_77973_b() || item == Ic2Items.miningPipeTip.func_77973_b() || id == Blocks.field_150486_ae) {
            return false;
        }
        if (id.func_149688_o().func_76224_d() && this.isPumpConnected()) {
            return true;
        }
        Block block = id;
        if (block.func_149712_f(this.field_145850_b, x, y, z) < 0.0f) {
            return false;
        }
        if (block.func_149678_a(meta, false) && block.func_149688_o().func_76229_l()) {
            return true;
        }
        if (id == Blocks.field_150321_G) {
            return true;
        }
        return true;
    }

    public boolean canWithdraw() {
        return this.field_145850_b.func_147439_a(this.field_145851_c, this.field_145848_d - 1, this.field_145849_e) == Block.func_149634_a((Item)Ic2Items.miningPipe.func_77973_b()) || this.field_145850_b.func_147439_a(this.field_145851_c, this.field_145848_d - 1, this.field_145849_e) == Block.func_149634_a((Item)Ic2Items.miningPipeTip.func_77973_b());
    }

    public boolean isPumpConnected() {
        if (this.field_145850_b.func_147438_o(this.field_145851_c, this.field_145848_d + 1, this.field_145849_e) instanceof TileEntityPump && ((TileEntityPump)this.field_145850_b.func_147438_o(this.field_145851_c, this.field_145848_d + 1, this.field_145849_e)).canHarvest()) {
            return true;
        }
        if (this.field_145850_b.func_147438_o(this.field_145851_c, this.field_145848_d - 1, this.field_145849_e) instanceof TileEntityPump && ((TileEntityPump)this.field_145850_b.func_147438_o(this.field_145851_c, this.field_145848_d - 1, this.field_145849_e)).canHarvest()) {
            return true;
        }
        if (this.field_145850_b.func_147438_o(this.field_145851_c + 1, this.field_145848_d, this.field_145849_e) instanceof TileEntityPump && ((TileEntityPump)this.field_145850_b.func_147438_o(this.field_145851_c + 1, this.field_145848_d, this.field_145849_e)).canHarvest()) {
            return true;
        }
        if (this.field_145850_b.func_147438_o(this.field_145851_c - 1, this.field_145848_d, this.field_145849_e) instanceof TileEntityPump && ((TileEntityPump)this.field_145850_b.func_147438_o(this.field_145851_c - 1, this.field_145848_d, this.field_145849_e)).canHarvest()) {
            return true;
        }
        if (this.field_145850_b.func_147438_o(this.field_145851_c, this.field_145848_d, this.field_145849_e + 1) instanceof TileEntityPump && ((TileEntityPump)this.field_145850_b.func_147438_o(this.field_145851_c, this.field_145848_d, this.field_145849_e + 1)).canHarvest()) {
            return true;
        }
        return this.field_145850_b.func_147438_o(this.field_145851_c, this.field_145848_d, this.field_145849_e - 1) instanceof TileEntityPump && ((TileEntityPump)this.field_145850_b.func_147438_o(this.field_145851_c, this.field_145848_d, this.field_145849_e - 1)).canHarvest();
    }

    public boolean isAnyPumpConnected() {
        if (this.field_145850_b.func_147438_o(this.field_145851_c, this.field_145848_d + 1, this.field_145849_e) instanceof TileEntityPump) {
            return true;
        }
        if (this.field_145850_b.func_147438_o(this.field_145851_c, this.field_145848_d - 1, this.field_145849_e) instanceof TileEntityPump) {
            return true;
        }
        if (this.field_145850_b.func_147438_o(this.field_145851_c + 1, this.field_145848_d, this.field_145849_e) instanceof TileEntityPump) {
            return true;
        }
        if (this.field_145850_b.func_147438_o(this.field_145851_c - 1, this.field_145848_d, this.field_145849_e) instanceof TileEntityPump) {
            return true;
        }
        if (this.field_145850_b.func_147438_o(this.field_145851_c, this.field_145848_d, this.field_145849_e + 1) instanceof TileEntityPump) {
            return true;
        }
        return this.field_145850_b.func_147438_o(this.field_145851_c, this.field_145848_d, this.field_145849_e - 1) instanceof TileEntityPump;
    }

    public void usePump(Block id) {
        if (this.field_145850_b.func_147438_o(this.field_145851_c, this.field_145848_d + 1, this.field_145849_e) instanceof TileEntityPump && ((TileEntityPump)this.field_145850_b.func_147438_o(this.field_145851_c, this.field_145848_d + 1, this.field_145849_e)).canHarvest()) {
            ((TileEntityPump)this.field_145850_b.func_147438_o(this.field_145851_c, this.field_145848_d + 1, this.field_145849_e)).pumpThis(id);
            return;
        }
        if (this.field_145850_b.func_147438_o(this.field_145851_c, this.field_145848_d - 1, this.field_145849_e) instanceof TileEntityPump && ((TileEntityPump)this.field_145850_b.func_147438_o(this.field_145851_c, this.field_145848_d - 1, this.field_145849_e)).canHarvest()) {
            ((TileEntityPump)this.field_145850_b.func_147438_o(this.field_145851_c, this.field_145848_d - 1, this.field_145849_e)).pumpThis(id);
            return;
        }
        if (this.field_145850_b.func_147438_o(this.field_145851_c + 1, this.field_145848_d, this.field_145849_e) instanceof TileEntityPump && ((TileEntityPump)this.field_145850_b.func_147438_o(this.field_145851_c + 1, this.field_145848_d, this.field_145849_e)).canHarvest()) {
            ((TileEntityPump)this.field_145850_b.func_147438_o(this.field_145851_c + 1, this.field_145848_d, this.field_145849_e)).pumpThis(id);
            return;
        }
        if (this.field_145850_b.func_147438_o(this.field_145851_c - 1, this.field_145848_d, this.field_145849_e) instanceof TileEntityPump && ((TileEntityPump)this.field_145850_b.func_147438_o(this.field_145851_c - 1, this.field_145848_d, this.field_145849_e)).canHarvest()) {
            ((TileEntityPump)this.field_145850_b.func_147438_o(this.field_145851_c - 1, this.field_145848_d, this.field_145849_e)).pumpThis(id);
            return;
        }
        if (this.field_145850_b.func_147438_o(this.field_145851_c, this.field_145848_d, this.field_145849_e + 1) instanceof TileEntityPump && ((TileEntityPump)this.field_145850_b.func_147438_o(this.field_145851_c, this.field_145848_d, this.field_145849_e + 1)).canHarvest()) {
            ((TileEntityPump)this.field_145850_b.func_147438_o(this.field_145851_c, this.field_145848_d, this.field_145849_e + 1)).pumpThis(id);
            return;
        }
        if (this.field_145850_b.func_147438_o(this.field_145851_c, this.field_145848_d, this.field_145849_e - 1) instanceof TileEntityPump && ((TileEntityPump)this.field_145850_b.func_147438_o(this.field_145851_c, this.field_145848_d, this.field_145849_e - 1)).canHarvest()) {
            ((TileEntityPump)this.field_145850_b.func_147438_o(this.field_145851_c, this.field_145848_d, this.field_145849_e - 1)).pumpThis(id);
            return;
        }
    }

    @Override
    public String func_145825_b() {
        return "Miner";
    }

    public int gaugeEnergyScaled(int i) {
        if (this.energy <= 0) {
            return 0;
        }
        int r = this.energy * i / 1000;
        if (r > i) {
            r = i;
        }
        return r;
    }

    @Override
    public ContainerIC2 getGuiContainer(EntityPlayer entityPlayer) {
        return new ContainerMiner(entityPlayer, this);
    }

    @Override
    public String getGuiClassName(EntityPlayer entityPlayer) {
        return "block.machine.gui.GuiMiner";
    }

    @Override
    public void onGuiClosed(EntityPlayer entityPlayer) {
    }

    @Override
    public void readDescriptionNBT(NBTTagCompound tag) {
        boolean prevActive = this.getActive();
        super.readDescriptionNBT(tag);
        if (prevActive != this.getActive()) {
            if (this.audioSource == null) {
                this.audioSource = IC2.audioManager.createSource(this, PositionSpec.Center, "Machines/MinerOp.ogg", true, false, IC2.audioManager.defaultVolume);
            }
            if (this.getActive()) {
                if (this.audioSource != null) {
                    this.audioSource.play();
                }
            } else if (this.audioSource != null) {
                this.audioSource.stop();
            }
        }
    }

    public int[] func_94128_d(int side) {
        ForgeDirection backSide;
        ForgeDirection frontSide;
        ForgeDirection rightSide;
        ForgeDirection leftSide;
        switch (this.getFacing()) {
            case 2: {
                leftSide = ForgeDirection.WEST;
                rightSide = ForgeDirection.EAST;
                frontSide = ForgeDirection.SOUTH;
                backSide = ForgeDirection.NORTH;
                break;
            }
            case 3: {
                leftSide = ForgeDirection.EAST;
                rightSide = ForgeDirection.WEST;
                frontSide = ForgeDirection.NORTH;
                backSide = ForgeDirection.SOUTH;
                break;
            }
            case 4: {
                leftSide = ForgeDirection.SOUTH;
                rightSide = ForgeDirection.NORTH;
                frontSide = ForgeDirection.EAST;
                backSide = ForgeDirection.WEST;
                break;
            }
            default: {
                leftSide = ForgeDirection.NORTH;
                rightSide = ForgeDirection.SOUTH;
                frontSide = ForgeDirection.WEST;
                backSide = ForgeDirection.EAST;
            }
        }
        if (side == leftSide.ordinal() || side == frontSide.ordinal()) {
            return new int[]{3};
        }
        if (side == rightSide.ordinal() || side == backSide.ordinal()) {
            return new int[]{1};
        }
        if (side == 0) {
            return new int[1];
        }
        return new int[]{2};
    }

    public int getSizeInventorySide(ForgeDirection side) {
        return 1;
    }
}

