/*
 * Decompiled with CFR 0.152.
 */
package ic2classic.core.block.wiring;

import cpw.mods.fml.common.eventhandler.Event;
import ic2classic.api.Direction;
import ic2classic.api.energy.event.EnergyTileLoadEvent;
import ic2classic.api.energy.event.EnergyTileUnloadEvent;
import ic2classic.api.energy.tile.IEnergyConductor;
import ic2classic.api.energy.tile.IEnergySink;
import ic2classic.api.energy.tile.IEnergySource;
import ic2classic.api.network.INetworkTileEntityEventListener;
import ic2classic.core.IC2;
import ic2classic.core.ITickCallback;
import ic2classic.core.block.TileEntityBlock;
import ic2classic.core.block.wiring.TileEntityLuminator;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;

public class TileEntityCable
extends TileEntityBlock
implements IEnergyConductor,
INetworkTileEntityEventListener {
    public short cableType = 0;
    public short color = 0;
    public byte foamed = 0;
    public byte foamColor = 0;
    public boolean addedToEnergyNet = false;

    public TileEntityCable(short type) {
        this.cableType = type;
    }

    public TileEntityCable() {
    }

    @Override
    public void func_145839_a(NBTTagCompound nbttagcompound) {
        super.func_145839_a(nbttagcompound);
        this.cableType = nbttagcompound.func_74765_d("cableType");
        this.color = nbttagcompound.func_74765_d("color");
        this.foamColor = nbttagcompound.func_74771_c("foamColor");
        byte wasFoamed = nbttagcompound.func_74771_c("foamed");
        if (wasFoamed == 1) {
            this.changeFoam(wasFoamed, true);
        } else {
            this.foamed = wasFoamed;
        }
    }

    @Override
    public void func_145841_b(NBTTagCompound nbttagcompound) {
        super.func_145841_b(nbttagcompound);
        nbttagcompound.func_74777_a("cableType", this.cableType);
        nbttagcompound.func_74777_a("color", this.color);
        nbttagcompound.func_74774_a("foamed", this.foamed);
        nbttagcompound.func_74774_a("foamColor", this.foamColor);
    }

    @Override
    public void onLoaded() {
        super.onLoaded();
        if (IC2.platform.isSimulating() && !this.addedToEnergyNet) {
            MinecraftForge.EVENT_BUS.post((Event)new EnergyTileLoadEvent(this));
            this.addedToEnergyNet = true;
        }
    }

    @Override
    public void onUnloaded() {
        if (IC2.platform.isSimulating() && this.addedToEnergyNet) {
            MinecraftForge.EVENT_BUS.post((Event)new EnergyTileUnloadEvent(this));
            this.addedToEnergyNet = false;
        }
        super.onUnloaded();
    }

    public boolean changeColor(int newColor) {
        if (this.foamed == 0 && (this.color == newColor || this.cableType == 1 || this.cableType == 2 || this.cableType == 5 || this.cableType == 10 || this.cableType == 11 || this.cableType == 12) || this.foamed > 0 && this.foamColor == newColor) {
            return false;
        }
        if (IC2.platform.isSimulating()) {
            if (this.foamed == 0) {
                if (this.addedToEnergyNet) {
                    MinecraftForge.EVENT_BUS.post((Event)new EnergyTileUnloadEvent(this));
                }
                this.addedToEnergyNet = false;
                this.color = (short)newColor;
                if (this.loaded) {
                    MinecraftForge.EVENT_BUS.post((Event)new EnergyTileLoadEvent(this));
                    this.addedToEnergyNet = true;
                }
                this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
            } else {
                this.foamColor = (byte)newColor;
                this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
            }
        }
        return true;
    }

    public boolean changeFoam(byte foamed) {
        return this.changeFoam(foamed, false);
    }

    public boolean tryAddInsulation() {
        short target;
        switch (this.cableType) {
            case 1: {
                target = 0;
                break;
            }
            case 2: {
                target = 3;
                break;
            }
            case 3: {
                target = 4;
                break;
            }
            case 5: {
                target = 6;
                break;
            }
            case 6: {
                target = 7;
                break;
            }
            case 7: {
                target = 8;
                break;
            }
            default: {
                target = this.cableType;
            }
        }
        if (target != this.cableType) {
            if (IC2.platform.isSimulating()) {
                this.changeType(target);
            }
            return true;
        }
        return false;
    }

    public boolean tryRemoveInsulation() {
        short target;
        switch (this.cableType) {
            case 0: {
                target = 1;
                break;
            }
            case 3: {
                target = 2;
                break;
            }
            case 4: {
                target = 3;
                break;
            }
            case 6: {
                target = 5;
                break;
            }
            case 7: {
                target = 6;
                break;
            }
            case 8: {
                target = 7;
                break;
            }
            default: {
                target = this.cableType;
            }
        }
        if (target != this.cableType) {
            if (IC2.platform.isSimulating()) {
                this.changeType(target);
            }
            return true;
        }
        return false;
    }

    public void changeType(short cableType) {
        this.field_145850_b.func_72921_c(this.field_145851_c, this.field_145848_d, this.field_145849_e, (int)cableType, 3);
        if (this.addedToEnergyNet) {
            MinecraftForge.EVENT_BUS.post((Event)new EnergyTileUnloadEvent(this));
        }
        this.addedToEnergyNet = false;
        this.cableType = cableType;
        if (this.loaded) {
            MinecraftForge.EVENT_BUS.post((Event)new EnergyTileLoadEvent(this));
            this.addedToEnergyNet = true;
        }
        this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
    }

    @Override
    public boolean wrenchCanSetFacing(EntityPlayer entityPlayer, int side) {
        return false;
    }

    @Override
    public boolean wrenchCanRemove(EntityPlayer entityPlayer) {
        return false;
    }

    @Override
    public boolean IC2Classic_acceptsEnergyFrom(TileEntity emitter, Direction direction) {
        return !(emitter instanceof TileEntityCable) || this.canInteractWithCable((TileEntityCable)emitter);
    }

    @Override
    public boolean IC2Classic_emitsEnergyTo(TileEntity receiver, Direction direction) {
        if (receiver instanceof TileEntityCable && !this.canInteractWithCable((TileEntityCable)receiver)) {
            return false;
        }
        if (receiver instanceof TileEntityLuminator) {
            return ((TileEntityLuminator)receiver).canCableConnectFrom(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        }
        return true;
    }

    public boolean canInteractWith(TileEntity te) {
        if (te instanceof TileEntityCable) {
            return this.canInteractWithCable((TileEntityCable)te);
        }
        if (te instanceof TileEntityLuminator) {
            return ((TileEntityLuminator)te).canCableConnectFrom(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        }
        return te instanceof IEnergySink || te instanceof IEnergySource || te instanceof INetworkTileEntityEventListener;
    }

    public boolean canInteractWithCable(TileEntityCable cable) {
        return this.color == 0 || cable.color == 0 || this.color == cable.color;
    }

    public float getCableThickness() {
        if (this.foamed == 2) {
            return 1.0f;
        }
        return TileEntityCable.getCableThickness(this.cableType);
    }

    public static float getCableThickness(int cableType) {
        float p = 1.0f;
        switch (cableType) {
            case 0: {
                p = 6.0f;
                break;
            }
            case 1: {
                p = 4.0f;
                break;
            }
            case 2: {
                p = 3.0f;
                break;
            }
            case 3: {
                p = 5.0f;
                break;
            }
            case 4: {
                p = 6.0f;
                break;
            }
            case 5: {
                p = 6.0f;
                break;
            }
            case 6: {
                p = 8.0f;
                break;
            }
            case 7: {
                p = 10.0f;
                break;
            }
            case 8: {
                p = 12.0f;
                break;
            }
            case 9: {
                p = 4.0f;
                break;
            }
            case 10: {
                p = 5.0f;
                break;
            }
            case 11: {
                p = 8.0f;
                break;
            }
            case 12: {
                p = 8.0f;
                break;
            }
            case 13: {
                p = 16.0f;
            }
        }
        return p / 16.0f;
    }

    @Override
    public double IC2Classic_getConductionLoss() {
        switch (this.cableType) {
            case 0: {
                return 0.2;
            }
            case 1: {
                return 0.3;
            }
            case 2: {
                return 0.5;
            }
            case 3: {
                return 0.45;
            }
            case 4: {
                return 0.4;
            }
            case 5: {
                return 1.0;
            }
            case 6: {
                return 0.95;
            }
            case 7: {
                return 0.9;
            }
            case 8: {
                return 0.8;
            }
            case 9: {
                return 0.025;
            }
            case 10: {
                return 0.025;
            }
            case 11: {
                return 0.5;
            }
            case 12: {
                return 0.5;
            }
        }
        return 0.025;
    }

    @Override
    public int IC2Classic_getInsulationEnergyAbsorption() {
        switch (this.cableType) {
            case 0: {
                return 32;
            }
            case 1: {
                return 8;
            }
            case 2: {
                return 8;
            }
            case 3: {
                return 32;
            }
            case 4: {
                return 128;
            }
            case 5: {
                return 0;
            }
            case 6: {
                return 128;
            }
            case 7: {
                return 512;
            }
            case 8: {
                return 9001;
            }
            case 9: {
                return 9001;
            }
            case 10: {
                return 3;
            }
            case 11: {
                return 9001;
            }
            case 12: {
                return 9001;
            }
        }
        return 0;
    }

    @Override
    public int IC2Classic_getInsulationBreakdownEnergy() {
        return 9001;
    }

    @Override
    public int IC2Classic_getConductorBreakdownEnergy() {
        switch (this.cableType) {
            case 0: {
                return 33;
            }
            case 1: {
                return 33;
            }
            case 2: {
                return 129;
            }
            case 3: {
                return 129;
            }
            case 4: {
                return 129;
            }
            case 5: {
                return 2049;
            }
            case 6: {
                return 2049;
            }
            case 7: {
                return 2049;
            }
            case 8: {
                return 2049;
            }
            case 9: {
                return 513;
            }
            case 10: {
                return 6;
            }
            case 11: {
                return 2049;
            }
            case 12: {
                return 2049;
            }
        }
        return 0;
    }

    @Override
    public void IC2Classic_removeInsulation() {
    }

    @Override
    public void IC2Classic_removeConductor() {
        this.field_145850_b.func_147468_f(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        IC2.network.initiateTileEntityEvent(this, 0, true);
    }

    @Override
    public void writeDescriptionNBT(NBTTagCompound tag) {
        super.writeDescriptionNBT(tag);
        tag.func_74777_a("cableType", this.cableType);
        tag.func_74777_a("color", this.color);
        tag.func_74774_a("foamed", this.foamed);
        tag.func_74774_a("foamColor", this.foamColor);
    }

    @Override
    public void readDescriptionNBT(NBTTagCompound tag) {
        super.readDescriptionNBT(tag);
        this.cableType = tag.func_74765_d("cableType");
        this.color = tag.func_74765_d("color");
        this.foamed = tag.func_74771_c("foamed");
        this.foamColor = tag.func_74771_c("foamColor");
        this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
    }

    @Override
    public void onNetworkEvent(int event) {
        switch (event) {
            case 0: {
                this.field_145850_b.func_72908_a((double)((float)this.field_145851_c + 0.5f), (double)((float)this.field_145848_d + 0.5f), (double)((float)this.field_145849_e + 0.5f), "random.fizz", 0.5f, 2.6f + (this.field_145850_b.field_73012_v.nextFloat() - this.field_145850_b.field_73012_v.nextFloat()) * 0.8f);
                int l = 0;
                while (l < 8) {
                    this.field_145850_b.func_72869_a("largesmoke", (double)this.field_145851_c + Math.random(), (double)this.field_145848_d + 1.2, (double)this.field_145849_e + Math.random(), 0.0, 0.0, 0.0);
                    ++l;
                }
                break;
            }
            default: {
                IC2.platform.displayError("An unknown event type was received over multiplayer.\nThis could happen due to corrupted data or a bug.\n\n(Technical information: event ID " + event + ", tile entity below)\n" + "T: " + this + " (" + this.field_145851_c + "," + this.field_145848_d + "," + this.field_145849_e + ")");
            }
        }
    }

    @Override
    public float getWrenchDropRate() {
        return 0.0f;
    }

    private boolean changeFoam(byte foamed, boolean duringLoad) {
        if (this.foamed == foamed) {
            return false;
        }
        if (IC2.platform.isSimulating()) {
            this.foamed = foamed;
            if (foamed == 1) {
                this.foamColor = (byte)7;
                if (!duringLoad) {
                    this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
                }
                IC2.addContinuousTickCallback(this.field_145850_b, new ITickCallback(){

                    @Override
                    public void tickCallback(World world) {
                        if (TileEntityCable.this.func_145837_r() || TileEntityCable.this.foamed != 1 || ((TileEntityCable)TileEntityCable.this).field_145850_b.field_73012_v.nextInt(500) == 0 && TileEntityCable.this.field_145850_b.func_72957_l(TileEntityCable.this.field_145851_c, TileEntityCable.this.field_145848_d, TileEntityCable.this.field_145849_e) * 6 >= ((TileEntityCable)TileEntityCable.this).field_145850_b.field_73012_v.nextInt(1000)) {
                            TileEntityCable.this.changeFoam((byte)2);
                            IC2.removeContinuousTickCallback(world, this);
                        }
                    }
                });
            } else if (foamed == 2) {
                this.field_145850_b.func_72921_c(this.field_145851_c, this.field_145848_d, this.field_145849_e, 13, 3);
            }
            if (!duringLoad) {
                this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
            }
        }
        return true;
    }
}

