/*
 * Decompiled with CFR 0.152.
 */
package ic2classic.core.item;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import ic2.api.item.IElectricItem;
import ic2classic.api.electric_item.BatteryAPI;
import ic2classic.core.item.ItemIC2;
import ic2classic.core.util.StackUtil;
import java.util.List;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;

public abstract class ElectricItem
extends ItemIC2
implements IElectricItem {
    public int maxCharge;
    public int transferLimit = 100;
    public int tier = 1;

    public static int chargeDefaultImpl(ItemStack itemStack, int amount, int tier, boolean ignoreTransferLimit, boolean simulate) {
        if (!(itemStack.func_77973_b() instanceof IElectricItem) || amount < 0 || itemStack.field_77994_a > 1) {
            return 0;
        }
        IElectricItem item = (IElectricItem)itemStack.func_77973_b();
        if (item.getTier(itemStack) > tier) {
            return 0;
        }
        if ((double)amount > item.getTransferLimit(itemStack) && !ignoreTransferLimit) {
            amount = (int)item.getTransferLimit(itemStack);
        }
        NBTTagCompound nbtData = StackUtil.getOrCreateNbtData(itemStack);
        int charge = nbtData.func_74762_e("charge");
        if (amount > (int)(item.getMaxCharge(itemStack) - (double)charge)) {
            amount = (int)(item.getMaxCharge(itemStack) - (double)charge);
        }
        charge += amount;
        if (!simulate) {
            nbtData.func_74768_a("charge", charge);
            itemStack.func_150996_a(charge > 0 ? item.getChargedItem(itemStack) : item.getEmptyItem(itemStack));
            if (itemStack.func_77973_b() instanceof IElectricItem) {
                item = (IElectricItem)itemStack.func_77973_b();
                if (itemStack.func_77958_k() > 2) {
                    itemStack.func_77964_b(1 + (int)((item.getMaxCharge(itemStack) - (double)charge) * (double)(itemStack.func_77958_k() - 2) / item.getMaxCharge(itemStack)));
                } else {
                    itemStack.func_77964_b(0);
                }
            } else {
                itemStack.func_77964_b(0);
            }
        }
        return amount;
    }

    public static int dischargeDefaultImpl(ItemStack itemStack, int amount, int tier, boolean ignoreTransferLimit, boolean simulate) {
        NBTTagCompound nbtData;
        int charge;
        if (!(itemStack.func_77973_b() instanceof IElectricItem) || amount < 0 || itemStack.field_77994_a > 1) {
            return 0;
        }
        IElectricItem item = (IElectricItem)itemStack.func_77973_b();
        if (item.getTier(itemStack) > tier) {
            return 0;
        }
        if ((double)amount > item.getTransferLimit(itemStack) && !ignoreTransferLimit) {
            amount = (int)item.getTransferLimit(itemStack);
        }
        if (amount > (charge = (nbtData = StackUtil.getOrCreateNbtData(itemStack)).func_74762_e("charge"))) {
            amount = charge;
        }
        charge -= amount;
        if (!simulate) {
            nbtData.func_74768_a("charge", charge);
            itemStack.func_150996_a(charge > 0 ? item.getChargedItem(itemStack) : item.getEmptyItem(itemStack));
            if (itemStack.func_77973_b() instanceof IElectricItem) {
                item = (IElectricItem)itemStack.func_77973_b();
                if (itemStack.func_77958_k() > 2) {
                    itemStack.func_77964_b(1 + (int)((item.getMaxCharge(itemStack) - (double)charge) * (double)(itemStack.func_77958_k() - 2) / item.getMaxCharge(itemStack)));
                } else {
                    itemStack.func_77964_b(0);
                }
            } else {
                itemStack.func_77964_b(0);
            }
        }
        return amount;
    }

    public static void chargeFromArmorDefaultImpl(ItemStack itemStack, EntityPlayer player) {
        if (player == null) {
            return;
        }
        boolean inventoryChanged = false;
        int i = 0;
        while (i < 4) {
            IElectricItem armorItem;
            ItemStack armorItemStack = player.field_71071_by.field_70460_b[i];
            if (armorItemStack != null && armorItemStack.func_77973_b() instanceof IElectricItem && (armorItem = (IElectricItem)armorItemStack.func_77973_b()).canProvideEnergy(armorItemStack) && armorItem.getTier(armorItemStack) >= ((IElectricItem)itemStack.func_77973_b()).getTier(itemStack)) {
                int transfer = BatteryAPI.charge(itemStack, Integer.MAX_VALUE, Integer.MAX_VALUE, true, true);
                if ((transfer = BatteryAPI.discharge(armorItemStack, transfer, Integer.MAX_VALUE, true, false)) > 0) {
                    BatteryAPI.charge(itemStack, transfer, Integer.MAX_VALUE, true, false);
                    inventoryChanged = true;
                }
            }
            ++i;
        }
        if (inventoryChanged) {
            player.field_71070_bA.func_75142_b();
        }
    }

    public ElectricItem(int index) {
        super(index);
        this.func_77656_e(27);
        this.func_77625_d(1);
    }

    @Override
    public boolean canProvideEnergy(ItemStack stack) {
        return false;
    }

    @Override
    public Item getChargedItem(ItemStack stack) {
        return this;
    }

    @Override
    public Item getEmptyItem(ItemStack stack) {
        return this;
    }

    @Override
    public double getMaxCharge(ItemStack stack) {
        return this.maxCharge;
    }

    @Override
    public int getTier(ItemStack stack) {
        return this.tier;
    }

    @Override
    public double getTransferLimit(ItemStack stack) {
        return this.transferLimit;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_150895_a(Item par1, CreativeTabs par2CreativeTabs, List itemList) {
        if (this.getChargedItem(null) == this) {
            ItemStack charged = new ItemStack((Item)this, 1);
            BatteryAPI.charge(charged, Integer.MAX_VALUE, Integer.MAX_VALUE, true, false);
            itemList.add(charged);
        }
        if (this.getEmptyItem(null) == this) {
            itemList.add(new ItemStack((Item)this, 1, this.func_77612_l()));
        }
    }
}

