/*
 * Decompiled with CFR 0.152.
 */
package ic2classic.core.block.generator.block;

import cpw.mods.fml.common.registry.GameRegistry;
import ic2classic.core.IC2;
import ic2classic.core.Ic2Icons;
import ic2classic.core.Ic2Items;
import ic2classic.core.block.BlockMultiID;
import ic2classic.core.block.TileEntityBlock;
import ic2classic.core.block.generator.tileentity.TileEntityGenerator;
import ic2classic.core.block.generator.tileentity.TileEntityGeoGenerator;
import ic2classic.core.block.generator.tileentity.TileEntityNuclearReactor;
import ic2classic.core.block.generator.tileentity.TileEntityNuclearReactorElectric;
import ic2classic.core.block.generator.tileentity.TileEntitySolarGenerator;
import ic2classic.core.block.generator.tileentity.TileEntityWaterGenerator;
import ic2classic.core.block.generator.tileentity.TileEntityWindGenerator;
import ic2classic.core.item.block.ItemGenerator;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class BlockGenerator
extends BlockMultiID {
    public static Class<? extends TileEntityNuclearReactor> tileEntityNuclearReactorClass = TileEntityNuclearReactorElectric.class;

    public BlockGenerator() {
        super(Material.field_151573_f);
        this.func_149711_c(3.0f);
        this.func_149672_a(Block.field_149777_j);
        this.func_149647_a(IC2.tabIC2);
        GameRegistry.registerBlock((Block)this, ItemGenerator.class, (String)"blockGenerator");
        Ic2Items.generator = new ItemStack((Block)this, 1, 0);
        Ic2Items.geothermalGenerator = new ItemStack((Block)this, 1, 1);
        Ic2Items.waterMill = new ItemStack((Block)this, 1, 2);
        Ic2Items.solarPanel = new ItemStack((Block)this, 1, 3);
        Ic2Items.windMill = new ItemStack((Block)this, 1, 4);
        Ic2Items.nuclearReactor = new ItemStack((Block)this, 1, 5);
        this.setHarvestLevel("pickaxe", 2);
    }

    @Override
    protected IIcon[] getIconSheet() {
        return Ic2Icons.bgen;
    }

    public int func_149692_a(int meta) {
        switch (meta) {
            case 2: {
                return 2;
            }
        }
        return 0;
    }

    public int func_149745_a(Random random) {
        return 1;
    }

    public TileEntityBlock createNewTileEntity(World world, int meta) {
        try {
            switch (meta) {
                case 0: {
                    return new TileEntityGenerator();
                }
                case 1: {
                    return new TileEntityGeoGenerator();
                }
                case 2: {
                    return new TileEntityWaterGenerator();
                }
                case 3: {
                    return new TileEntitySolarGenerator();
                }
                case 4: {
                    return new TileEntityWindGenerator();
                }
                case 5: {
                    return tileEntityNuclearReactorClass.newInstance();
                }
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return null;
    }

    public void func_149734_b(World world, int i, int j, int k, Random random) {
        if (!IC2.platform.isRendering()) {
            return;
        }
        int meta = world.func_72805_g(i, j, k);
        if (meta == 0 && BlockGenerator.isActive((IBlockAccess)world, i, j, k)) {
            TileEntityBlock te = (TileEntityBlock)world.func_147438_o(i, j, k);
            short l = te.getFacing();
            float f = (float)i + 0.5f;
            float f1 = (float)j + 0.0f + random.nextFloat() * 6.0f / 16.0f;
            float f2 = (float)k + 0.5f;
            float f3 = 0.52f;
            float f4 = random.nextFloat() * 0.6f - 0.3f;
            switch (l) {
                case 4: {
                    world.func_72869_a("smoke", (double)(f - f3), (double)f1, (double)(f2 + f4), 0.0, 0.0, 0.0);
                    world.func_72869_a("flame", (double)(f - f3), (double)f1, (double)(f2 + f4), 0.0, 0.0, 0.0);
                    break;
                }
                case 5: {
                    world.func_72869_a("smoke", (double)(f + f3), (double)f1, (double)(f2 + f4), 0.0, 0.0, 0.0);
                    world.func_72869_a("flame", (double)(f + f3), (double)f1, (double)(f2 + f4), 0.0, 0.0, 0.0);
                    break;
                }
                case 2: {
                    world.func_72869_a("smoke", (double)(f + f4), (double)f1, (double)(f2 - f3), 0.0, 0.0, 0.0);
                    world.func_72869_a("flame", (double)(f + f4), (double)f1, (double)(f2 - f3), 0.0, 0.0, 0.0);
                    break;
                }
                case 3: {
                    world.func_72869_a("smoke", (double)(f + f4), (double)f1, (double)(f2 + f3), 0.0, 0.0, 0.0);
                    world.func_72869_a("flame", (double)(f + f4), (double)f1, (double)(f2 + f3), 0.0, 0.0, 0.0);
                }
            }
        } else if (meta == 5) {
            int puffs = ((TileEntityNuclearReactor)world.func_147438_o((int)i, (int)j, (int)k)).heat / 1000;
            if (puffs <= 0) {
                return;
            }
            puffs = world.field_73012_v.nextInt(puffs);
            int n = 0;
            while (n < puffs) {
                world.func_72869_a("smoke", (double)((float)i + random.nextFloat()), (double)((float)j + 0.95f), (double)((float)k + random.nextFloat()), 0.0, 0.0, 0.0);
                ++n;
            }
            puffs -= world.field_73012_v.nextInt(4) + 3;
            n = 0;
            while (n < puffs) {
                world.func_72869_a("flame", (double)((float)i + random.nextFloat()), (double)((float)j + 1.0f), (double)((float)k + random.nextFloat()), 0.0, 0.0, 0.0);
                ++n;
            }
        }
    }

    @Override
    public boolean func_149727_a(World world, int i, int j, int k, EntityPlayer entityplayer, int side, float a, float b, float c) {
        if (entityplayer.func_71045_bC() != null && entityplayer.func_71045_bC().func_77969_a(Ic2Items.reactorChamber)) {
            return false;
        }
        return super.func_149727_a(world, i, j, k, entityplayer, side, a, b, c);
    }
}

