/*
 * Decompiled with CFR 0.152.
 */
package ic2classic.core.item.tool;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import ic2classic.api.electric_item.BatteryAPI;
import ic2classic.core.IC2;
import ic2classic.core.Ic2Icons;
import ic2classic.core.Ic2Items;
import ic2classic.core.item.armor.ItemArmorNanoSuit;
import ic2classic.core.item.armor.ItemArmorQuantumSuit;
import ic2classic.core.item.tool.ItemElectricTool;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.IIcon;
import net.minecraft.world.World;

public class ItemNanoSaber
extends ItemElectricTool {
    public boolean active;
    public int soundTicker = 0;
    public static int ticker = 0;
    public static Random shinyrand = new Random();

    public ItemNanoSaber(int sprite, boolean a) {
        super(sprite, Item.ToolMaterial.IRON, 10);
        this.maxCharge = 40000;
        this.transferLimit = 128;
        this.tier = 2;
        this.active = a;
        this.setHarvestLevel("sword", 3);
    }

    @Override
    public float getDigSpeed(ItemStack itemstack, Block block, int meta) {
        if (this.active) {
            ++this.soundTicker;
            return 4.0f;
        }
        return 1.0f;
    }

    @Override
    public boolean func_77644_a(ItemStack itemstack, EntityLivingBase entityliving, EntityLivingBase entityliving1) {
        if (!this.active) {
            return true;
        }
        if (!(!IC2.platform.isSimulating() || entityliving1 instanceof EntityPlayer && MinecraftServer.func_71276_C().func_71219_W())) {
            EntityPlayer player = null;
            if (entityliving1 instanceof EntityPlayer) {
                player = (EntityPlayer)entityliving1;
            }
            if (entityliving instanceof EntityPlayer) {
                EntityPlayer enemy = (EntityPlayer)entityliving;
                int i = 0;
                while (i < 4) {
                    if (enemy.field_71071_by.field_70460_b[i] != null && enemy.field_71071_by.field_70460_b[i].func_77973_b() instanceof ItemArmorNanoSuit) {
                        int amount = enemy.field_71071_by.field_70460_b[i].func_77973_b() instanceof ItemArmorQuantumSuit ? 30000 : 4800;
                        BatteryAPI.discharge(enemy.field_71071_by.field_70460_b[i], amount, this.tier, true, false);
                        if (!BatteryAPI.canUse(enemy.field_71071_by.field_70460_b[i], 1)) {
                            enemy.field_71071_by.field_70460_b[i] = null;
                        }
                        ItemNanoSaber.drainSaber(itemstack, 2, player);
                    }
                    ++i;
                }
            }
            ItemNanoSaber.drainSaber(itemstack, 5, player);
        }
        entityliving1.field_70170_p.func_72956_a((Entity)entityliving1, "ic2classic:nanosabreSwing", 1.0f, 1.0f);
        return true;
    }

    public boolean onBlockStartBreak(ItemStack itemstack, int i, int j, int k, EntityPlayer player) {
        if (this.active) {
            ItemNanoSaber.drainSaber(itemstack, 10, player);
        }
        return false;
    }

    @Override
    public int getDamageVsEntity() {
        if (this.active) {
            return 20;
        }
        return 4;
    }

    public boolean func_77662_d() {
        return true;
    }

    public boolean canHarvestBlock(Block block, ItemStack item) {
        return block == Blocks.field_150321_G;
    }

    public static void drainSaber(ItemStack saber, int damage, EntityPlayer player) {
        if (!BatteryAPI.use(saber, damage * 8, (EntityLivingBase)player)) {
            saber.func_150996_a(Ic2Items.nanoSaber);
        }
    }

    public ItemStack func_77659_a(ItemStack itemstack, World world, EntityPlayer entityplayer) {
        if (!IC2.platform.isSimulating()) {
            return itemstack;
        }
        if (this.active) {
            itemstack.func_150996_a(Ic2Items.nanoSaber);
        } else if (BatteryAPI.canUse(itemstack, 16)) {
            itemstack.func_150996_a(Ic2Items.enabledNanoSaber);
            world.func_72956_a((Entity)entityplayer, "ic2classic:nanosabrePower", 1.0f, 1.0f);
        }
        return itemstack;
    }

    public static void timedLoss(EntityPlayer player) {
        if (++ticker % 16 == 0) {
            int i;
            ItemStack[] inv = player.field_71071_by.field_70462_a;
            if (ticker % 64 == 0) {
                i = 9;
                while (i < inv.length) {
                    if (inv[i] != null && inv[i].func_77973_b() == Ic2Items.enabledNanoSaber) {
                        ItemNanoSaber.drainSaber(inv[i], 64, player);
                    }
                    ++i;
                }
            }
            i = 0;
            while (i < 9) {
                if (inv[i] != null && inv[i].func_77973_b() == Ic2Items.enabledNanoSaber) {
                    ItemNanoSaber.drainSaber(inv[i], 16, player);
                }
                ++i;
            }
        }
    }

    @Override
    public IIcon func_77617_a(int i) {
        if (this.active && shinyrand.nextBoolean()) {
            return Ic2Icons.i0[this.iconIndex + 1];
        }
        return Ic2Icons.i0[this.iconIndex];
    }

    @SideOnly(value=Side.CLIENT)
    public EnumRarity func_77613_e(ItemStack stack) {
        return EnumRarity.uncommon;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void func_150895_a(Item i, CreativeTabs tabs, List itemList) {
        if (!this.active) {
            super.func_150895_a(i, tabs, itemList);
        }
    }
}

