/*
 * Decompiled with CFR 0.152.
 */
package ic2classic.core.item.tool;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import ic2classic.api.electric_item.BatteryAPI;
import ic2classic.api.network.INetworkItemEventListener;
import ic2classic.core.IC2;
import ic2classic.core.audio.PositionSpec;
import ic2classic.core.item.tool.EntityMiningLaser;
import ic2classic.core.item.tool.ItemElectricTool;
import ic2classic.core.util.StackUtil;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;

public class ItemToolMiningLaser
extends ItemElectricTool
implements INetworkItemEventListener {
    public ItemToolMiningLaser(int sprite) {
        super(sprite, Item.ToolMaterial.IRON, 100);
        this.maxCharge = 200000;
        this.transferLimit = 120;
        this.tier = 2;
    }

    public ItemStack func_77659_a(ItemStack itemstack, World world, EntityPlayer entityplayer) {
        if (!IC2.platform.isSimulating()) {
            return itemstack;
        }
        NBTTagCompound nbtData = StackUtil.getOrCreateNbtData(itemstack);
        int laserSetting = nbtData.func_74762_e("laserSetting");
        if (IC2.keyboard.isModeSwitchKeyDown(entityplayer)) {
            laserSetting = (laserSetting + 1) % 7;
            nbtData.func_74768_a("laserSetting", laserSetting);
            String laser = (new String[]{"Mining", "Low-Focus", "Long-Range", "Horizontal", "Super-Heat", "Scatter", "Explosive"})[laserSetting];
            IC2.platform.messagePlayer(entityplayer, "Laser Mode: " + laser);
        } else {
            int[] nArray = new int[7];
            nArray[0] = 1250;
            nArray[1] = 100;
            nArray[2] = 5000;
            nArray[4] = 2500;
            nArray[5] = 10000;
            nArray[6] = 5000;
            int consume = nArray[laserSetting];
            if (!BatteryAPI.use(itemstack, consume, (EntityLivingBase)entityplayer)) {
                return itemstack;
            }
            float range = laserSetting == 2 ? 20 : (laserSetting == 1 ? 6 : 8);
            switch (laserSetting) {
                case 0: {
                    world.func_72838_d((Entity)new EntityMiningLaser(world, (EntityLivingBase)entityplayer, range, 5.0f, Integer.MAX_VALUE, false));
                    IC2.network.initiateItemEvent(entityplayer, itemstack, 0, true);
                    break;
                }
                case 1: {
                    world.func_72838_d((Entity)new EntityMiningLaser(world, (EntityLivingBase)entityplayer, range, 5.0f, 1, false));
                    IC2.network.initiateItemEvent(entityplayer, itemstack, 1, true);
                    break;
                }
                case 2: {
                    world.func_72838_d((Entity)new EntityMiningLaser(world, (EntityLivingBase)entityplayer, range, 20.0f, Integer.MAX_VALUE, false));
                    IC2.network.initiateItemEvent(entityplayer, itemstack, 2, true);
                    break;
                }
                case 3: {
                    break;
                }
                case 4: {
                    world.func_72838_d((Entity)new EntityMiningLaser(world, (EntityLivingBase)entityplayer, range, 8.0f, Integer.MAX_VALUE, false, true));
                    IC2.network.initiateItemEvent(entityplayer, itemstack, 4, true);
                    break;
                }
                case 5: {
                    int x = -2;
                    while (x <= 2) {
                        int y = -2;
                        while (y <= 2) {
                            world.func_72838_d((Entity)new EntityMiningLaser(world, (EntityLivingBase)entityplayer, range, 12.0f, Integer.MAX_VALUE, false, entityplayer.field_70177_z + 20.0f * (float)x, entityplayer.field_70125_A + 20.0f * (float)y));
                            ++y;
                        }
                        ++x;
                    }
                    IC2.network.initiateItemEvent(entityplayer, itemstack, 5, true);
                    break;
                }
                case 6: {
                    world.func_72838_d((Entity)new EntityMiningLaser(world, (EntityLivingBase)entityplayer, range, 12.0f, Integer.MAX_VALUE, true));
                    IC2.network.initiateItemEvent(entityplayer, itemstack, 6, true);
                }
            }
        }
        return itemstack;
    }

    public boolean onItemUseFirst(ItemStack itemstack, EntityPlayer entityPlayer, World world, int x, int y, int z, int side, float hitX, float hitY, float hitZ) {
        if (!IC2.platform.isSimulating()) {
            return false;
        }
        NBTTagCompound nbtData = StackUtil.getOrCreateNbtData(itemstack);
        if (!IC2.keyboard.isModeSwitchKeyDown(entityPlayer) && nbtData.func_74762_e("laserSetting") == 3) {
            if (Math.abs(entityPlayer.field_70163_u + (double)entityPlayer.func_70047_e() - 0.1 - ((double)y + 0.5)) < 1.5) {
                if (BatteryAPI.use(itemstack, 3000, (EntityLivingBase)entityPlayer)) {
                    world.func_72838_d((Entity)new EntityMiningLaser(world, (EntityLivingBase)entityPlayer, 8.0f, 5.0f, Integer.MAX_VALUE, false, entityPlayer.field_70177_z, 0.0, (double)y + 0.5));
                    IC2.network.initiateItemEvent(entityPlayer, itemstack, 3, true);
                }
            } else {
                IC2.platform.messagePlayer(entityPlayer, "Mining laser aiming angle too steep");
            }
        }
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public EnumRarity func_77613_e(ItemStack stack) {
        return EnumRarity.uncommon;
    }

    @Override
    public void onNetworkEvent(int metaData, EntityPlayer player, int event) {
        switch (event) {
            case 0: {
                IC2.audioManager.playOnce(player, PositionSpec.Hand, "Tools/MiningLaser/MiningLaser.ogg", true, IC2.audioManager.defaultVolume);
                break;
            }
            case 1: {
                IC2.audioManager.playOnce(player, PositionSpec.Hand, "Tools/MiningLaser/MiningLaserLowFocus.ogg", true, IC2.audioManager.defaultVolume);
                break;
            }
            case 2: {
                IC2.audioManager.playOnce(player, PositionSpec.Hand, "Tools/MiningLaser/MiningLaserLongRange.ogg", true, IC2.audioManager.defaultVolume);
                break;
            }
            case 3: {
                IC2.audioManager.playOnce(player, PositionSpec.Hand, "Tools/MiningLaser/MiningLaser.ogg", true, IC2.audioManager.defaultVolume);
                break;
            }
            case 4: {
                IC2.audioManager.playOnce(player, PositionSpec.Hand, "Tools/MiningLaser/MiningLaser.ogg", true, IC2.audioManager.defaultVolume);
                break;
            }
            case 5: {
                IC2.audioManager.playOnce(player, PositionSpec.Hand, "Tools/MiningLaser/MiningLaserScatter.ogg", true, IC2.audioManager.defaultVolume);
                break;
            }
            case 6: {
                IC2.audioManager.playOnce(player, PositionSpec.Hand, "Tools/MiningLaser/MiningLaserExplosive.ogg", true, IC2.audioManager.defaultVolume);
            }
        }
    }
}

