/*
 * Decompiled with CFR 0.152.
 */
package ic2classic.api_compat;

import cpw.mods.fml.common.registry.GameRegistry;
import ic2.api.recipe.ICraftingRecipeManager;
import ic2classic.api_compat.FakeModIC2;
import ic2classic.core.Ic2Items;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraftforge.oredict.OreDictionary;
import net.minecraftforge.oredict.ShapedOreRecipe;
import net.minecraftforge.oredict.ShapelessOreRecipe;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class CraftingRecipeManager
implements ICraftingRecipeManager {
    private static Logger logger = LogManager.getLogger((String)"IC2ClassicAPICompat");

    @Override
    public void addRecipe(ItemStack output, Object ... input) {
        if (!this.substitute(input, true)) {
            logger.warn("Recipe for " + output + " might not be craftable due to missing items");
        }
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(output, input));
    }

    @Override
    public void addShapelessRecipe(ItemStack output, Object ... input) {
        if (!this.substitute(input, false)) {
            logger.warn("Recipe for " + output + " might not be craftable due to missing items");
        }
        GameRegistry.addRecipe((IRecipe)new ShapelessOreRecipe(output, input));
    }

    private boolean substitute(Object[] input, boolean shaped) {
        boolean warn = false;
        boolean seenChar = false;
        int k = 0;
        while (k < input.length) {
            block7: {
                block6: {
                    block5: {
                        if (!(input[k] instanceof Character)) break block5;
                        seenChar = true;
                        break block6;
                    }
                    if (!seenChar && shaped) break block7;
                }
                input[k] = this.substitute(input[k]);
                if (input[k] instanceof ItemStack && ((ItemStack)input[k]).func_77973_b() == Item.func_150898_a((Block)FakeModIC2.newMachine)) {
                    warn = true;
                }
            }
            ++k;
        }
        return !warn;
    }

    private ItemStack getPlaceholderInput() {
        return new ItemStack(FakeModIC2.newMachine);
    }

    private Object substitute(Object input) {
        if (input instanceof String) {
            String oreDictName = (String)input;
            if (oreDictName.equals("plateLead")) {
                input = Ic2Items.refinedIronIngot;
            } else if (oreDictName.startsWith("plate")) {
                oreDictName = "ingot" + oreDictName.substring(5);
                input = oreDictName;
            } else if (oreDictName.equals("circuitBasic")) {
                input = Ic2Items.electronicCircuit;
            } else if (oreDictName.equals("circuitAdvanced")) {
                input = Ic2Items.advancedCircuit;
            }
        }
        if (input instanceof String && OreDictionary.getOres((String)((String)input)).size() == 0) {
            logger.warn("Ore dictionary key " + input + " used in IC2 recipe, but there are no items with this key. Substituting placeholder item. This recipe will be uncraftable.");
            input = this.getPlaceholderInput();
        }
        return input;
    }
}

