/*
 * Decompiled with CFR 0.152.
 */
package ic2classic.api_compat;

import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.event.FMLServerAboutToStartEvent;
import cpw.mods.fml.common.eventhandler.Event;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.TickEvent;
import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.relauncher.FMLLaunchHandler;
import ic2.api.energy.EnergyNet;
import ic2.api.energy.event.EnergyTileLoadEvent;
import ic2.api.energy.event.EnergyTileUnloadEvent;
import ic2.api.recipe.Recipes;
import ic2.core.util.SideGateway;
import ic2classic.api.IC2ClassicRecipes;
import ic2classic.api.energy.event.EnergyTileSourceEvent;
import ic2classic.api.energy.tile.IEnergySource;
import ic2classic.api.energy.tile.IEnergyTile;
import ic2classic.api_compat.CannerBottleRecipeManager;
import ic2classic.api_compat.CannerEnrichRecipeManager;
import ic2classic.api_compat.CraftingRecipeManager;
import ic2classic.api_compat.EnergyNetAPIImpl;
import ic2classic.api_compat.FluidHeatRecipeManager;
import ic2classic.api_compat.SemiFluidGeneratorRecipeManager;
import ic2classic.api_compat.network.CompatNetworking;
import ic2classic.core.IC2;
import ic2classic.core.Ic2Items;
import ic2classic.core.recipes.ListRecipeManager;
import ic2classic.core.recipes.MachineRecipeManager;
import java.util.Collection;
import java.util.concurrent.CopyOnWriteArrayList;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.Item;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.oredict.OreDictionary;

@Mod(modid="IC2", version="9999.9999.9999.9999", name="IC2 Classic pretends to be IC2 Experimental", dependencies="required-after:IC2-Classic")
public class FakeModIC2 {
    public static SideGateway network = new SideGateway(){

        @Override
        public Object get() {
            return IC2.network;
        }
    };
    public static Block newMachine = new Block(Material.field_151573_f){}.func_149663_c("ic2classic_api_compat.new_machine").func_149658_d("ic2classic_api_compat:no_texture").func_149647_a(CreativeTabs.field_78027_g);
    static Collection<ic2.api.energy.tile.IEnergySource> sourcesRequiringInterfaceTranslation = new CopyOnWriteArrayList<ic2.api.energy.tile.IEnergySource>();

    @Mod.EventHandler
    public void preinit(FMLPreInitializationEvent evt) {
        GameRegistry.registerBlock((Block)newMachine, (String)"newMachine");
        Recipes.macerator = IC2ClassicRecipes.macerator;
        Recipes.compressor = IC2ClassicRecipes.compressor;
        Recipes.extractor = IC2ClassicRecipes.extractor;
        Recipes.scrapboxDrops = IC2ClassicRecipes.scrapboxDrops;
        Recipes.recyclerBlacklist = IC2ClassicRecipes.recyclerBlacklist;
        Recipes.cannerBottle = new CannerBottleRecipeManager();
        Recipes.advRecipes = new CraftingRecipeManager();
        Recipes.blastfurance = new MachineRecipeManager(0, Integer.MAX_VALUE);
        Recipes.blockcutter = new MachineRecipeManager(0, Integer.MAX_VALUE);
        Recipes.cannerEnrich = new CannerEnrichRecipeManager();
        Recipes.centrifuge = new MachineRecipeManager(0, Integer.MAX_VALUE);
        Recipes.FluidHeatGenerator = new FluidHeatRecipeManager();
        Recipes.matterAmplifier = new MachineRecipeManager(0, Integer.MAX_VALUE);
        Recipes.metalformerCutting = new MachineRecipeManager(0, Integer.MAX_VALUE);
        Recipes.metalformerExtruding = new MachineRecipeManager(0, Integer.MAX_VALUE);
        Recipes.metalformerRolling = new MachineRecipeManager(0, Integer.MAX_VALUE);
        Recipes.oreWashing = new MachineRecipeManager(0, Integer.MAX_VALUE);
        Recipes.recycler = new MachineRecipeManager(0, Integer.MAX_VALUE);
        Recipes.recyclerWhitelist = new ListRecipeManager();
        Recipes.semiFluidGenerator = new SemiFluidGeneratorRecipeManager();
        EnergyNet.instance = new EnergyNetAPIImpl();
        OreDictionary.registerOre((String)"circuitBasic", (Item)Ic2Items.electronicCircuit);
        OreDictionary.registerOre((String)"circuitAdvanced", (Item)Ic2Items.advancedCircuit);
        MinecraftForge.EVENT_BUS.register((Object)this);
        FMLCommonHandler.instance().bus().register((Object)this);
    }

    @Mod.EventHandler
    public void initNetwork(FMLPreInitializationEvent evt) {
        CompatNetworking.init();
        if (FMLLaunchHandler.side().isClient()) {
            this.initClientNetwork();
        }
    }

    private void initClientNetwork() {
        CompatNetworking.initClient();
    }

    @Mod.EventHandler
    public void onPreServerStart(FMLServerAboutToStartEvent evt) {
        sourcesRequiringInterfaceTranslation.clear();
    }

    @SubscribeEvent
    public void adaptEnergyTileEvent(EnergyTileLoadEvent evt) {
        if (evt.energyTile instanceof IEnergyTile) {
            MinecraftForge.EVENT_BUS.post((Event)new ic2classic.api.energy.event.EnergyTileLoadEvent((IEnergyTile)evt.energyTile));
            if (evt.energyTile instanceof ic2.api.energy.tile.IEnergySource) {
                sourcesRequiringInterfaceTranslation.add((ic2.api.energy.tile.IEnergySource)evt.energyTile);
            }
        }
    }

    @SubscribeEvent
    public void adaptEnergyTileEvent(EnergyTileUnloadEvent evt) {
        if (evt.energyTile instanceof IEnergyTile) {
            MinecraftForge.EVENT_BUS.post((Event)new ic2classic.api.energy.event.EnergyTileUnloadEvent((IEnergyTile)evt.energyTile));
            sourcesRequiringInterfaceTranslation.remove(evt.energyTile);
        }
    }

    @SubscribeEvent
    public void onTick(TickEvent.ServerTickEvent evt) {
        if (evt.phase != TickEvent.Phase.END) {
            return;
        }
        for (ic2.api.energy.tile.IEnergySource source : sourcesRequiringInterfaceTranslation) {
            IEnergySource asClassicSource = (IEnergySource)source;
            int avail = (int)source.getOfferedEnergy();
            if (avail <= 0) continue;
            EnergyTileSourceEvent event = new EnergyTileSourceEvent(asClassicSource, avail);
            MinecraftForge.EVENT_BUS.post((Event)event);
            source.drawEnergy(avail - event.amount);
        }
    }
}

