/*
 * Decompiled with CFR 0.152.
 */
package ic2classic.api_compat.network;

import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.common.network.simpleimpl.IMessageHandler;
import cpw.mods.fml.common.network.simpleimpl.MessageContext;
import cpw.mods.fml.common.network.simpleimpl.SimpleNetworkWrapper;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import ic2.api.network.INetworkDataProvider;
import ic2classic.api_compat.network.MessageClientTileEntityEvent;
import ic2classic.api_compat.network.MessageUpdateTEField;
import ic2classic.api_compat.network.NetworkManagerExtraMethods;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.WorldServer;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.world.ChunkWatchEvent;

public class CompatNetworking {
    public static final byte UPDATE_TE_FIELD_MESSAGE = 0;
    public static final byte CLIENT_TILE_EVENT_MESSAGE = 1;
    public static SimpleNetworkWrapper SNW;

    @SideOnly(value=Side.CLIENT)
    public static void initClient() {
        SNW.registerMessage((IMessageHandler)new IMessageHandler<MessageUpdateTEField, IMessage>(){

            public IMessage onMessage(MessageUpdateTEField message, MessageContext ctx) {
                if (Minecraft.func_71410_x().field_71441_e.field_73011_w.field_76574_g != message.dimension) {
                    return null;
                }
                TileEntity te = Minecraft.func_71410_x().field_71441_e.func_147438_o(message.x, message.y, message.z);
                if (te == null) {
                    return null;
                }
                message.applyTo(te);
                return null;
            }
        }, MessageUpdateTEField.class, 0, Side.CLIENT);
    }

    public static void init() {
        SNW = new SimpleNetworkWrapper("IC2ClassicCompat");
        SNW.registerMessage((IMessageHandler)new IMessageHandler<MessageUpdateTEField, IMessage>(){

            public IMessage onMessage(MessageUpdateTEField message, MessageContext ctx) {
                WorldServer w = DimensionManager.getWorld((int)message.dimension);
                if (w == null) {
                    return null;
                }
                if (!w.func_72899_e(message.x, message.y, message.z)) {
                    return null;
                }
                TileEntity te = w.func_147438_o(message.x, message.y, message.z);
                if (te == null) {
                    return null;
                }
                message.applyTo(te);
                return null;
            }
        }, MessageUpdateTEField.class, 0, Side.SERVER);
        SNW.registerMessage((IMessageHandler)new IMessageHandler<MessageClientTileEntityEvent, IMessage>(){

            public IMessage onMessage(MessageClientTileEntityEvent message, MessageContext ctx) {
                EntityPlayerMP ply = ctx.getServerHandler().field_147369_b;
                if (ply.field_70170_p.field_73011_w.field_76574_g != message.dim) {
                    return null;
                }
                double dx = ply.field_70165_t - (double)message.x;
                double dy = ply.field_70163_u - (double)message.y;
                double dz = ply.field_70161_v - (double)message.z;
                if (dx * dx + dy * dy + dz * dz > 256.0) {
                    return null;
                }
                if (!ply.field_70170_p.func_72899_e(message.x, message.y, message.z)) {
                    return null;
                }
                TileEntity te = ply.field_70170_p.func_147438_o(message.x, message.y, message.z);
                if (te == null) {
                    return null;
                }
                message.applyTo((EntityPlayer)ply, te);
                return null;
            }
        }, MessageClientTileEntityEvent.class, 1, Side.SERVER);
        MinecraftForge.EVENT_BUS.register((Object)new EventListener());
    }

    public static class EventListener {
        @SubscribeEvent
        public void onChunkSend(ChunkWatchEvent.Watch evt) {
            Chunk chunk = evt.player.field_70170_p.func_72964_e(evt.chunk.field_77276_a, evt.chunk.field_77275_b);
            for (TileEntity te : chunk.field_150816_i.values()) {
                if (!(te instanceof INetworkDataProvider)) continue;
                for (String fieldName : ((INetworkDataProvider)te).getNetworkedFields()) {
                    NetworkManagerExtraMethods.updateTileEntityField(null, te, fieldName);
                }
            }
        }
    }
}

