/*
 * Decompiled with CFR 0.152.
 */
package ic2classic.api_compat;

import ic2.api.energy.tile.IEnergyConductor;
import ic2.api.energy.tile.IEnergySink;
import ic2classic.api.IEnergyStorage;
import ic2classic.api.energy.tile.IEnergySource;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.Label;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Opcodes;

public class EnergyInterfaceClassAdapter
extends ClassVisitor {
    public static final String EXCESS_ENERGY_FIELD_NAME = "IC2_Classic_API_Compat_excessEnergy";
    boolean needsSourceAdapters;
    boolean needsSinkAdapters;
    boolean needsStorageAdapters;
    boolean needsConductorAdapters;
    String className;
    Class<?> superClass;
    Class<?>[] interfaceClasses;

    static {
        EnergyInterfaceClassAdapter.loadClass(ic2.api.energy.tile.IEnergySource.class);
        EnergyInterfaceClassAdapter.loadClass(IEnergySource.class);
        EnergyInterfaceClassAdapter.loadClass(IEnergySink.class);
        EnergyInterfaceClassAdapter.loadClass(ic2classic.api.energy.tile.IEnergySink.class);
        EnergyInterfaceClassAdapter.loadClass(IEnergyConductor.class);
        EnergyInterfaceClassAdapter.loadClass(ic2classic.api.energy.tile.IEnergyConductor.class);
        EnergyInterfaceClassAdapter.loadClass(ic2.api.tile.IEnergyStorage.class);
        EnergyInterfaceClassAdapter.loadClass(IEnergyStorage.class);
    }

    public EnergyInterfaceClassAdapter(ClassVisitor parent) {
        super(327680, parent);
    }

    private static void loadClass(Class<?> c) {
    }

    private boolean checkIfAdapterNeeded(Class<?> existingInterface, Class<?> newInterface, List<String> intfList) {
        if (existingInterface.isAssignableFrom(this.superClass)) {
            return false;
        }
        String newIntfName = newInterface.getName().replace('.', '/');
        if (intfList.contains(newIntfName)) {
            return false;
        }
        if (intfList.contains(existingInterface.getName().replace('.', '/'))) {
            intfList.add(newIntfName);
            return true;
        }
        Class<?>[] classArray = this.interfaceClasses;
        int n = this.interfaceClasses.length;
        int n2 = 0;
        while (n2 < n) {
            Class<?> direct_interface = classArray[n2];
            if (existingInterface.isAssignableFrom(direct_interface)) {
                intfList.add(newIntfName);
                return true;
            }
            ++n2;
        }
        return false;
    }

    public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
        this.className = name;
        boolean isInterface = (access & 0x200) != 0;
        this.interfaceClasses = new Class[interfaces == null ? 0 : interfaces.length];
        try {
            this.superClass = Class.forName(superName.replace('/', '.'));
            if (interfaces != null) {
                int k = 0;
                while (k < interfaces.length) {
                    this.interfaceClasses[k] = Class.forName(interfaces[k].replace('/', '.'));
                    ++k;
                }
            }
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException("Failed to load parents of " + name, e);
        }
        ArrayList<String> intfList = new ArrayList<String>(interfaces == null ? Collections.emptyList() : Arrays.asList(interfaces));
        if (!isInterface) {
            this.needsSourceAdapters = this.checkIfAdapterNeeded(ic2.api.energy.tile.IEnergySource.class, IEnergySource.class, intfList);
            this.needsSinkAdapters = this.checkIfAdapterNeeded(IEnergySink.class, ic2classic.api.energy.tile.IEnergySink.class, intfList);
            this.needsConductorAdapters = this.checkIfAdapterNeeded(IEnergyConductor.class, ic2classic.api.energy.tile.IEnergyConductor.class, intfList);
            this.needsStorageAdapters = this.checkIfAdapterNeeded(IEnergyStorage.class, ic2.api.tile.IEnergyStorage.class, intfList);
        }
        super.visit(version, access, name, signature, superName, intfList.toArray(new String[intfList.size()]));
    }

    public void visitEnd() {
        if (this.needsSourceAdapters) {
            this.generateSourceAdapters();
        }
        if (this.needsSinkAdapters) {
            this.generateSinkAdapters();
        }
        if (this.needsConductorAdapters) {
            this.generateConductorAdapters();
        }
        if (this.needsSourceAdapters || this.needsConductorAdapters) {
            this.generateEmitterAdapters();
        }
        if (this.needsSinkAdapters || this.needsConductorAdapters) {
            this.generateAcceptorAdapters();
        }
        if (this.needsStorageAdapters) {
            this.generateStorageAdapters();
        }
        super.visitEnd();
    }

    public void generateConductorAdapters() {
        this.generateIntGetterAdapter("getInsulationEnergyAbsorption");
        this.generateIntGetterAdapter("getInsulationBreakdownEnergy");
        this.generateIntGetterAdapter("getConductorBreakdownEnergy");
        this.generateNoArgumentForwarder("removeInsulation", "()V", 177);
        this.generateNoArgumentForwarder("removeConductor", "()V", 177);
        this.generateNoArgumentForwarder("getConductionLoss", "()D", 175);
    }

    private void generateNoArgumentForwarder(String name, String desc, int returnop) {
        MethodVisitor mv = super.visitMethod(1, "IC2Classic_" + name, desc, null, null);
        mv.visitCode();
        mv.visitVarInsn(25, 0);
        mv.visitMethodInsn(182, this.className, name, desc, false);
        mv.visitInsn(returnop);
        mv.visitMaxs(2, 1);
        mv.visitEnd();
    }

    public void generateIntGetterAdapter(String methodName) {
        MethodVisitor mv = super.visitMethod(1, "IC2Classic_" + methodName, "()I", null, null);
        mv.visitCode();
        mv.visitVarInsn(25, 0);
        mv.visitMethodInsn(182, this.className, methodName, "()D", false);
        mv.visitMethodInsn(184, "java/lang/Math", "ceil", "(D)D", false);
        mv.visitInsn(142);
        mv.visitInsn(172);
        mv.visitMaxs(2, 1);
        mv.visitEnd();
    }

    public void generateStorageAdapters() {
        MethodVisitor mv = super.visitMethod(1, "getOutputEnergyUnitsPerTick", "()D", null, null);
        mv.visitCode();
        mv.visitVarInsn(25, 0);
        mv.visitMethodInsn(182, this.className, "IC2ClassicStorage_getOutput", "()I", false);
        mv.visitInsn(135);
        mv.visitInsn(175);
        mv.visitMaxs(2, 1);
        mv.visitEnd();
    }

    public void generateEmitterAdapters() {
        MethodVisitor mv = this.visitMethod(1, "IC2Classic_emitsEnergyTo", "(Lnet/minecraft/tileentity/TileEntity;Lic2classic/api/Direction;)Z", null, null);
        mv.visitCode();
        mv.visitVarInsn(25, 0);
        mv.visitVarInsn(25, 1);
        mv.visitVarInsn(25, 2);
        mv.visitMethodInsn(182, "ic2classic/api/Direction", "toForgeDirection", "()Lnet/minecraftforge/common/util/ForgeDirection;", false);
        mv.visitMethodInsn(182, this.className, "emitsEnergyTo", "(Lnet/minecraft/tileentity/TileEntity;Lnet/minecraftforge/common/util/ForgeDirection;)Z", false);
        mv.visitInsn(172);
        mv.visitMaxs(3, 3);
        mv.visitEnd();
    }

    public void generateSourceAdapters() {
        MethodVisitor mv = this.visitMethod(1, "IC2Classic_getMaxEnergyOutput", "()I", null, null);
        mv.visitCode();
        mv.visitVarInsn(25, 0);
        mv.visitMethodInsn(182, this.className, "getSourceTier", "()I", false);
        mv.visitMethodInsn(184, "ic2classic/api_compat/CompatUtils", "tierToMaxVoltage", "(I)I", false);
        mv.visitInsn(172);
        mv.visitMaxs(1, 1);
        mv.visitEnd();
    }

    public void generateAcceptorAdapters() {
        MethodVisitor mv = this.visitMethod(1, "IC2Classic_acceptsEnergyFrom", "(Lnet/minecraft/tileentity/TileEntity;Lic2classic/api/Direction;)Z", null, null);
        mv.visitCode();
        mv.visitVarInsn(25, 0);
        mv.visitVarInsn(25, 1);
        mv.visitVarInsn(25, 2);
        mv.visitMethodInsn(182, "ic2classic/api/Direction", "toForgeDirection", "()Lnet/minecraftforge/common/util/ForgeDirection;", false);
        mv.visitMethodInsn(182, this.className, "acceptsEnergyFrom", "(Lnet/minecraft/tileentity/TileEntity;Lnet/minecraftforge/common/util/ForgeDirection;)Z", false);
        mv.visitInsn(172);
        mv.visitMaxs(3, 3);
        mv.visitEnd();
    }

    public void generateSinkAdapters() {
        MethodVisitor mv = this.visitMethod(1, "IC2Classic_demandsEnergy", "()I", null, null);
        mv.visitCode();
        mv.visitVarInsn(25, 0);
        mv.visitMethodInsn(182, this.className, "getDemandedEnergy", "()D", false);
        mv.visitVarInsn(25, 0);
        mv.visitFieldInsn(180, this.className, EXCESS_ENERGY_FIELD_NAME, "D");
        mv.visitMethodInsn(184, "java/lang/Math", "ceil", "(D)D", false);
        mv.visitInsn(103);
        mv.visitInsn(142);
        mv.visitInsn(172);
        mv.visitMaxs(4, 1);
        mv.visitEnd();
        mv = this.visitMethod(1, "IC2Classic_getMaxSafeInput", "()I", null, null);
        mv.visitCode();
        mv.visitVarInsn(25, 0);
        mv.visitMethodInsn(182, this.className, "getSinkTier", "()I", false);
        mv.visitMethodInsn(184, "ic2classic/api_compat/CompatUtils", "tierToMaxVoltage", "(I)I", false);
        mv.visitInsn(172);
        mv.visitMaxs(1, 1);
        mv.visitEnd();
        this.visitField(1, EXCESS_ENERGY_FIELD_NAME, "D", null, null).visitEnd();
        mv = this.visitMethod(1, "IC2Classic_injectEnergy", "(Lic2classic/api/Direction;I)Z", null, null);
        mv.visitCode();
        mv.visitVarInsn(21, 2);
        mv.visitInsn(135);
        mv.visitVarInsn(57, 2);
        mv.visitInsn(3);
        mv.visitVarInsn(54, 4);
        Label dontUseEnergyLabel = new Label();
        mv.visitVarInsn(25, 0);
        mv.visitFieldInsn(180, this.className, EXCESS_ENERGY_FIELD_NAME, "D");
        mv.visitVarInsn(24, 2);
        mv.visitInsn(152);
        mv.visitJumpInsn(156, dontUseEnergyLabel);
        mv.visitVarInsn(25, 0);
        mv.visitInsn(89);
        mv.visitFieldInsn(180, this.className, EXCESS_ENERGY_FIELD_NAME, "D");
        mv.visitVarInsn(24, 2);
        mv.visitInsn(99);
        mv.visitFieldInsn(181, this.className, EXCESS_ENERGY_FIELD_NAME, "D");
        mv.visitInsn(4);
        mv.visitVarInsn(54, 4);
        mv.visitLabel(dontUseEnergyLabel);
        mv.visitFrame(-1, 4, new Object[]{this.className, "ic2classic/api/Direction", Opcodes.DOUBLE, Opcodes.INTEGER}, 0, new Object[0]);
        mv.visitVarInsn(25, 0);
        mv.visitVarInsn(25, 0);
        mv.visitVarInsn(25, 1);
        mv.visitMethodInsn(182, "ic2classic/api/Direction", "toForgeDirection", "()Lnet/minecraftforge/common/util/ForgeDirection;", false);
        mv.visitVarInsn(25, 0);
        mv.visitFieldInsn(180, this.className, EXCESS_ENERGY_FIELD_NAME, "D");
        mv.visitVarInsn(24, 2);
        mv.visitMethodInsn(182, this.className, "injectEnergy", "(Lnet/minecraftforge/common/util/ForgeDirection;DD)D", false);
        mv.visitFieldInsn(181, this.className, EXCESS_ENERGY_FIELD_NAME, "D");
        mv.visitVarInsn(21, 4);
        mv.visitInsn(172);
        mv.visitMaxs(7, 5);
        mv.visitEnd();
    }
}

