/*
 * Decompiled with CFR 0.152.
 */
package ic2classic.api_compat;

import cpw.mods.fml.common.versioning.ArtifactVersion;
import ic2classic.api_compat.DirectItemAccessClassAdapter;
import ic2classic.api_compat.EnergyInterfaceClassAdapter;
import ic2classic.api_compat.MiscChangesClassAdapter;
import ic2classic.api_compat.reactor.NonexistentNewReactorTE;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.minecraft.launchwrapper.IClassTransformer;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Type;
import org.objectweb.asm.commons.Remapper;
import org.objectweb.asm.commons.RemappingClassAdapter;
import org.objectweb.asm.util.CheckClassAdapter;

public class Transformer
implements IClassTransformer {
    static Remapper remapper = new Remapper(){

        public String map(String type) {
            if (type.equals("ic2/api/item/IC2Items")) {
                type = "ic2classic/api_compat/CompatItems";
            } else if (!(type.startsWith("ic2/core/Adv") || type.equals("ic2/core/WorldData") || type.equals("ic2/core/WindSim") || type.equals("ic2/core/util/SideGateway"))) {
                if (type.startsWith("ic2/core/audio") || type.equals("ic2/core/CreativeTabIC2") || type.equals("ic2/core/IC2") || type.equals("ic2/core/item/tool/ItemToolCutter") || type.equals("ic2/core/Platform") || type.equals("ic2/core/network/NetworkManager") || type.equals("ic2/core/util/StackUtil")) {
                    type = "ic2classic/" + type.substring(4);
                } else if (type.equals("ic2/api/network/NetworkHelper")) {
                    type = "ic2classic/api_compat/network/NetworkHelper";
                } else if (type.startsWith("ic2/") && !type.startsWith("ic2/api/")) {
                    System.err.println("IC2 Classic API Compatibility: unknown IC2 core class " + type);
                    type = "ic2classic/" + type.substring(4);
                } else if (type.startsWith("ic2/core/block/reactor/tileentity/")) {
                    type = Type.getType(NonexistentNewReactorTE.class).getInternalName();
                }
            }
            return type;
        }
    };
    private static byte[] PRE_CHECK_MARKER = new byte[]{105, 99, 50, 47};
    private static byte[] PRE_CHECK_MARKER2 = new byte[]{105, 99, 50, 99, 108, 97, 115, 115, 105, 99, 47};

    public static List<ArtifactVersion> messWithAPIDependency(List<ArtifactVersion> in) {
        if (in.size() == 1 && in.get(0).getLabel().equals("IC2")) {
            return Collections.emptyList();
        }
        return in;
    }

    public byte[] transform(String arg0, final String className, byte[] arg2) {
        if (arg2 == null) {
            return null;
        }
        if (arg0.startsWith("ic2classic.api_compat.") || arg0.startsWith("ic2classic.api.") || arg0.startsWith("ic2.api.")) {
            return arg2;
        }
        if (arg0.equals("cpw.mods.fml.common.ModAPIManager$APIContainer")) {
            ClassWriter cw = new ClassWriter(0);
            new ClassReader(arg2).accept(new ClassVisitor(327680, (ClassVisitor)cw){

                public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
                    if (name.equals("getDependencies")) {
                        return new MethodVisitor(327680, super.visitMethod(access, name, desc, signature, exceptions)){

                            public void visitInsn(int opcode) {
                                if (opcode == 176) {
                                    super.visitMethodInsn(184, Transformer.class.getName().replace('.', '/'), "messWithAPIDependency", "(Ljava/util/List;)Ljava/util/List;", false);
                                }
                                super.visitInsn(176);
                            }
                        };
                    }
                    return super.visitMethod(access, name, desc, signature, exceptions);
                }
            }, 0);
            return cw.toByteArray();
        }
        if (!this.byteArrayContains(arg2, PRE_CHECK_MARKER) && !this.byteArrayContains(arg2, PRE_CHECK_MARKER2)) {
            return arg2;
        }
        ClassWriter cw = new ClassWriter(0);
        ClassVisitor cv = new MiscChangesClassAdapter(new DirectItemAccessClassAdapter(new EnergyInterfaceClassAdapter((ClassVisitor)new RemappingClassAdapter((ClassVisitor)cw, remapper))));
        cv = new ClassVisitor(327680, (ClassVisitor)new CheckClassAdapter(cv)){
            private Set<String> seen;
            {
                super($anonymous0, $anonymous1);
                this.seen = new HashSet<String>();
            }

            public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
                String key = String.valueOf(name) + desc;
                if (!this.seen.add(key)) {
                    throw new RuntimeException("Sanity check failed: Duplicate method " + key + " in " + className);
                }
                return super.visitMethod(access, name, desc, signature, exceptions);
            }
        };
        new ClassReader(arg2).accept(cv, 8);
        return cw.toByteArray();
    }

    private boolean byteArrayContains(byte[] haystack, byte[] needle) {
        int k = 0;
        while (k <= haystack.length - needle.length) {
            int j = 0;
            while (j < needle.length) {
                if (needle[j] != haystack[k + j]) break;
                ++j;
            }
            if (j == needle.length) {
                return true;
            }
            ++k;
        }
        return false;
    }
}

