/*
 * Decompiled with CFR 0.152.
 */
package ic2classic.api_compat.network;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufInputStream;
import io.netty.buffer.ByteBufOutputStream;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTTagCompound;

public class ObjectIO {
    public static void write(Object value, ByteBuf buf) {
        if (value instanceof Byte) {
            buf.writeByte(0);
            buf.writeByte((int)((Byte)value).byteValue());
        } else if (value instanceof Integer) {
            buf.writeByte(1);
            buf.writeInt(((Integer)value).intValue());
        } else if (value == null) {
            buf.writeByte(2);
        } else if (value instanceof String) {
            buf.writeByte(3);
            ObjectIO.writeString((String)value, buf);
        } else if (value instanceof Boolean) {
            buf.writeByte((Boolean)value != false ? 5 : 4);
        } else if (value instanceof Short) {
            buf.writeByte(6);
            buf.writeShort((int)((Short)value).shortValue());
        } else if (value instanceof Serializable) {
            buf.writeByte(7);
            try {
                new ObjectOutputStream((OutputStream)new ByteBufOutputStream(buf)).writeObject(value);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        } else if (value instanceof NBTTagCompound) {
            buf.writeByte(8);
            try {
                CompressedStreamTools.func_74800_a((NBTTagCompound)((NBTTagCompound)value), (DataOutput)new DataOutputStream((OutputStream)new ByteBufOutputStream(buf)));
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        } else if (value instanceof ItemStack) {
            buf.writeByte(9);
            ObjectIO.write(((ItemStack)value).func_77955_b(new NBTTagCompound()), buf);
        } else {
            throw new RuntimeException("can't send " + value + " (" + value.getClass().getName() + ")");
        }
    }

    public static Object read(ByteBuf buf) {
        switch (buf.readByte()) {
            case 0: {
                return buf.readByte();
            }
            case 1: {
                return buf.readInt();
            }
            case 2: {
                return null;
            }
            case 3: {
                return ObjectIO.readString(buf);
            }
            case 4: {
                return Boolean.FALSE;
            }
            case 5: {
                return Boolean.TRUE;
            }
            case 6: {
                return buf.readShort();
            }
            case 7: {
                try {
                    return new ObjectInputStream((InputStream)new ByteBufInputStream(buf)).readObject();
                }
                catch (IOException | ClassNotFoundException e) {
                    throw new RuntimeException(e);
                }
            }
            case 8: {
                try {
                    return CompressedStreamTools.func_74794_a((DataInputStream)new DataInputStream((InputStream)new ByteBufInputStream(buf)));
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
            case 9: {
                return ItemStack.func_77949_a((NBTTagCompound)((NBTTagCompound)ObjectIO.read(buf)));
            }
        }
        return null;
    }

    public static String readString(ByteBuf buf) {
        int len = buf.readInt();
        byte[] bytes = new byte[len];
        buf.readBytes(bytes);
        return new String(bytes, StandardCharsets.UTF_8);
    }

    public static void writeString(String s, ByteBuf buf) {
        byte[] bytes = s.getBytes(StandardCharsets.UTF_8);
        buf.writeInt(bytes.length);
        buf.writeBytes(bytes);
    }
}

