/*
 * Decompiled with CFR 0.152.
 */
package ic2classic.api_compat;

import ic2.api.energy.IEnergyNet;
import ic2.api.energy.NodeStats;
import ic2classic.api.energy.EnergyNet;
import ic2classic.api_compat.CompatUtils;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class EnergyNetAPIImpl
implements IEnergyNet {
    @Override
    public TileEntity getTileEntity(World world, int x, int y, int z) {
        return world.func_147438_o(x, y, z);
    }

    @Override
    public TileEntity getNeighbor(TileEntity te, ForgeDirection dir) {
        return this.getTileEntity(te.func_145831_w(), te.field_145851_c + dir.offsetX, te.field_145848_d + dir.offsetY, te.field_145849_e + dir.offsetZ);
    }

    @Override
    public double getTotalEnergyEmitted(TileEntity tileEntity) {
        return EnergyNet.getForWorld((World)tileEntity.func_145831_w()).getTotalEnergyEmitted(tileEntity);
    }

    @Override
    public double getTotalEnergySunken(TileEntity tileEntity) {
        return EnergyNet.getForWorld((World)tileEntity.func_145831_w()).getTotalEnergySunken(tileEntity);
    }

    @Override
    public NodeStats getNodeStats(TileEntity te) {
        return new NodeStats(0.0, 0.0, 0.0);
    }

    @Override
    public double getPowerFromTier(int tier) {
        return CompatUtils.tierToMaxVoltage(tier);
    }

    @Override
    public int getTierFromPower(double power) {
        int k = 0;
        while (k < 32) {
            if ((double)CompatUtils.tierToMaxVoltage(k) >= power) {
                return k;
            }
            ++k;
        }
        return 32;
    }
}

