/*
 * Decompiled with CFR 0.152.
 */
package com.estebes.compactic2generators.tileentity;

import com.estebes.compactic2generators.tileentity.TileEntityBaseMachine;
import ic2.api.energy.tile.IEnergySink;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.util.ForgeDirection;

public class TileEntityEnergyMachine
extends TileEntityBaseMachine
implements IEnergySink {
    private int storedEnergy;
    private final int maxStoredEnergy;
    private final int sinkTier;
    private final int maxVoltage;

    public TileEntityEnergyMachine(int maxStoredEnergy, int sinkTier) {
        this.maxStoredEnergy = maxStoredEnergy;
        this.sinkTier = sinkTier;
        this.maxVoltage = (int)(32.0 * Math.pow(4.0, sinkTier - 1));
    }

    public double getDemandedEnergy() {
        return this.storedEnergy < this.maxStoredEnergy ? (double)this.maxVoltage : 0.0;
    }

    public int getSinkTier() {
        return this.sinkTier;
    }

    public double injectEnergy(ForgeDirection directionFrom, double amount, double voltage) {
        if (this.storedEnergy >= this.maxStoredEnergy) {
            return amount;
        }
        this.storedEnergy += Math.min(this.maxVoltage, (int)amount);
        return amount - (double)Math.min(this.maxVoltage, (int)amount);
    }

    public boolean acceptsEnergyFrom(TileEntity emitter, ForgeDirection direction) {
        return true;
    }

    public int getStoredEnergy() {
        return this.storedEnergy;
    }

    public void setStoredEnergy(int value) {
        this.storedEnergy = value;
    }

    public int getMaxStoredEnergy() {
        return this.maxStoredEnergy;
    }

    public int getMaxVoltage() {
        return this.maxVoltage;
    }
}

