/*
 * Decompiled with CFR 0.152.
 */
package com.estebes.compactic2generators.tileentity;

import com.estebes.compactic2generators.network.PacketHandler;
import com.estebes.compactic2generators.network.message.MessageTileEntityCobbleMachine;
import com.estebes.compactic2generators.tileentity.TileEntityBaseMachine;
import cpw.mods.fml.common.eventhandler.Event;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import ic2.api.energy.event.EnergyTileLoadEvent;
import ic2.api.energy.event.EnergyTileUnloadEvent;
import ic2.api.energy.tile.IEnergySink;
import ic2.api.energy.tile.IEnergyTile;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.network.Packet;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.ForgeDirection;

public class TileEntityCobbleMachine
extends TileEntityBaseMachine
implements ISidedInventory,
IEnergySink {
    private final int machineTier;
    private int tickCounter;
    public final int MAX_STORED_ENERGY;
    private final int MAX_VOLTAGE;
    private final int ENERGY_COST_PER_TICK;
    private int STORED_ENERGY;
    private boolean ENET_CHECKER;
    private ItemStack[] machineInventory = new ItemStack[1];

    public TileEntityCobbleMachine() {
        this(1);
    }

    public TileEntityCobbleMachine(int machineTier) {
        this.machineTier = machineTier;
        this.MAX_STORED_ENERGY = 4000 * (int)Math.pow(4.0, machineTier - 1);
        this.MAX_VOLTAGE = 32 * (int)Math.pow(4.0, machineTier - 1);
        this.ENERGY_COST_PER_TICK = 2 * (int)Math.pow(8.0, machineTier - 1);
        this.STORED_ENERGY = 0;
        this.tickCounter = 0;
    }

    public double getDemandedEnergy() {
        return this.STORED_ENERGY < this.MAX_STORED_ENERGY ? (double)this.MAX_VOLTAGE : 0.0;
    }

    public int getSinkTier() {
        return this.machineTier;
    }

    public double injectEnergy(ForgeDirection directionFrom, double amount, double voltage) {
        if (this.STORED_ENERGY >= this.MAX_STORED_ENERGY) {
            return amount;
        }
        this.STORED_ENERGY += Math.min(this.MAX_VOLTAGE, (int)amount);
        return amount - (double)Math.min(this.MAX_VOLTAGE, (int)amount);
    }

    public boolean acceptsEnergyFrom(TileEntity emitter, ForgeDirection direction) {
        return true;
    }

    public int[] func_94128_d(int p_94128_1_) {
        return new int[0];
    }

    public boolean func_102007_a(int p_102007_1_, ItemStack p_102007_2_, int p_102007_3_) {
        return false;
    }

    public boolean func_102008_b(int p_102008_1_, ItemStack p_102008_2_, int p_102008_3_) {
        return false;
    }

    public int func_70302_i_() {
        return this.machineInventory.length;
    }

    public ItemStack func_70301_a(int slot) {
        return null;
    }

    public ItemStack func_70298_a(int p_70298_1_, int p_70298_2_) {
        return null;
    }

    public ItemStack func_70304_b(int p_70304_1_) {
        return null;
    }

    public void func_70299_a(int p_70299_1_, ItemStack p_70299_2_) {
    }

    public String func_145825_b() {
        return "Cobble Generator Mark " + this.machineTier;
    }

    public boolean func_145818_k_() {
        return false;
    }

    public int func_70297_j_() {
        return 64;
    }

    public boolean func_70300_a(EntityPlayer p_70300_1_) {
        return false;
    }

    public void func_70295_k_() {
    }

    public void func_70305_f() {
    }

    public boolean func_94041_b(int p_94041_1_, ItemStack p_94041_2_) {
        return false;
    }

    public void func_145843_s() {
        if (!this.field_145850_b.field_72995_K && this.ENET_CHECKER) {
            MinecraftForge.EVENT_BUS.post((Event)new EnergyTileUnloadEvent((IEnergyTile)this));
            this.ENET_CHECKER = false;
        }
        super.func_145843_s();
    }

    public void onChunkUnload() {
        if (!this.field_145850_b.field_72995_K && this.ENET_CHECKER) {
            MinecraftForge.EVENT_BUS.post((Event)new EnergyTileUnloadEvent((IEnergyTile)this));
            this.ENET_CHECKER = false;
        }
        super.onChunkUnload();
    }

    public void func_145845_h() {
        super.func_145845_h();
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        if (!this.ENET_CHECKER) {
            MinecraftForge.EVENT_BUS.post((Event)new EnergyTileLoadEvent((IEnergyTile)this));
            this.ENET_CHECKER = true;
        }
        if (this.STORED_ENERGY < this.ENERGY_COST_PER_TICK) {
            return;
        }
        ++this.tickCounter;
        this.STORED_ENERGY -= this.ENERGY_COST_PER_TICK;
        if (this.tickCounter >= 512 / this.ENERGY_COST_PER_TICK) {
            this.addItemStackToOutput();
            this.tickCounter = 0;
        }
        this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        this.func_70296_d();
    }

    protected void addItemStackToOutput() {
        ItemStack cobbleStack = new ItemStack(Blocks.field_150347_e);
        int maxStackSize = Math.min(this.func_70297_j_(), cobbleStack.func_77976_d());
        if (this.machineInventory[0] == null) {
            this.machineInventory[0] = cobbleStack.func_77946_l();
        } else if (this.machineInventory[0].func_77973_b() == cobbleStack.func_77973_b()) {
            if (this.machineInventory[0].field_77994_a < maxStackSize) {
                this.machineInventory[0].field_77994_a = this.machineTier == 4 ? (this.machineInventory[0].field_77994_a += 64) : ++this.machineInventory[0].field_77994_a;
            }
        } else {
            return;
        }
    }

    public Packet func_145844_m() {
        return PacketHandler.INSTANCE.getPacketFrom((IMessage)new MessageTileEntityCobbleMachine(this));
    }
}

