/*
 * Decompiled with CFR 0.152.
 */
package com.estebes.compactic2generators.tileentity.machine;

import com.estebes.compactic2generators.network.PacketHandler;
import com.estebes.compactic2generators.network.message.MessageTileEntityTreeHarvester;
import com.estebes.compactic2generators.tileentity.TileEntityBaseMachine;
import com.estebes.compactic2generators.utility.StackUtil;
import cpw.mods.fml.client.FMLClientHandler;
import cpw.mods.fml.common.eventhandler.Event;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import ic2.api.energy.event.EnergyTileLoadEvent;
import ic2.api.energy.event.EnergyTileUnloadEvent;
import ic2.api.energy.tile.IEnergySink;
import ic2.api.energy.tile.IEnergyTile;
import ic2.api.item.IC2Items;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.Packet;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.FakePlayerFactory;
import net.minecraftforge.common.util.ForgeDirection;

public class TileEntityTreeHarvester
extends TileEntityBaseMachine
implements IEnergySink,
ISidedInventory {
    private int tickCounter = 0;
    private static final int harvestMode = 2;
    private int currentX = -5;
    private int currentY = 0;
    private int currentZ = -5;
    private final int MAX_STORED_ENERGY;
    private final int MAX_VOLTAGE;
    private final int ENERGY_COST_PER_TICK;
    private int STORED_ENERGY = 0;
    private boolean ENET_CHECKER;
    private static final int moduleSlot = 0;
    private static final int powerSlot = 1;
    private ItemStack[] machineInventory = new ItemStack[16];

    public TileEntityTreeHarvester() {
        this.MAX_STORED_ENERGY = 10000;
        this.MAX_VOLTAGE = 32;
        this.ENERGY_COST_PER_TICK = 2;
    }

    @Override
    public void func_145839_a(NBTTagCompound nbtTagCompound) {
        super.func_145839_a(nbtTagCompound);
        NBTTagList nbttaglist = nbtTagCompound.func_150295_c("teNBT", 10);
        for (int i = 0; i < nbttaglist.func_74745_c(); ++i) {
            NBTTagCompound nbttagcompound1 = nbttaglist.func_150305_b(i);
            byte b0 = nbttagcompound1.func_74771_c("Slot");
            if (b0 < 0 || b0 >= this.machineInventory.length) continue;
            this.machineInventory[b0] = ItemStack.func_77949_a((NBTTagCompound)nbttagcompound1);
        }
        if (nbtTagCompound.func_74764_b("teEnergyStored")) {
            this.STORED_ENERGY = nbtTagCompound.func_74762_e("teEnergyStored");
        }
        if (nbtTagCompound.func_74764_b("teTickCounter")) {
            this.tickCounter = nbtTagCompound.func_74762_e("teTickCounter");
        }
        if (nbtTagCompound.func_74764_b("teScanX")) {
            this.currentX = nbtTagCompound.func_74762_e("teScanX");
        }
        if (nbtTagCompound.func_74764_b("teScanY")) {
            this.currentY = nbtTagCompound.func_74762_e("teScanY");
        }
        if (nbtTagCompound.func_74764_b("teScanZ")) {
            this.currentZ = nbtTagCompound.func_74762_e("teScanZ");
        }
    }

    @Override
    public void func_145841_b(NBTTagCompound nbtTagCompound) {
        super.func_145841_b(nbtTagCompound);
        NBTTagList tagList = new NBTTagList();
        for (int currentIndex = 0; currentIndex < this.machineInventory.length; ++currentIndex) {
            if (this.machineInventory[currentIndex] == null) continue;
            NBTTagCompound tagCompound = new NBTTagCompound();
            tagCompound.func_74774_a("Slot", (byte)currentIndex);
            this.machineInventory[currentIndex].func_77955_b(tagCompound);
            tagList.func_74742_a((NBTBase)tagCompound);
        }
        nbtTagCompound.func_74782_a("teNBT", (NBTBase)tagList);
        nbtTagCompound.func_74768_a("teEnergyStored", this.STORED_ENERGY);
        nbtTagCompound.func_74768_a("teTickCounter", this.tickCounter);
        nbtTagCompound.func_74768_a("teScanX", this.currentX);
        nbtTagCompound.func_74768_a("teScanY", this.currentY);
        nbtTagCompound.func_74768_a("teScanZ", this.currentZ);
    }

    public double getDemandedEnergy() {
        return this.STORED_ENERGY < this.MAX_STORED_ENERGY ? (double)this.MAX_VOLTAGE : 0.0;
    }

    public int getSinkTier() {
        return 1;
    }

    public double injectEnergy(ForgeDirection directionFrom, double amount, double voltage) {
        if (this.STORED_ENERGY >= this.MAX_STORED_ENERGY) {
            return amount;
        }
        this.STORED_ENERGY += Math.min(this.MAX_VOLTAGE, (int)amount);
        return amount - (double)Math.min(this.MAX_VOLTAGE, (int)amount);
    }

    public boolean acceptsEnergyFrom(TileEntity emitter, ForgeDirection direction) {
        return true;
    }

    public void func_145843_s() {
        if (!this.field_145850_b.field_72995_K && this.ENET_CHECKER) {
            MinecraftForge.EVENT_BUS.post((Event)new EnergyTileUnloadEvent((IEnergyTile)this));
            this.ENET_CHECKER = false;
        }
        super.func_145843_s();
    }

    public void onChunkUnload() {
        if (!this.field_145850_b.field_72995_K && this.ENET_CHECKER) {
            MinecraftForge.EVENT_BUS.post((Event)new EnergyTileUnloadEvent((IEnergyTile)this));
            this.ENET_CHECKER = false;
        }
        super.onChunkUnload();
    }

    public void func_145845_h() {
        super.func_145845_h();
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        if (!this.ENET_CHECKER) {
            MinecraftForge.EVENT_BUS.post((Event)new EnergyTileLoadEvent((IEnergyTile)this));
            this.ENET_CHECKER = true;
        }
        if (this.STORED_ENERGY < this.ENERGY_COST_PER_TICK + 200) {
            return;
        }
        ++this.tickCounter;
        this.STORED_ENERGY -= this.ENERGY_COST_PER_TICK;
        if (this.tickCounter < 20) {
            ++this.tickCounter;
            return;
        }
        switch (2) {
            case 1: {
                this.harvestBlock(this.field_145851_c, this.field_145848_d, this.field_145849_e);
                break;
            }
            case 2: {
                this.harvestRubber(this.field_145851_c + this.currentX, this.field_145848_d + this.currentY, this.field_145849_e + this.currentZ);
                break;
            }
        }
        this.tickCounter = 0;
        this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        this.func_70296_d();
    }

    protected void scanSquare() {
        ++this.currentX;
        if (this.currentX > 5) {
            this.currentX = -5;
            ++this.currentZ;
            if (this.currentZ > 5) {
                this.currentZ = -5;
            }
        }
    }

    protected void harvestBlock(int x, int y, int z) {
        if (this.isBlockHarvestable(x, y, z)) {
            FMLClientHandler.instance().getClient().field_71452_i.func_147215_a(x, y, z, this.field_145850_b.func_147439_a(x, y, z), this.field_145850_b.func_72805_g(x, y, z));
            this.field_145850_b.func_147468_f(x, y, z);
            if (this.field_145850_b.func_147438_o(x, y, z) != null) {
                this.field_145850_b.func_147455_a(x, y, z, null);
            }
        } else {
            ItemStack sapling = new ItemStack(Blocks.field_150345_g, 1, 0);
            sapling.func_77946_l().func_77943_a((EntityPlayer)FakePlayerFactory.getMinecraft((WorldServer)((WorldServer)this.func_145831_w())), this.func_145831_w(), x, y, z, 1, 0.0f, 0.0f, 0.0f);
        }
    }

    protected boolean isBlockHarvestable(int x, int y, int z) {
        return this.field_145850_b.func_147439_a(x, y, z).isWood((IBlockAccess)this.field_145850_b, x, y, z) || this.field_145850_b.func_147439_a(x, y, z).isLeaves((IBlockAccess)this.field_145850_b, x, y, z);
    }

    protected void harvestRubber(int x, int y, int z) {
        int meta = this.field_145850_b.func_72805_g(x, y, z);
        if (this.isRubberWood(x, y, z)) {
            if (this.isRubberHarvestable(x, y, z) && this.addStackToOutput()) {
                FMLClientHandler.instance().getClient().field_71452_i.func_147215_a(x, y, z, this.field_145850_b.func_147439_a(x, y, z), this.field_145850_b.func_72805_g(x, y, z));
                this.field_145850_b.func_72921_c(x, y, z, meta + 6, 2);
                this.STORED_ENERGY -= 200;
            }
            ++this.currentY;
        } else {
            this.scanSquare();
            this.currentY = 0;
        }
    }

    protected boolean isRubberWood(int x, int y, int z) {
        Block block = this.field_145850_b.func_147439_a(x, y, z);
        return StackUtil.equals(block, IC2Items.getItem((String)"rubberWood"));
    }

    protected boolean isRubberHarvestable(int x, int y, int z) {
        int meta = this.field_145850_b.func_72805_g(x, y, z);
        Block block = this.field_145850_b.func_147439_a(x, y, z);
        return StackUtil.equals(block, IC2Items.getItem((String)"rubberWood")) && meta >= 2 && meta <= 5;
    }

    protected boolean addStackToOutput() {
        ItemStack itemStack = IC2Items.getItem((String)"resin");
        int maxStackSize = Math.min(this.func_70297_j_(), itemStack.func_77976_d());
        for (int slotIndex = 1; slotIndex < this.machineInventory.length; ++slotIndex) {
            if (this.machineInventory[slotIndex] == null) {
                this.machineInventory[slotIndex] = itemStack.func_77946_l();
                return true;
            }
            if (this.machineInventory[slotIndex].func_77973_b() != itemStack.func_77973_b() || this.machineInventory[slotIndex].field_77994_a >= maxStackSize) continue;
            this.machineInventory[slotIndex].field_77994_a += itemStack.field_77994_a;
            return true;
        }
        return false;
    }

    public int getModuleSlot() {
        return 0;
    }

    public int[] func_94128_d(int side) {
        int[] indexArray = new int[this.machineInventory.length - 1];
        for (int slotIndex = 0; slotIndex < this.machineInventory.length - 1; ++slotIndex) {
            indexArray[slotIndex] = slotIndex + 1;
        }
        return indexArray;
    }

    public boolean func_102007_a(int slotIndex, ItemStack itemStack, int side) {
        return false;
    }

    public boolean func_102008_b(int slotIndex, ItemStack itemStack, int side) {
        return slotIndex != this.getModuleSlot();
    }

    public int func_70302_i_() {
        return this.machineInventory.length;
    }

    public ItemStack func_70301_a(int slotIndex) {
        return this.machineInventory[slotIndex];
    }

    public ItemStack func_70298_a(int i, int j) {
        ItemStack itemStack = this.func_70301_a(i);
        if (itemStack != null) {
            if (itemStack.field_77994_a <= j) {
                this.func_70299_a(i, null);
            } else {
                itemStack = this.machineInventory[i].func_77979_a(j);
                if (itemStack.field_77994_a == 0) {
                    this.func_70299_a(i, null);
                }
            }
        }
        return itemStack;
    }

    public ItemStack func_70304_b(int slotIndex) {
        return null;
    }

    public void func_70299_a(int slotIndex, ItemStack itemStack) {
        this.machineInventory[slotIndex] = itemStack;
        if (itemStack != null && itemStack.field_77994_a > this.func_70297_j_()) {
            itemStack.field_77994_a = this.func_70297_j_();
        }
    }

    public String func_145825_b() {
        return null;
    }

    public boolean func_145818_k_() {
        return false;
    }

    public int func_70297_j_() {
        return 64;
    }

    public boolean func_70300_a(EntityPlayer player) {
        return true;
    }

    public void func_70295_k_() {
    }

    public void func_70305_f() {
    }

    public boolean func_94041_b(int slotIndex, ItemStack itemStack) {
        return false;
    }

    public int getStoreEnergy() {
        return this.STORED_ENERGY;
    }

    public void setStoredEnergy(int value) {
        this.STORED_ENERGY = value;
    }

    public int getTickCounter() {
        return this.tickCounter;
    }

    public void setTickCounter(int value) {
        this.tickCounter = value;
    }

    public int[] getScanCoords() {
        return new int[]{this.currentX, this.currentY, this.currentZ};
    }

    public void setScanCoords(int[] scanCoords) {
        this.currentX = scanCoords[0];
        this.currentY = scanCoords[1];
        this.currentZ = scanCoords[2];
    }

    public int getScaledEnergy() {
        return this.STORED_ENERGY * 13 / this.MAX_STORED_ENERGY;
    }

    @Override
    public Packet func_145844_m() {
        return PacketHandler.INSTANCE.getPacketFrom((IMessage)new MessageTileEntityTreeHarvester(this));
    }
}

