/*
 * Decompiled with CFR 0.152.
 */
package com.estebes.compactic2generators.tileentity;

import com.estebes.compactic2generators.network.PacketHandler;
import com.estebes.compactic2generators.network.message.MessageTileEntityEnergyMachine;
import com.estebes.compactic2generators.tileentity.TileEntityInventoryMachine;
import cpw.mods.fml.common.eventhandler.Event;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import ic2.api.energy.event.EnergyTileLoadEvent;
import ic2.api.energy.event.EnergyTileUnloadEvent;
import ic2.api.energy.tile.IEnergySink;
import ic2.api.energy.tile.IEnergyTile;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.Packet;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.ForgeDirection;

public class TileEntityEnergyMachine
extends TileEntityInventoryMachine
implements IEnergySink {
    private int storedEnergy;
    private final int maxStoredEnergy;
    private final int sinkTier;
    private final int maxVoltage;
    private final int energyCostTick;
    private boolean enetChecker;

    public TileEntityEnergyMachine(int maxStoredEnergy, int sinkTier, int energyCostTick, int inventorySize) {
        super(inventorySize);
        this.maxStoredEnergy = maxStoredEnergy;
        this.sinkTier = sinkTier;
        this.energyCostTick = energyCostTick;
        this.maxVoltage = (int)(32.0 * Math.pow(4.0, sinkTier - 1));
    }

    @Override
    public void func_145839_a(NBTTagCompound nbtTagCompound) {
        super.func_145839_a(nbtTagCompound);
        if (nbtTagCompound.func_74764_b("tileEntityStoredEnergy")) {
            this.storedEnergy = nbtTagCompound.func_74762_e("tileEntityStoredEnergy");
        }
    }

    @Override
    public void func_145841_b(NBTTagCompound nbtTagCompound) {
        super.func_145841_b(nbtTagCompound);
        nbtTagCompound.func_74768_a("tileEntityStoredEnergy", this.storedEnergy);
    }

    public void func_145843_s() {
        if (!this.field_145850_b.field_72995_K && this.enetChecker) {
            MinecraftForge.EVENT_BUS.post((Event)new EnergyTileUnloadEvent((IEnergyTile)this));
            this.enetChecker = false;
        }
        super.func_145843_s();
    }

    public void onChunkUnload() {
        if (!this.field_145850_b.field_72995_K && this.enetChecker) {
            MinecraftForge.EVENT_BUS.post((Event)new EnergyTileUnloadEvent((IEnergyTile)this));
            this.enetChecker = false;
        }
        super.onChunkUnload();
    }

    public void func_145845_h() {
        super.func_145845_h();
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        if (!this.enetChecker) {
            MinecraftForge.EVENT_BUS.post((Event)new EnergyTileLoadEvent((IEnergyTile)this));
            this.enetChecker = true;
        }
        this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        this.func_70296_d();
    }

    public double getDemandedEnergy() {
        return this.storedEnergy < this.maxStoredEnergy ? (double)this.maxVoltage : 0.0;
    }

    public int getSinkTier() {
        return this.sinkTier;
    }

    public double injectEnergy(ForgeDirection directionFrom, double amount, double voltage) {
        if (this.storedEnergy >= this.maxStoredEnergy) {
            return amount;
        }
        this.storedEnergy += Math.min(this.maxVoltage, (int)amount);
        return amount - (double)Math.min(this.maxVoltage, (int)amount);
    }

    public boolean acceptsEnergyFrom(TileEntity emitter, ForgeDirection direction) {
        return true;
    }

    public int getStoredEnergy() {
        return this.storedEnergy;
    }

    public void setStoredEnergy(int value) {
        this.storedEnergy = value;
    }

    public int getMaxStoredEnergy() {
        return this.maxStoredEnergy;
    }

    public int getMaxVoltage() {
        return this.maxVoltage;
    }

    public int getEnergyCostTick() {
        return this.energyCostTick;
    }

    public int getScaledEnergy() {
        return this.storedEnergy * 13 / this.maxStoredEnergy;
    }

    @Override
    public Packet func_145844_m() {
        return PacketHandler.INSTANCE.getPacketFrom((IMessage)new MessageTileEntityEnergyMachine(this));
    }
}

