/*
 * Decompiled with CFR 0.152.
 */
package com.estebes.compactic2generators.tileentity;

import cpw.mods.fml.common.eventhandler.Event;
import ic2.api.energy.event.EnergyTileLoadEvent;
import ic2.api.energy.event.EnergyTileUnloadEvent;
import ic2.api.energy.tile.IEnergySink;
import ic2.api.energy.tile.IEnergyTile;
import ic2.api.tile.IWrenchable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.ForgeDirection;

public class TileEntityCobbleGenerator
extends TileEntity
implements ISidedInventory,
IWrenchable,
IEnergySink {
    private static final int MAX_STORED_ENERGY = 1000000;
    private static final int MAX_VOLTAGE = 2048;
    private int storedEnergy = 0;
    private int runningEUPerTick = 2048;
    private final int MAX_PROGRESS = 1000;
    public int energyUsed = 0;
    private ForgeDirection orientation;
    private Boolean isWorking = false;
    private Boolean enetPresent = false;
    public int energyPixels;
    public int progressPixels;
    public byte stackSize;
    public byte stackMeta;
    private ItemStack[] slots = new ItemStack[1];

    public TileEntityCobbleGenerator() {
        this.orientation = ForgeDirection.SOUTH;
    }

    public ForgeDirection getOrientation() {
        return this.orientation;
    }

    public void setOrientation(ForgeDirection orientation) {
        this.orientation = orientation;
    }

    public void setOrientation(int orientation) {
        this.orientation = ForgeDirection.getOrientation((int)orientation);
    }

    public boolean getWorkingState() {
        return this.isWorking;
    }

    public void setWorkingState(Boolean isWorking) {
        this.isWorking = isWorking;
    }

    public void setEnergyUsed(int energyUsed) {
        this.energyUsed = energyUsed;
    }

    public void func_145839_a(NBTTagCompound nbtTagCompound) {
        super.func_145839_a(nbtTagCompound);
        this.slots = new ItemStack[1];
        NBTTagList nbttaglist = nbtTagCompound.func_150295_c("teNBT", 10);
        for (int i = 0; i < nbttaglist.func_74745_c(); ++i) {
            NBTTagCompound nbttagcompound1 = nbttaglist.func_150305_b(i);
            byte b0 = nbttagcompound1.func_74771_c("Slot");
            if (b0 < 0 || b0 >= 1) continue;
            this.slots[b0] = ItemStack.func_77949_a((NBTTagCompound)nbttagcompound1);
        }
        if (nbtTagCompound.func_74764_b("teDirection")) {
            this.orientation = ForgeDirection.getOrientation((int)nbtTagCompound.func_74771_c("teDirection"));
        }
        if (nbtTagCompound.func_74764_b("teWorking")) {
            this.isWorking = nbtTagCompound.func_74767_n("teWorking");
        }
        if (nbtTagCompound.func_74764_b("teEnergyStored")) {
            this.storedEnergy = nbtTagCompound.func_74762_e("teEnergyStored");
        }
        if (nbtTagCompound.func_74764_b("teEnergyUsed")) {
            this.energyUsed = nbtTagCompound.func_74762_e("teEnergyUsed");
        }
    }

    public void func_145841_b(NBTTagCompound nbtTagCompound) {
        super.func_145841_b(nbtTagCompound);
        NBTTagList tagList = new NBTTagList();
        for (int currentIndex = 0; currentIndex < 1; ++currentIndex) {
            if (this.slots[currentIndex] == null) continue;
            NBTTagCompound tagCompound = new NBTTagCompound();
            tagCompound.func_74774_a("Slot", (byte)currentIndex);
            this.slots[currentIndex].func_77955_b(tagCompound);
            tagList.func_74742_a((NBTBase)tagCompound);
        }
        nbtTagCompound.func_74782_a("teNBT", (NBTBase)tagList);
        nbtTagCompound.func_74774_a("teDirection", (byte)this.orientation.ordinal());
        nbtTagCompound.func_74757_a("teWorking", this.isWorking.booleanValue());
        nbtTagCompound.func_74768_a("teEnergyStored", this.storedEnergy);
        nbtTagCompound.func_74768_a("teEnergyUsed", this.energyUsed);
    }

    public int func_70302_i_() {
        return 1;
    }

    public ItemStack func_70301_a(int slot) {
        return this.slots[slot];
    }

    public ItemStack func_70298_a(int i, int j) {
        ItemStack itemStack = this.func_70301_a(i);
        if (itemStack != null) {
            if (itemStack.field_77994_a <= j) {
                this.func_70299_a(i, null);
            } else {
                itemStack = this.slots[i].func_77979_a(j);
                if (itemStack.field_77994_a == 0) {
                    this.func_70299_a(i, null);
                }
            }
        }
        return itemStack;
    }

    public ItemStack func_70304_b(int p_70304_1_) {
        return null;
    }

    public void func_70299_a(int slotIndex, ItemStack itemStack) {
        this.slots[slotIndex] = itemStack;
        if (itemStack != null && itemStack.field_77994_a > this.func_70297_j_()) {
            itemStack.field_77994_a = this.func_70297_j_();
        }
    }

    public String func_145825_b() {
        return null;
    }

    public boolean func_145818_k_() {
        return false;
    }

    public int func_70297_j_() {
        return 64;
    }

    public boolean func_70300_a(EntityPlayer player) {
        return this.field_145850_b.func_147438_o(this.field_145851_c, this.field_145848_d, this.field_145849_e) == this && player.func_70092_e((double)this.field_145851_c + 0.5, (double)this.field_145848_d + 0.5, (double)this.field_145849_e + 0.5) <= 64.0;
    }

    public void func_70295_k_() {
    }

    public void func_70305_f() {
    }

    public boolean func_94041_b(int p_94041_1_, ItemStack p_94041_2_) {
        return false;
    }

    public boolean wrenchCanSetFacing(EntityPlayer entityPlayer, int side) {
        return side > 1 && side != this.orientation.ordinal();
    }

    public short getFacing() {
        return (short)this.orientation.ordinal();
    }

    public void setFacing(short facing) {
        this.setOrientation(facing);
        this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
    }

    public boolean wrenchCanRemove(EntityPlayer entityPlayer) {
        return this.orientation.ordinal() > 1;
    }

    public float getWrenchDropRate() {
        return 0.9f;
    }

    public ItemStack getWrenchDrop(EntityPlayer entityPlayer) {
        return new ItemStack(this.func_145838_q());
    }

    public double getDemandedEnergy() {
        return this.storedEnergy < 1000000 ? 2048.0 : 0.0;
    }

    public int getSinkTier() {
        return 4;
    }

    public double injectEnergy(ForgeDirection directionFrom, double amount, double voltage) {
        if (this.storedEnergy >= 1000000) {
            return amount;
        }
        this.storedEnergy += Math.min(2048, (int)amount);
        return amount - (double)Math.min(2048, (int)amount);
    }

    public boolean acceptsEnergyFrom(TileEntity emitter, ForgeDirection direction) {
        return true;
    }

    public int getEnergyStored() {
        return this.storedEnergy;
    }

    public void setStoredEnergy(int storedEnergy) {
        this.storedEnergy = storedEnergy;
    }

    public void func_145843_s() {
        if (!this.field_145850_b.field_72995_K && this.enetPresent.booleanValue()) {
            MinecraftForge.EVENT_BUS.post((Event)new EnergyTileUnloadEvent((IEnergyTile)this));
            this.enetPresent = false;
        }
        super.func_145843_s();
    }

    public void onChunkUnload() {
        if (!this.field_145850_b.field_72995_K && this.enetPresent.booleanValue()) {
            MinecraftForge.EVENT_BUS.post((Event)new EnergyTileUnloadEvent((IEnergyTile)this));
            this.enetPresent = false;
        }
        super.onChunkUnload();
    }

    public void func_145845_h() {
        super.func_145845_h();
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        if (!this.enetPresent.booleanValue()) {
            MinecraftForge.EVENT_BUS.post((Event)new EnergyTileLoadEvent((IEnergyTile)this));
            this.enetPresent = true;
        }
        if (this.storedEnergy < this.runningEUPerTick) {
            return;
        }
        this.storedEnergy -= this.runningEUPerTick;
        this.addItemStacktoOutput();
        this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        this.func_70296_d();
    }

    public int getScaledEnergy() {
        return this.storedEnergy * 13 / 1000000;
    }

    public int getScaledProgress() {
        return this.energyUsed * 22 / 1000;
    }

    public int[] func_94128_d(int side) {
        int[] nArray;
        if (side == ForgeDirection.UP.ordinal()) {
            nArray = new int[]{};
        } else {
            int[] nArray2 = new int[1];
            nArray = nArray2;
            nArray2[0] = 0;
        }
        return nArray;
    }

    public boolean func_102007_a(int slotIndex, ItemStack itemStack, int side) {
        return false;
    }

    public boolean func_102008_b(int slotIndex, ItemStack itemStack, int side) {
        return true;
    }

    public void addItemStacktoOutput() {
        ItemStack cobbleStack = new ItemStack(Blocks.field_150347_e);
        int maxStackSize = Math.min(this.func_70297_j_(), cobbleStack.func_77976_d());
        if (this.slots[0] == null) {
            this.slots[0] = cobbleStack.func_77946_l();
        } else if (this.slots[0].func_77973_b() == cobbleStack.func_77973_b()) {
            if (this.slots[0].field_77994_a < maxStackSize) {
                this.slots[0].field_77994_a += 64;
            }
        } else {
            return;
        }
    }
}

