/*
 * Decompiled with CFR 0.152.
 */
package com.estebes.compactic2generators.tileentity.machine;

import com.estebes.compactic2generators.network.PacketHandler;
import com.estebes.compactic2generators.network.message.MessageTileEntityElectricTank;
import com.estebes.compactic2generators.tileentity.TileEntityBaseMachine;
import cpw.mods.fml.common.eventhandler.Event;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import ic2.api.energy.event.EnergyTileLoadEvent;
import ic2.api.energy.event.EnergyTileUnloadEvent;
import ic2.api.energy.tile.IEnergySink;
import ic2.api.energy.tile.IEnergyTile;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.Packet;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidHandler;

public class TileEntityElectricTank
extends TileEntityBaseMachine
implements IFluidHandler,
IEnergySink {
    private FluidTank tank = new FluidTank(128000);
    private int fluidID;
    private int amount;
    private boolean enetChecker;
    private int storedEnergy = 0;
    private final int ENERGY_COST_PER_TICK = 1;
    private final int MAX_STORED_ENERGY = 16384;
    private final int MAX_VOLTAGE = 32;

    public void func_145843_s() {
        if (!this.field_145850_b.field_72995_K && this.enetChecker) {
            MinecraftForge.EVENT_BUS.post((Event)new EnergyTileUnloadEvent((IEnergyTile)this));
            this.enetChecker = false;
        }
        super.func_145843_s();
    }

    public void onChunkUnload() {
        if (!this.field_145850_b.field_72995_K && this.enetChecker) {
            MinecraftForge.EVENT_BUS.post((Event)new EnergyTileUnloadEvent((IEnergyTile)this));
            this.enetChecker = false;
        }
        super.onChunkUnload();
    }

    public void func_145845_h() {
        super.func_145845_h();
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        if (!this.enetChecker) {
            MinecraftForge.EVENT_BUS.post((Event)new EnergyTileLoadEvent((IEnergyTile)this));
            this.enetChecker = true;
        }
        if (this.storedEnergy < 1) {
            return;
        }
        --this.storedEnergy;
        this.func_70296_d();
    }

    @Override
    public void func_145839_a(NBTTagCompound nbtTagCompound) {
        super.func_145839_a(nbtTagCompound);
        this.tank.readFromNBT(nbtTagCompound.func_74775_l("teTank"));
        if (nbtTagCompound.func_74764_b("teEnergyStored")) {
            this.storedEnergy = nbtTagCompound.func_74762_e("teEnergyStored");
        }
    }

    @Override
    public void func_145841_b(NBTTagCompound nbtTagCompound) {
        super.func_145841_b(nbtTagCompound);
        NBTTagCompound tankTag = new NBTTagCompound();
        this.tank.writeToNBT(tankTag);
        nbtTagCompound.func_74782_a("teTank", (NBTBase)tankTag);
        nbtTagCompound.func_74768_a("teEnergyStored", this.storedEnergy);
    }

    public int fill(ForgeDirection from, FluidStack resource, boolean doFill) {
        if (!this.canFill(from, resource.getFluid())) {
            return 0;
        }
        return this.tank.fill(resource, doFill);
    }

    public FluidStack drain(ForgeDirection from, FluidStack resource, boolean doDrain) {
        if (resource == null || !resource.isFluidEqual(this.tank.getFluid())) {
            return null;
        }
        if (!this.canDrain(from, resource.getFluid())) {
            return null;
        }
        return this.tank.drain(resource.amount, doDrain);
    }

    public FluidStack drain(ForgeDirection from, int maxDrain, boolean doDrain) {
        return this.tank.drain(maxDrain, doDrain);
    }

    public boolean canFill(ForgeDirection from, Fluid fluid) {
        if (this.storedEnergy < this.ENERGY_COST_PER_TICK) {
            return false;
        }
        return fluid != null;
    }

    public boolean canDrain(ForgeDirection from, Fluid fluid) {
        if (this.storedEnergy < this.ENERGY_COST_PER_TICK) {
            return false;
        }
        FluidStack fluidStack = this.tank.getFluid();
        if (fluidStack == null) {
            return false;
        }
        return fluidStack.isFluidEqual(new FluidStack(fluid, 1));
    }

    public FluidTankInfo[] getTankInfo(ForgeDirection from) {
        return new FluidTankInfo[]{this.tank.getInfo()};
    }

    public FluidTank getTank() {
        return this.tank;
    }

    public void setTankFluid(int fluidID) {
        this.fluidID = fluidID;
    }

    public void setTankAmount(int amount) {
        this.amount = amount;
    }

    public void setTank(int doSet) {
        if (doSet == 1) {
            if (this.fluidID == -1) {
                this.tank.setFluid(null);
            } else {
                this.tank.setFluid(new FluidStack(this.fluidID, this.amount));
            }
        }
    }

    public int getStoredEnergy() {
        return this.storedEnergy;
    }

    public void setStoredEnergy(int value) {
        this.storedEnergy = value;
    }

    public int getScaledEnergy() {
        return this.storedEnergy * 51 / 16384;
    }

    public double getDemandedEnergy() {
        return this.storedEnergy < 16384 ? 32.0 : 0.0;
    }

    public int getSinkTier() {
        return 1;
    }

    public double injectEnergy(ForgeDirection directionFrom, double amount, double voltage) {
        if (this.storedEnergy >= 16384) {
            return amount;
        }
        this.storedEnergy += Math.min(32, (int)amount);
        return amount - (double)Math.min(32, (int)amount);
    }

    public boolean acceptsEnergyFrom(TileEntity emitter, ForgeDirection direction) {
        return true;
    }

    @Override
    public Packet func_145844_m() {
        return PacketHandler.INSTANCE.getPacketFrom((IMessage)new MessageTileEntityElectricTank(this));
    }
}

