/*
 * Decompiled with CFR 0.152.
 */
package com.estebes.compactic2generators.gui;

import com.estebes.compactic2generators.inventory.ContainerElectricTank;
import com.estebes.compactic2generators.reference.Reference;
import com.estebes.compactic2generators.tileentity.machine.TileEntityElectricTank;
import java.util.ArrayList;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.util.IIcon;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fluids.FluidStack;
import org.lwjgl.opengl.GL11;

public class GuiElectricTank
extends GuiContainer {
    public static final ResourceLocation TEXTURE = new ResourceLocation(Reference.LOWERCASE_MOD_ID, "textures/gui/GUIElectricTank.png");
    private TileEntityElectricTank tile;
    float mouseX;
    float mouseY;

    public GuiElectricTank(InventoryPlayer inventoryPlayer, TileEntityElectricTank tile) {
        super((Container)new ContainerElectricTank((IInventory)inventoryPlayer, tile));
        this.tile = tile;
        System.out.println(tile.getStoredEnergy());
    }

    protected void func_146979_b(int x, int y) {
        this.field_146289_q.func_78276_b("Electric Tank", this.field_146999_f / 2 - this.field_146289_q.func_78256_a("Electric Tank") / 2, 6, 0x404040);
        int k = (this.field_146294_l - this.field_146999_f) / 2;
        int l = (this.field_146295_m - this.field_147000_g) / 2;
        if (this.mouseX > (float)(this.field_147003_i + 63) && this.mouseX < (float)(this.field_147003_i + 112) && this.mouseY > (float)(this.field_147009_r + 17) && this.mouseY < (float)(this.field_147009_r + 65)) {
            ArrayList<String> list = new ArrayList<String>();
            list.add(this.tile.getTank().getFluidAmount() + "/" + this.tile.getTank().getCapacity() + " MB");
            this.drawHoveringText(list, (int)this.mouseX - k, (int)this.mouseY - l, this.field_146297_k.field_71466_p);
        }
    }

    protected void func_146976_a(float opacity, int x, int y) {
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.field_146297_k.field_71446_o.func_110577_a(TEXTURE);
        int xStart = (this.field_146294_l - this.field_146999_f) / 2;
        int yStart = (this.field_146295_m - this.field_147000_g) / 2;
        this.func_73729_b(xStart, yStart, 0, 0, this.field_146999_f, this.field_147000_g);
        this.drawFluid(this.tile.getTank().getFluid(), this.field_147003_i + 64, this.field_147009_r + 18, 48, 47, this.tile.getTank().getCapacity());
        this.field_146297_k.field_71446_o.func_110577_a(TEXTURE);
        this.func_73729_b(this.field_147003_i + 64, this.field_147009_r + 18, 176, 0, 48, 47);
        this.func_73729_b(this.field_147003_i + 153, this.field_147009_r + 67 - this.tile.getScaledEnergy(), 176, 107 - this.tile.getScaledEnergy(), 14, this.tile.getScaledEnergy());
    }

    public void drawFluid(FluidStack fluid, int x, int y, int width, int height, int maxCapacity) {
        int i;
        if (fluid == null || fluid.getFluid() == null) {
            return;
        }
        IIcon icon = fluid.getFluid().getIcon(fluid);
        if (icon == null) {
            icon = ((TextureMap)Minecraft.func_71410_x().func_110434_K().func_110581_b(TextureMap.field_110575_b)).func_110572_b("missingno");
        }
        this.field_146297_k.field_71446_o.func_110577_a(TextureMap.field_110575_b);
        GuiElectricTank.setGLColorFromInt(fluid.getFluid().getColor(fluid));
        int fullX = width / 16;
        int fullY = height / 16;
        int lastX = width - fullX * 16;
        int lastY = height - fullY * 16;
        int level = fluid.amount * height / maxCapacity;
        int fullLvl = (height - level) / 16;
        int lastLvl = height - level - fullLvl * 16;
        for (i = 0; i < fullX; ++i) {
            for (int j = 0; j < fullY; ++j) {
                if (j < fullLvl) continue;
                this.drawCutIcon(icon, x + i * 16, y + j * 16, 16, 16, j == fullLvl ? lastLvl : 0);
            }
        }
        for (i = 0; i < fullX; ++i) {
            this.drawCutIcon(icon, x + i * 16, y + fullY * 16, 16, lastY, fullLvl == fullY ? lastLvl : 0);
        }
        for (i = 0; i < fullY; ++i) {
            if (i < fullLvl) continue;
            this.drawCutIcon(icon, x + fullX * 16, y + i * 16, lastX, 16, i == fullLvl ? lastLvl : 0);
        }
        this.drawCutIcon(icon, x + fullX * 16, y + fullY * 16, lastX, lastY, fullLvl == fullY ? lastLvl : 0);
    }

    private void drawCutIcon(IIcon icon, int x, int y, int width, int height, int cut) {
        Tessellator tess = Tessellator.field_78398_a;
        tess.func_78382_b();
        tess.func_78374_a((double)x, (double)(y + height), (double)this.field_73735_i, (double)icon.func_94209_e(), (double)icon.func_94207_b((double)height));
        tess.func_78374_a((double)(x + width), (double)(y + height), (double)this.field_73735_i, (double)icon.func_94214_a((double)width), (double)icon.func_94207_b((double)height));
        tess.func_78374_a((double)(x + width), (double)(y + cut), (double)this.field_73735_i, (double)icon.func_94214_a((double)width), (double)icon.func_94207_b((double)cut));
        tess.func_78374_a((double)x, (double)(y + cut), (double)this.field_73735_i, (double)icon.func_94209_e(), (double)icon.func_94207_b((double)cut));
        tess.func_78381_a();
    }

    public static void setGLColorFromInt(int color) {
        float red = (float)(color >> 16 & 0xFF) / 255.0f;
        float green = (float)(color >> 8 & 0xFF) / 255.0f;
        float blue = (float)(color & 0xFF) / 255.0f;
        GL11.glColor4f((float)red, (float)green, (float)blue, (float)1.0f);
    }

    public void func_73863_a(int par1, int par2, float par3) {
        this.mouseX = par1;
        this.mouseY = par2;
        super.func_73863_a(par1, par2, par3);
    }
}

