package mffs.projectors;

import immibis.core.Side;
import mffs.CoordinateList;
import static mffs.projectors.TileProjector.*;

public class FFShapeTube extends FFShape {

	public FFShapeTube(TileProjector tile, short facing, int length, int radius, short mode_designe) {
		super(tile);
		
		this.facing = facing;
		this.length = length;
		this.radius = radius;
		this.mode_designe = mode_designe;
		
		int cx = radius, cy = radius, cz = radius;
		switch(facing) {
		case Side.NX: case Side.PX: cx = length; break;
		case Side.NY: case Side.PY: cy = length; break;
		case Side.NZ: case Side.PZ: cz = length; break;
		default: throw new RuntimeException("facing invalid direction "+facing);
		}
		
		minx = centX - cx;
		miny = centY - cy;
		minz = centZ - cz;
		maxx = centX + cx;
		maxy = centY + cy;
		maxz = centZ + cz;
		
		if(mode_designe == 2) {
			switch(facing) {
			case Side.NX: maxx = centX; break;
			case Side.NY: maxy = centY; break;
			case Side.NZ: maxz = centZ; break;
			case Side.PX: minx = centX; break;
			case Side.PY: miny = centY; break;
			case Side.PZ: minz = centZ; break;
			}
		}
		
		if(dome)
			miny = centY;
	}
	
	private final int length, radius;
	private final short facing, mode_designe;
	
	private int minx, miny, minz, maxx, maxy, maxz;

	@Override
	public void getFieldBlocks(CoordinateList list) {
		for(int x = minx; x <= maxx; x++)
			for(int y = miny; y <= maxy; y++)
				for(int z = minz; z <= maxz; z++) {
					int mode = getBlockMode(x, y, z);
					if(mode == MODE_FIELD || mode == MODE_GAP)
						list.add(x, y, z, mode);
				}
	}

	@Override
	public int getBlockMode(int x, int y, int z) {
		if(x < minx || x > maxx || y < miny || y > maxy || z < minz || z > maxz)
			return 0;
		
		if((x == minx || x == maxx) && facing != Side.NX && facing != Side.PX)
			return MODE_FIELD;
		if(((y == miny && !dome) || y == maxy) && facing != Side.NY && facing != Side.PY)
			return MODE_FIELD;
		if((z == minz || z == maxz) && facing != Side.NZ && facing != Side.PZ)
			return MODE_FIELD;
		return MODE_GAP;
	}

}
