/*
 * Decompiled with CFR 0.152.
 */
package bloodasp.gregtechextras.tank;

import bloodasp.gregtechextras.tank.BlockTank;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Random;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.client.event.RenderWorldLastEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fluids.FluidRegistry;
import org.lwjgl.opengl.GL11;

@SideOnly(value=Side.CLIENT)
public class TankHalo
extends TileEntity {
    private static TankHalo instance = new TankHalo();
    private static Set<XYZ> lamps;
    static final double HALO_SIZE = (double)0.9f;
    private static final double BB_MIN = (double)-0.9f;
    private static final double BB_MAX = (double)1.9f;
    private static final int ALPHA = 128;

    private TankHalo() {
    }

    static void addLamp(IBlockAccess w, int x, int y, int z) {
        XYZ tmp = new XYZ(x, y, z);
        if (!lamps.contains(tmp)) {
            lamps.add(new XYZ(x, y, z));
        }
    }

    @SubscribeEvent
    public void onRenderWorldLast(RenderWorldLastEvent evt) {
        WorldClient w = Minecraft.func_71410_x().field_71441_e;
        ArrayList<XYZ> toRemove = null;
        GL11.glBlendFunc((int)770, (int)1);
        GL11.glDisable((int)3553);
        GL11.glEnable((int)3042);
        GL11.glPushMatrix();
        GL11.glDepthMask((boolean)false);
        Tessellator t = Tessellator.field_78398_a;
        EntityLivingBase view = Minecraft.func_71410_x().field_71451_h;
        if (view != null) {
            double pt = evt.partialTicks;
            double x = view.field_70169_q + (view.field_70165_t - view.field_70169_q) * pt;
            double y = view.field_70167_r + (view.field_70163_u - view.field_70167_r) * pt;
            double z = view.field_70166_s + (view.field_70161_v - view.field_70166_s) * pt;
            GL11.glTranslated((double)(-x), (double)(-y), (double)(-z));
        }
        t.func_78382_b();
        for (XYZ pos : lamps) {
            Block block = w.func_147439_a(pos.x, pos.y, pos.z);
            if (block instanceof BlockTank) {
                int colour = w.func_72805_g(pos.x, pos.y, pos.z);
                TankHalo.renderHalo(t, pos.x, pos.y, pos.z, colour);
                continue;
            }
            if (toRemove == null) {
                toRemove = new ArrayList<XYZ>();
            }
            toRemove.add(pos);
        }
        t.func_78381_a();
        if (toRemove != null) {
            for (XYZ pos : toRemove) {
                lamps.remove(pos);
                System.out.println("REmove lamps!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!");
            }
        }
        GL11.glBlendFunc((int)770, (int)771);
        GL11.glEnable((int)3553);
        GL11.glColor3f((float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glDisable((int)3042);
        GL11.glPopMatrix();
        GL11.glDepthMask((boolean)true);
    }

    static void renderHalo(Tessellator t, double x, double y, double z, int colourNumber) {
        TankHalo.renderHalo(t, colourNumber, x + (double)-0.9f, x + (double)1.9f, y + (double)-0.9f, y + (double)3.8f, z + (double)-0.9f, z + (double)1.9f);
    }

    static void renderHalo(Tessellator t, double x, double y, double z, int colourNumber, AxisAlignedBB bb) {
        TankHalo.renderHalo(t, colourNumber, x + bb.field_72340_a, x + bb.field_72336_d, y + bb.field_72338_b, y + bb.field_72337_e, z + bb.field_72339_c, z + bb.field_72334_f);
    }

    static void renderHalo(Tessellator t, int colourNumber, double x1, double x2, double y1, double y2, double z1, double z2) {
        int colour = FluidRegistry.WATER.getDensity();
        colour = 255;
        t.func_78384_a(colour, FluidRegistry.WATER.getDensity());
        t.func_78377_a(x1, y2, z1);
        t.func_78377_a(x2, y2, z1);
        t.func_78377_a(x2, y1, z1);
        t.func_78377_a(x1, y1, z1);
        t.func_78377_a(x1, y1, z1);
        t.func_78377_a(x1, y1, z2);
        t.func_78377_a(x1, y2, z2);
        t.func_78377_a(x1, y2, z1);
        t.func_78377_a(x1, y1, z1);
        t.func_78377_a(x2, y1, z1);
        t.func_78377_a(x2, y1, z2);
        t.func_78377_a(x1, y1, z2);
        t.func_78377_a(x1, y1, z2);
        t.func_78377_a(x2, y1, z2);
        t.func_78377_a(x2, y2, z2);
        t.func_78377_a(x1, y2, z2);
        t.func_78377_a(x2, y2, z1);
        t.func_78377_a(x2, y2, z2);
        t.func_78377_a(x2, y1, z2);
        t.func_78377_a(x2, y1, z1);
        t.func_78377_a(x1, y2, z2);
        t.func_78377_a(x2, y2, z2);
        t.func_78377_a(x2, y2, z1);
        t.func_78377_a(x1, y2, z1);
    }

    static {
        MinecraftForge.EVENT_BUS.register((Object)instance);
        lamps = new HashSet<XYZ>();
    }

    private static class XYZ {
        public final int x;
        public final int y;
        public final int z;
        private static int[] randomTable = new int[256];

        public XYZ(int x, int y, int z) {
            this.x = x;
            this.y = y;
            this.z = z;
        }

        public int hashCode() {
            return randomTable[this.x & 0xFF] ^ randomTable[this.y & 0xFF] ^ randomTable[this.z & 0xFF];
        }

        public boolean equals(Object o) {
            if (o instanceof XYZ) {
                XYZ a = (XYZ)o;
                return this.x == a.x && this.y == a.y && this.z == a.z;
            }
            return false;
        }

        static {
            Random r = new Random();
            for (int k = 0; k < randomTable.length; ++k) {
                XYZ.randomTable[k] = r.nextInt();
            }
        }
    }
}

