/*
 * Decompiled with CFR 0.152.
 */
package gttweaker.mods.gregtech;

import gregtech.api.enums.GT_Values;
import minetweaker.IUndoableAction;
import minetweaker.MineTweakerAPI;
import minetweaker.OneWayAction;
import minetweaker.annotations.ModOnly;
import minetweaker.api.item.IItemStack;
import minetweaker.api.liquid.ILiquidStack;
import minetweaker.api.minecraft.MineTweakerMC;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;

@ZenClass(value="mods.gregtech.BlastFurnace")
@ModOnly(value={"gregtech"})
public class Blastfurnace {
    @ZenMethod
    public static void addRecipe(IItemStack[] output, ILiquidStack fluidInput, IItemStack[] input, int durationTicks, int euPerTick, int heat) {
        if (output.length == 0) {
            MineTweakerAPI.logError((String)"Blast furnace recipe requires at least 1 input");
        } else {
            MineTweakerAPI.apply((IUndoableAction)new AddFluidRecipeAction(output, fluidInput, input, durationTicks, euPerTick, heat));
        }
    }

    @ZenMethod
    public static void addRecipe(IItemStack[] output, IItemStack[] input, int durationTicks, int euPerTick, int heat) {
        if (output.length == 0) {
            MineTweakerAPI.logError((String)"Blast furnace recipe requires at least 1 input");
        } else {
            MineTweakerAPI.apply((IUndoableAction)new AddRecipeAction(output, input, durationTicks, euPerTick, heat));
        }
    }

    private static class AddFluidRecipeAction
    extends OneWayAction {
        private final IItemStack[] output;
        private final ILiquidStack fluidInput;
        private final IItemStack[] input;
        private final int duration;
        private final int euPerTick;
        private final int heat;

        public AddFluidRecipeAction(IItemStack[] output, ILiquidStack fluidInput, IItemStack[] input, int duration, int euPerTick, int heat) {
            this.output = output;
            this.fluidInput = fluidInput;
            this.input = input;
            this.duration = duration;
            this.euPerTick = euPerTick;
            this.heat = heat;
        }

        public void apply() {
            GT_Values.RA.addBlastRecipe(MineTweakerMC.getItemStack((IItemStack)this.input[0]), this.input.length > 1 ? MineTweakerMC.getItemStack((IItemStack)this.input[1]) : null, MineTweakerMC.getLiquidStack((ILiquidStack)this.fluidInput), MineTweakerMC.getLiquidStack(null), MineTweakerMC.getItemStack((IItemStack)this.output[0]), this.output.length > 1 ? MineTweakerMC.getItemStack((IItemStack)this.output[1]) : null, this.duration, this.euPerTick, this.heat);
        }

        public String describe() {
            return "Adding Blast furnace recipe for " + this.output;
        }

        public Object getOverrideKey() {
            return null;
        }

        public int hashCode() {
            int hash = 4;
            hash = 67 * hash + (this.output != null ? this.output.hashCode() : 0);
            hash = 67 * hash + (this.fluidInput != null ? this.fluidInput.hashCode() : 0);
            hash = 67 * hash + (this.input != null ? this.input.hashCode() : 0);
            hash = 67 * hash + this.duration;
            hash = 67 * hash + this.euPerTick;
            hash = 67 * hash + this.heat;
            return hash;
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (((Object)((Object)this)).getClass() != obj.getClass()) {
                return false;
            }
            AddFluidRecipeAction other = (AddFluidRecipeAction)((Object)obj);
            if (!(this.output == other.output || this.output != null && this.output.equals(other.output))) {
                return false;
            }
            if (!(this.input == other.input || this.input != null && this.input.equals(other.input))) {
                return false;
            }
            if (!(this.fluidInput == other.fluidInput || this.fluidInput != null && this.fluidInput.equals(other.fluidInput))) {
                return false;
            }
            if (this.duration != other.duration) {
                return false;
            }
            if (this.euPerTick != other.euPerTick) {
                return false;
            }
            return this.heat == other.heat;
        }
    }

    private static class AddRecipeAction
    extends OneWayAction {
        private final IItemStack[] output;
        private final IItemStack[] input;
        private final int duration;
        private final int euPerTick;
        private final int heat;

        public AddRecipeAction(IItemStack[] output, IItemStack[] input, int duration, int euPerTick, int heat) {
            this.output = output;
            this.input = input;
            this.duration = duration;
            this.euPerTick = euPerTick;
            this.heat = heat;
        }

        public void apply() {
            GT_Values.RA.addBlastRecipe(MineTweakerMC.getItemStack((IItemStack)this.input[0]), this.input.length > 1 ? MineTweakerMC.getItemStack((IItemStack)this.input[1]) : null, MineTweakerMC.getLiquidStack(null), MineTweakerMC.getLiquidStack(null), MineTweakerMC.getItemStack((IItemStack)this.output[0]), this.output.length > 1 ? MineTweakerMC.getItemStack((IItemStack)this.output[1]) : null, this.duration, this.euPerTick, this.heat);
        }

        public String describe() {
            return "Adding Blast furnace recipe for " + this.output;
        }

        public Object getOverrideKey() {
            return null;
        }
    }
}

