/*
 * Decompiled with CFR 0.152.
 */
package gttweaker.mods.gregtech;

import gregtech.api.enums.GT_Values;
import minetweaker.IUndoableAction;
import minetweaker.MineTweakerAPI;
import minetweaker.OneWayAction;
import minetweaker.annotations.ModOnly;
import minetweaker.api.item.IItemStack;
import minetweaker.api.liquid.ILiquidStack;
import minetweaker.api.minecraft.MineTweakerMC;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;

@ZenClass(value="mods.gregtech.ChemicalReactor")
@ModOnly(value={"gregtech"})
public class ChemicalReactor {
    @ZenMethod
    public static void addRecipe(IItemStack output, ILiquidStack fluidOutput1, IItemStack input1, IItemStack input2, ILiquidStack fluidInput1, int durationTicks) {
        MineTweakerAPI.apply((IUndoableAction)new AddFluidRecipeAction(output, fluidOutput1, input1, input2, fluidInput1, durationTicks));
    }

    @ZenMethod
    public static void addRecipe(IItemStack output, IItemStack input1, IItemStack input2, int durationTicks) {
        MineTweakerAPI.apply((IUndoableAction)new AddRecipeAction(output, input1, input2, durationTicks));
    }

    private static class AddFluidRecipeAction
    extends OneWayAction {
        private final IItemStack output;
        private final ILiquidStack fluidOutput1;
        private final IItemStack input1;
        private final IItemStack input2;
        private final ILiquidStack fluidInput1;
        private final int duration;

        public AddFluidRecipeAction(IItemStack output, ILiquidStack fluidOutput1, IItemStack input1, IItemStack input2, ILiquidStack fluidInput1, int duration) {
            this.output = output;
            this.fluidOutput1 = fluidOutput1;
            this.input1 = input1;
            this.input2 = input2;
            this.fluidInput1 = fluidInput1;
            this.duration = duration;
        }

        public void apply() {
            GT_Values.RA.addChemicalRecipe(MineTweakerMC.getItemStack((IItemStack)this.input1), MineTweakerMC.getItemStack((IItemStack)this.input2), MineTweakerMC.getLiquidStack((ILiquidStack)this.fluidInput1), MineTweakerMC.getLiquidStack((ILiquidStack)this.fluidOutput1), MineTweakerMC.getItemStack((IItemStack)this.output), this.duration);
        }

        public String describe() {
            return "Adding Chemical Reactor recipe with Liquid support for " + this.output;
        }

        public Object getOverrideKey() {
            return null;
        }

        public int hashCode() {
            int hash = 7;
            hash = 12 * hash + (this.output != null ? this.output.hashCode() : 0);
            hash = 12 * hash + (this.fluidOutput1 != null ? this.fluidOutput1.hashCode() : 0);
            hash = 12 * hash + (this.input1 != null ? this.input1.hashCode() : 0);
            hash = 12 * hash + (this.input2 != null ? this.input2.hashCode() : 0);
            hash = 12 * hash + (this.fluidInput1 != null ? this.fluidInput1.hashCode() : 0);
            hash = 12 * hash + this.duration;
            return hash;
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (((Object)((Object)this)).getClass() != obj.getClass()) {
                return false;
            }
            AddFluidRecipeAction other = (AddFluidRecipeAction)((Object)obj);
            if (!(this.output == other.output || this.output != null && this.output.equals(other.output))) {
                return false;
            }
            if (!(this.fluidOutput1 == other.fluidOutput1 || this.fluidOutput1 != null && this.fluidOutput1.equals(other.fluidOutput1))) {
                return false;
            }
            if (!(this.input1 == other.input1 || this.input1 != null && this.input1.equals(other.input1))) {
                return false;
            }
            if (!(this.input2 == other.input2 || this.input2 != null && this.input2.equals(other.input2))) {
                return false;
            }
            if (!(this.fluidInput1 == other.fluidInput1 || this.fluidInput1 != null && this.fluidInput1.equals(other.fluidInput1))) {
                return false;
            }
            return this.duration == other.duration;
        }
    }

    private static class AddRecipeAction
    extends OneWayAction {
        private final IItemStack output;
        private final IItemStack input1;
        private final IItemStack input2;
        private final int duration;

        public AddRecipeAction(IItemStack output, IItemStack input1, IItemStack input2, int duration) {
            this.output = output;
            this.input1 = input1;
            this.input2 = input2;
            this.duration = duration;
        }

        public void apply() {
            GT_Values.RA.addChemicalRecipe(MineTweakerMC.getItemStack((IItemStack)this.input1), MineTweakerMC.getItemStack((IItemStack)this.input2), MineTweakerMC.getItemStack((IItemStack)this.output), this.duration);
        }

        public String describe() {
            return "Adding Chemical Reactor recipe for " + this.output;
        }

        public Object getOverrideKey() {
            return null;
        }

        public int hashCode() {
            int hash = 7;
            hash = 11 * hash + (this.output != null ? this.output.hashCode() : 0);
            hash = 11 * hash + (this.input1 != null ? this.input1.hashCode() : 0);
            hash = 11 * hash + (this.input2 != null ? this.input2.hashCode() : 0);
            hash = 11 * hash + this.duration;
            return hash;
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (((Object)((Object)this)).getClass() != obj.getClass()) {
                return false;
            }
            AddRecipeAction other = (AddRecipeAction)((Object)obj);
            if (!(this.output == other.output || this.output != null && this.output.equals(other.output))) {
                return false;
            }
            if (!(this.input1 == other.input1 || this.input1 != null && this.input1.equals(other.input1))) {
                return false;
            }
            if (!(this.input2 == other.input2 || this.input2 != null && this.input2.equals(other.input2))) {
                return false;
            }
            return this.duration == other.duration;
        }
    }
}

